#include "InterruptedFileSearch.h"
#include "QtellaSub.h"
#include "Connections.h"
#include "Search.h"
#include "QueryHitEntry.h"

#include <qlistview.h>
#include <vector>

/* 
 *  Constructs a InterruptedFileSearch which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
InterruptedFileSearch::InterruptedFileSearch( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : BInterruptedFileSearch( parent, name, modal, fl )
{
  ui_listview->setSorting(-1);
  ui_listview->setColumnWidthMode(0, QListView::Maximum); // status
  ui_listview->setColumnWidthMode(1, QListView::Manual);  // filename
  ui_listview->setColumnWidthMode(2, QListView::Maximum); // size
  ui_listview->setColumnWidthMode(3, QListView::Maximum); // host
  ui_listview->setColumnWidthMode(4, QListView::Maximum); // vendor
  ui_listview->setColumnWidth(1, 35*10);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
InterruptedFileSearch::~InterruptedFileSearch()
{
    // no need to delete child widgets, Qt does it all for us
}

void InterruptedFileSearch::init(unsigned long filesize)
{
  QtellaSub* p = QtellaSub::getInstance();

  std::vector<Search*>::iterator pos;
  for(pos = p->connections->_search.begin(); pos != p->connections->_search.end(); ++pos)
    for(int i = 0; i < (*pos)->vSearchResults.size(); ++i)
      if((*pos)->vSearchResults[i]->size == filesize) 
	{
	  QListViewItem* src = (*pos)->vSearchResults[i]->item;

	  QListViewItem* item = new QListViewItem(ui_listview);

	  if( src->pixmap(1) ) item->setPixmap(0, *(src->pixmap(1))); // status
	  if( src->pixmap(2) ) item->setPixmap(1, *(src->pixmap(2)));
	  item->setText(1, src->text(2)); // filename
	  item->setText(2, src->text(4)); // filesize
	  item->setText(3, src->text(5)); // host
	  item->setText(4, src->text(6)); // vendor

	  //_file_list.push_back((*pos)->vSearchResults[i]);
	  _file_list[item] = (*pos)->vSearchResults[i];
	}
}

QueryHitEntry* InterruptedFileSearch::getSelectedQueryHit()
{
  if( ui_listview->currentItem() )
    return _file_list[ui_listview->currentItem()];

//   QListViewItem* item = ui_listview->firstChild();

//   int i = 0;
//   while( ui_listview->currentItem() != item ) 
//     {
//       item = item->itemBelow();
//       ++i;
//     }

//   return _file_list[i];

  return NULL;
}

void InterruptedFileSearch::slotResume()
{
  if( ui_listview->currentItem() ) emit accept();
}
