#include "Logging.h"
#include "QtellaSub.h"
#include "WidgetStats.h"
#include "WidgetLogs.h"

#include <qlistbox.h>
#include <qdatetime.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>

#include <iostream>
#include <fstream>

Logging* Logging::_instance = NULL;
#ifndef SHARP
QMutex Logging::_mutex;
#endif

Logging::Logging()
{
}

Logging* Logging::getInstance()
{
  if(!_instance) _instance = new Logging();
  return _instance;
}

void Logging::log(int loglevel, std::string msg)
{
#ifndef SHARP
  _mutex.lock();
#endif
  
  QtellaSub* p = QtellaSub::getInstance();

  std::string m = std::string(QTime::currentTime().toString().latin1()) + " " + msg;

  if(loglevel == 0) m += "/DEBUG";
  if(loglevel == 1) m += "/INFO";
  if(loglevel == 2) m += "/ERROR";

  if(p->_widget_logs->ui_checkbox_enablelogs->isChecked())
    if(loglevel >= p->_widget_logs->ui_combobox_loglevel->currentItem())
      {
        p->_widget_logs->ui_listbox_logs->insertItem( m.c_str() );
        while(p->_widget_logs->ui_listbox_logs->count() > 100) p->_widget_logs->ui_listbox_logs->removeItem(0);
        p->_widget_logs->ui_listbox_logs->setBottomItem(p->_widget_logs->ui_listbox_logs->count()-1);
      }

#ifndef SHARP
  if(p->_widget_logs->ui_checkbox_loginfile->isChecked())
    if(loglevel >= p->_widget_logs->ui_combobox_loglevel->currentItem())
      {
        std::fstream f;
        f.open(p->_widget_logs->ui_lineedit_logfile->text(), std::ios::out|std::ios::app);
        if(f.is_open())
          {
            f << m << std::endl;
            f.close();
          }
      }
#endif

#ifndef SHARP
  _mutex.unlock();
#endif
}
