#include "Message.h"
#include "Gnutella.h"

#include "Ping.h"
#include "Pong.h"
#include "Query.h"
#include "QueryHit.h"
#include "Push.h"
#include "Bye.h"

Message::Message( const std::vector< char >& data ) : _valid( false )
{
  int i;
  
  _data.resize( data.size() ); 
  for( i = 0; i < data.size(); ++i )
	_data[i] = data[i];
  
  if( data.size() < 23 ) return;

  _valid = true;

  _id.resize( 16 );
  for( i = 0; i < 16; ++i )
	_id[i] = data[i];

  _ttl = static_cast<Q_UINT8>((unsigned char)data[17]);
  _hops = static_cast<Q_UINT8>((unsigned char)data[18]);
  _cmd = static_cast<Q_UINT8>((unsigned char)data[16]);
  _payload = data.size() - 23;

  _payload_data.resize( data.size() - 23 );
  for( int j = 0; j < data.size() - 23; ++j )
	_payload_data[j] = data[ 23 + j ];
}

Message::Message( const std::string& data ) : _data(data), _valid(false)
{
  if( data.size() < 23 ) return;

  _valid = true;
  _id = data.substr(0, 16);
  _ttl = static_cast<Q_UINT8>((unsigned char)data[17]);
  _hops = static_cast<Q_UINT8>((unsigned char)data[18]);
  _cmd = static_cast<Q_UINT8>((unsigned char)data[16]);
  _payload = data.size() - 23;
  _payload_data = data.substr(23, data.size() - 23);
}

Message::Message()
{
}

Message::~Message()
{
}

const Q_UINT8 Message::cmd()
{
  return _cmd;
}

std::string Message::id()
{
  return _id;
}

const Q_UINT8 Message::ttl() 
{
  return _ttl;
}

const Q_UINT8 Message::hops()
{
  return _hops;
}

const Q_UINT32 Message::payload()
{
  return _payload;
}

void Message::inc_hops()
{
  ++_hops;
}

void Message::dec_ttl()
{
  --_ttl;
}

std::string Message::data()
{
  _data[17] = _ttl;
  _data[18] = _hops;
  return _data;
}

const Q_UINT32 Message::size()
{
  return _payload;
}

Ping* Message::getPing()
{
  Ping* p = new Ping(_ttl, _hops, _id);
  return p;
}

Pong* Message::getPong()
{
  Pong* p = new Pong(_ttl, _hops, _id, _payload_data);
  return p;
}

Query* Message::getQuery()
{
  Query* q = new Query(_ttl, _hops, _id, _payload_data);
  return q;
}

QueryHit* Message::getQueryHit()
{
  QueryHit* q = new QueryHit(_ttl, _hops, _id, _payload_data);
  return q;
}

Push* Message::getPush()
{
  Push* p = new Push(_ttl, _hops, _id, _payload_data);
  return p;
}

Bye* Message::getBye()
{
  Bye* p = new Bye( _payload_data );
  return p;
}

std::string Message::uint_str(Q_UINT8 value)
{
  std::string s;
  s.append((char*)&value, 1);
  return s;
}

std::string Message::uint_str(Q_UINT16 value)
{
  std::string s;
#ifdef WORDS_BIGENDIAN
  char str[2] = { (value & 0xff), ((value >> 8) & 0xff) };
  s.append(str, 2);
#else
  s.append((char*)&value, 2);
#endif
  return s;
}

std::string Message::uint_str(Q_UINT32 value)
{
  std::string s;
#ifdef WORDS_BIGENDIAN
  char str[4] = { (value & 0xff), ((value >> 8) & 0xff),
                  ((value >> 16) & 0xff), ((value >> 24) & 0xff) };
  s.append(str, 4);
#else
  s.append((char*)&value, 4);
#endif
  return s;
}

Q_UINT16 Message::str_uint16(std::string str)
{
  return str_uint16(str.c_str());
}

Q_UINT16 Message::str_uint16(const char *str)
{
#ifdef WORDS_BIGENDIAN
  return ((((unsigned )(str[1]) & 0xff) << 8) |
           ((unsigned )(str[0]) & 0xff));
#else
  return *((Q_UINT32*)str);
#endif
}

Q_UINT32 Message::str_uint32(std::string str)
{
  return str_uint32(str.c_str());
}

Q_UINT32 Message::str_uint32(const char *str)
{
#ifdef WORDS_BIGENDIAN
  return ( (((unsigned )(str[3]) & 0xff) << 24) |
           (((unsigned )(str[2]) & 0xff) << 16) |
           (((unsigned )(str[1]) & 0xff) << 8) |
            ((unsigned )(str[0]) & 0xff));
#else
  return *((Q_UINT32*)str);
#endif
}


Q_UINT32 Message::str_uint32( const std::vector<char>& v, const unsigned beg )
{
#ifdef WORDS_BIGENDIAN
  return ( (((unsigned )(v[beg+3]) & 0xff)) |
           (((unsigned )(v[beg+2]) & 0xff) << 8) |
           (((unsigned )(v[beg+1]) & 0xff) << 16) |
		   (((unsigned )(v[beg+0]) & 0xff) << 24) );
#else
  return ( (((unsigned )(v[beg+3]) & 0xff) << 24) |
           (((unsigned )(v[beg+2]) & 0xff) << 16) |
           (((unsigned )(v[beg+1]) & 0xff) << 8) |
            ((unsigned )(v[beg+0]) & 0xff));
#endif
}


const bool Message::isValid()
{
  if( ! _valid ) return false;

  switch(cmd())
    {
    case CMD_PING: if(_data.size() >= PING_SIZE) return true; else return false;
    case CMD_PONG: if(_data.size() >= PONG_SIZE) return true; else return false;
    case CMD_PUSH: if(_data.size() >= PUSH_SIZE) return true; else return false;
    case CMD_QUERY: if(_data.size() >= PUSH_SIZE) return true; else return false;
    case CMD_QUERYHIT: if(_data.size() >= QUERYHIT_SIZE) return true; else return false;
    }
  
  return false;
}




