#include "Gnutella.h"
#include "Pong.h"
#include "Message.h"

Pong::Pong(const Q_UINT8 ttl, const Q_UINT8 hops, const std::string id, Address& address, 
	   const Q_UINT32 files, const Q_UINT32 kbytes)
  : _id(id), _ttl(ttl), _hops(hops), _files(files), _kbytes(kbytes), _address(address)
{
  toString();
}


Pong::Pong(const Q_UINT8 ttl, const Q_UINT8 hops, const std::string id, const std::string payload)
  : _id(id), _ttl(ttl), _hops(hops)
{
  Q_UINT32  ip   = Message::str_uint32(payload.substr(2, 4).c_str());
  Q_UINT16  port = Message::str_uint16(payload.substr(0, 2).c_str());
  
  _files  = Message::str_uint32(payload.substr(6, 4).c_str());
  _kbytes = Message::str_uint32(payload.substr(10,4).c_str());

  _address = Address(ip, port);

  toString();
}


Pong::~Pong()
{
}

void Pong::toString()
{
  Q_UINT16 port    = _address.port();
  Q_UINT32 ip      = _address.longIP();
  Q_UINT32 payload = 14;

  _data = _id;

  _data += static_cast<char>(CMD_PONG);
  _data += static_cast<char>(_ttl);
  _data += static_cast<char>(_hops);

  _data.append( Message::uint_str(payload) );

  _data.append( Message::uint_str(port) );
  _data.append( Message::uint_str(ip) );
  _data.append( Message::uint_str(_files) );
  _data.append( Message::uint_str(_kbytes) );
}
