#include "Gnutella.h"
#include "Push.h"
#include "Message.h"

Push::Push(const Q_UINT8 ttl, const Q_UINT8 hops, std::string& id, std::string& payload)
  : _id(id), _ttl(ttl), _hops(hops)
{
  Q_UINT32 ip   = Message::str_uint32(payload.substr(20, 4).c_str());
  Q_UINT16 port = Message::str_uint16(payload.substr(24, 2).c_str());

  _address = Address(ip, port);
  _id_payload = payload.substr(0, 16);
  _index = Message::str_uint32(payload.substr(16, 4).c_str());

  toString();
}

Push::Push(const Q_UINT8 ttl, const Q_UINT8 hops, std::string& id, std::string& id_p, const Q_UINT32 index, const Address address)
  : _id(id), _ttl(ttl), _hops(hops), _id_payload(id_p), _index(index), _address(address)
{
  toString();
}

Push::Push()
{
}

void Push::toString()
{
  Q_UINT32  payload = 26;
  
  _data  = _id;

  _data += static_cast<char>(CMD_PUSH);
  _data += static_cast<char>(_ttl);
  _data += static_cast<char>(_hops);

  _data.append( Message::uint_str(payload) );

  _data.append(_id_payload);
  _data.append( Message::uint_str(_index) );

  Q_UINT16 port = _address.port();
  Q_UINT32 ip   = _address.longIP();
  _data.append( Message::uint_str(ip) );
  _data.append( Message::uint_str(port) );
}
