#include "GWebCacheManager.h"
#include "QtellaSub.h"
#include "Gnutella.h"
#include "SearchPersistence.h"

#include "Connections.h"
#include "StringManipulation.h"
#include "QueryHitEntry.h"
#include "SearchWidget.h"
#include "Search.h"
#include "SharedFile.h"
#include "UploadManager.h"
#include "DownloadManager.h"
#include "IncomingConnect.h"
#include "SharedViewItem.h"
#include "AddApplication.h"
#include "Download.h"
#include "HostCache.h"
#include "InterruptedDownloads.h"
#include "IconTabWidget.h"
#include "Icon.h"
#include "SearchSharedFiles.h"
#include "Interface.h"
#include "DeleteDialog.h"
#include "RenameFile.h"
#include "DownloadViewItem.h"

#include "WidgetConnections.h"
#include "WidgetSearch.h"
#include "WidgetDownloads.h"
#include "WidgetUploads.h"
#include "WidgetSharedFiles.h"
#include "WidgetConfig.h"
#include "WidgetInterrupted.h"
#include "WidgetStats.h"
#include "WidgetLogs.h"

#include <fstream>
#include <algorithm>
#include <iomanip>
#include <strstream>
#include <iostream>
#include <cctype>
#if !defined(_WIN32)
#include <unistd.h>
#endif
#ifdef SHARP
#include <qlayout.h>
#endif

#include <qrect.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qtabbar.h>
#include <qlabel.h>
#include <qfile.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qfiledialog.h>
#include <qcheckbox.h>
#ifndef SHARP
#include <qthread.h>
#endif
#include <qapplication.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qiconset.h>
#include <qpalette.h>
#include <qmessagebox.h>
#include <qwidget.h>
#include <qaccel.h>
#include <qpixmap.h>
#include <qworkspace.h>
#include <qvbox.h>

#include <signal.h>

#ifndef SHARP
#if QT_VERSION >= 300
#include <qstylefactory.h>
#endif
#endif

#ifdef USEKDE
#include "kmainwindow.h"
#include "ksystemtray.h"  /* system tray patch */
#include <krun.h>
#include <kopenwith.h>
#endif

#include <qtoolbar.h>
#include <qstringlist.h>

#include "qtella_mini_xpm.h" /* system tray patch */

#undef _DEBUG

QtellaSub* QtellaSub::_instance = NULL;

/* 
 *  Constructs a QtellaSub which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QtellaSub::QtellaSub( QApplication* parent,  const char* name, WFlags fl )
  : Qtella( 0, name, fl ), _binary(name)
{
  QPixmap connections_pixmap( ( std::string( PIXMAP_DIR ) + "/flash_icon.png" ).c_str() );
  QPixmap search_pixmap( ( std::string( PIXMAP_DIR ) + "/lens_icon.png" ).c_str() );
  QPixmap download_pixmap( ( std::string( PIXMAP_DIR ) + "/down_icon.png" ).c_str() );
  QPixmap upload_pixmap( ( std::string( PIXMAP_DIR ) + "/up_icon.png" ).c_str() );
  QPixmap shared_pixmap( ( std::string( PIXMAP_DIR ) + "/shared_icon.png" ).c_str() );
  QPixmap help_pixmap( ( std::string( PIXMAP_DIR ) + "/help_icon.png" ).c_str() );
  QPixmap stats_pixmap( ( std::string( PIXMAP_DIR ) + "/stats_icon.png" ).c_str() );
  QPixmap interrupt_pixmap( ( std::string( PIXMAP_DIR ) + "/interrupt_icon.png" ).c_str() );

#ifdef SHARP
  _widget_connections = new WidgetConnections( this, "", WStyle_Customize | WStyle_NoBorder );
  _widget_search = new WidgetSearch( this );
  _widget_downloads = new WidgetDownloads( this );
  _widget_uploads = new WidgetUploads( this );
  _widget_stats = new WidgetStats( this );
  _widget_config = new WidgetConfig( this );
  _widget_shared = new WidgetSharedFiles( this );
  _widget_interrupted = new WidgetInterrupted( this );
  _widget_logs = new WidgetLogs( this );

  _widget_connections->move( 0, 25 );
  _widget_search->move( 0, 25 );
  _widget_downloads->move( 0, 25 );
  _widget_uploads->move( 0, 25 );
  _widget_stats->move( 0, 25 );
  _widget_config->move( 0, 25 );
  _widget_shared->move( 0, 25 );
  _widget_interrupted->move( 0, 25 );
  _widget_logs->move( 0, 25 );
#else
	QVBox* vb = new QVBox( this );
	vb->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
	_workspace = new QWorkspace( vb );
	_workspace->setScrollBarsEnabled( true );
	setCentralWidget( vb );

  _widget_connections = new WidgetConnections( _workspace );
  _widget_search = new WidgetSearch( _workspace );
  _widget_downloads = new WidgetDownloads( _workspace );
  _widget_uploads = new WidgetUploads( _workspace );
  _widget_stats = new WidgetStats( _workspace );

  _widget_config = new WidgetConfig( _workspace );
	connect( _widget_config, SIGNAL(finished()), this, SLOT(slotApplyConfig()) );
	//connect( _widget_config, SIGNAL(cancel()), this, SLOT(slotCancelConfig()) );

  _widget_shared = new WidgetSharedFiles( _workspace );
  _widget_interrupted = new WidgetInterrupted( _workspace );
  _widget_logs = new WidgetLogs( _workspace );

	_widget_connections->setIcon( connections_pixmap );
	_widget_search->setIcon( search_pixmap );
	_widget_downloads->setIcon( download_pixmap );
	_widget_uploads->setIcon( upload_pixmap );
	_widget_stats->setIcon( stats_pixmap );
	_widget_shared->setIcon( shared_pixmap );
	_widget_interrupted->setIcon( interrupt_pixmap );
#endif

	// connections from buttons of "directories" to slots
	connect( _widget_config->button_change_hostlist, SIGNAL(clicked()), SLOT(slotChangeHostlistFile()) );
	connect( _widget_config->button_add_directory, SIGNAL(clicked()), SLOT(slotAddDirectory()) );
	connect( _widget_config->button_remove_directory, SIGNAL(clicked()), SLOT(slotRemoveDirectory()) );
	connect( _widget_config->button_change_incomplete, SIGNAL(clicked()), SLOT(slotChangeInterrupted()) );
	connect( _widget_config->button_change_audio, SIGNAL(clicked()), SLOT(slotChangeFinishedAudio()) );
	connect( _widget_config->button_change_video, SIGNAL(clicked()), SLOT(slotChangeFinishedVideo()) );
	connect( _widget_config->button_change_image, SIGNAL(clicked()), SLOT(slotChangeFinishedImage()) );
	connect( _widget_config->button_change_any, SIGNAL(clicked()), SLOT(slotChangeFinishedAny()) );

	// network
	connect( _widget_config->button_add_blocked_host, SIGNAL(clicked()), SLOT(slotAddBlockedHost()) );
	connect( _widget_config->button_delete_blocked_host, SIGNAL(clicked()), SLOT(slotDeleteBlockedHost()) );

	// files
	connect( _widget_config->button_add_application, SIGNAL(clicked()), SLOT(slotAddApplication()) );
	connect( _widget_config->button_edit_application, SIGNAL(clicked()), SLOT(slotEditApplication()) );
	connect( _widget_config->button_remove_application, SIGNAL(clicked()), SLOT(slotRemoveApplication()) );
	
	// button of "Connections" window
	connect( _widget_connections->button_addautoconnect, SIGNAL(clicked()), SLOT(slotAddAutoConnect()) );
	connect( _widget_connections->button_remove_autoconnect, SIGNAL(clicked()), SLOT(slotRemoveAutoConnect()) );
	connect( _widget_connections->button_update_autoconnect, SIGNAL(clicked()), SLOT(slotUpdateAutoConnect()) );
	connect( _widget_connections->button_add_host, SIGNAL(clicked()), SLOT(slotAddHost()) );
	connect( _widget_connections->button_read_file, SIGNAL(clicked()), SLOT(slotReadFile()) );

	// "Search" window
	connect( _widget_search->button_search, SIGNAL(clicked()), SLOT(slotSearch()) );
	//connect( _widget_search->ui_combobox_search, SIGNAL(activated(const QString& s)), SLOT(slotSearch(s)) );
	connect( _widget_search->button_resubmit_search, SIGNAL(clicked()), SLOT(slotResubmitSearch()) );
	connect( _widget_search->button_download, SIGNAL(clicked()), SLOT(slotDownloadAll()) );
																																		
  _widget_connections->hide();
  _widget_search->hide();
  _widget_downloads->hide();
  _widget_uploads->hide();
  _widget_stats->hide();
  _widget_config->hide();
  _widget_shared->hide();
  _widget_interrupted->hide();
  _widget_logs->hide();

	//_widget_connections->show();

  connect( _widget_config, SIGNAL(finished()), SLOT(slotApplyConfig()) );

#ifdef USEKDE
  KSystemTray *tray = new KSystemTray(this,"qtella");
  tray->setPixmap(QPixmap((const char **)qtella_mini_xpm));
  tray->setAlignment(Qt::AlignCenter);
  tray->show();
#endif

  int i;
  int j;

  _prev_version = "";
  _search_column_size = 350;
  _instance = this;
  _incoming_allowed = false;

#ifndef SHARP
  _style_s = "default";
  _current_font = qApp->font();

#ifdef USEKDE
  _style = new KPopupMenu(this);
#endif

#ifdef QT
  _style = new QPopupMenu(this);
#endif
#endif

#ifndef SHARP
#if QT_VERSION < 300
  _style->insertItem("&Platinum", this, SLOT(slotStylePlatinum()), 0, 0);
  _style->insertItem("&SGI", this, SLOT(slotStyleSGI()), 0, 1);
  _style->insertItem("&Windows", this, SLOT(slotStyleWindows()), 0, 2);
  _style->insertItem("&Motif", this, SLOT(slotStyleMotif()), 0, 3);
  _style->insertItem("Motif&Plus", this, SLOT(slotStyleMotifPlus()), 0, 4);
  _style->insertItem("&CDE", this, SLOT(slotStyleCDE()), 0, 5);
#ifdef USEKDE
  _style->insertItem("&KDE", this, SLOT(slotStyleKDE()), 0, 6);
#endif
#else
  QStringList styles = QStyleFactory::keys();
  for(QStringList::ConstIterator it=styles.begin(); it!=styles.end(); it++) 
    {
      int id=_style->insertItem("&" + *it, this, SLOT(slotStyle(int)));
      _style->setItemParameter(id, id);
    }
#endif
  _style->insertSeparator();
  _style->insertItem( QObject::tr("&Font"), this, SLOT(slotChangeFont()));

  _style->setCheckable(true);
#endif // SHARP

#ifdef USEKDE
  _help = new KPopupMenu(this);
#endif

#ifdef QT
  _help = new QPopupMenu(this);
#endif

  _help->insertItem( QObject::tr("&Info"), this, SLOT(slotInfo()));


#ifdef USEKDE
  _file = new KPopupMenu(this);
#endif

#ifdef QT
  _file = new QPopupMenu(this);
#endif

//   _file->insertItem( QObject::tr("&Connect"), this, SLOT(slotConnect()));
//   _file->insertItem( QObject::tr("&Disconnect"), this, SLOT(slotDisconnect()));
//   _file->insertSeparator();
//   _file->insertItem( QObject::tr("&Settings"), this, SLOT(slotSettings()) );
//   _file->insertSeparator();
//   _file->insertItem( QObject::tr("E&xit"), parent, SLOT(quit()));

  _file->insertItem( QObject::tr("&Connect"), this, SLOT(slotConnect()));
  _file->insertItem( QObject::tr("&Disconnect"), this, SLOT(slotDisconnect()));
  _file->insertSeparator();
  _file->insertItem( QObject::tr("&Settings"), this, SLOT(slotSettings()) );
  _file->insertSeparator();
  _file->insertItem( QObject::tr("E&xit"), parent, SLOT(quit()));

// #ifdef USEKDE
//   _view = new KPopupMenu(this);
// #endif

// #ifdef QT
//   _view = new QPopupMenu(this);
// #endif

//   _view->insertItem( QObject::tr("Connections"), 1);
//   _view->insertItem( QObject::tr("Search"), 2);
//   _view->insertItem( QObject::tr("Downloads"), 3);
//   _view->insertItem( QObject::tr("Uploads"), 4);
//   _view->insertItem( QObject::tr("Shared Files"), 5);
//   _view->insertItem( QObject::tr("Logs"), 6);
//   _view->insertItem( QObject::tr("Statistics"), 7);
//   _view->insertItem( QObject::tr("Hostcache"), 8);
//   _view->insertItem( QObject::tr("Interrupted Downloads"), 9);
  //_view->insertItem( QObject::tr("Configuration"), 10);

//   connect(_view, SIGNAL(activated(int)), SLOT(slotViewChanged(int)));
//   _view->setCheckable(true);

//   for(i = 1; i < 11; ++i)
//     _view->setItemChecked(i, true);
  
#ifdef USEKDE
  menu = new KMenuBar(this);
#endif

#ifdef QT
  menu = new QMenuBar(this);
#endif

  menu->insertItem( QObject::tr("&File"), _file);
#ifndef SHARP
  menu->insertItem( QObject::tr("&Style"), _style);
//   menu->insertItem( QObject::tr("&View"), _view);
  menu->insertSeparator();
  menu->insertItem( QObject::tr("&Help"), _help);
#endif

  menu->insertItem( connections_pixmap, CONNECTIONS_ICON_ID );
  menu->insertItem( search_pixmap, SEARCH_ICON_ID );
  menu->insertItem( download_pixmap, DOWNLOAD_ICON_ID );
  menu->insertItem( upload_pixmap, UPLOAD_ICON_ID );
  menu->insertItem( shared_pixmap, SHARED_ICON_ID );
  menu->insertItem( stats_pixmap, STATS_ICON_ID );
  menu->insertItem( interrupt_pixmap, INTERRUPTED_ICON_ID );
  menu->insertItem( help_pixmap, HELP_ICON_ID );

  connect( menu, SIGNAL(activated(int)), SLOT(slotMenu(int)) );

#ifndef SHARP
  _palette = qApp->palette();
  _menu_palette = menu->palette();
#endif

  
  std::strstream str;
  str << "Qtella - " << VERSION << ADDITIONAL_VERSION_STR << " - www.qtella.net" 
#ifndef SHARP
  << " (Daniel Etzold)" // just for my ego but for the Zaurus it's too much ;))
#endif
  << std::ends;
  std::string caption = str.str();
  str.freeze(false);
  setCaption( caption.c_str() );

  connections = new Connections(this);

  timer_connection = new QTimer(this);
  connect(timer_connection, SIGNAL(timeout()), this, SLOT(check_connections()));

// #ifndef SHARP
  connect((QObject*)_widget_connections->ui_pushbutton_remove, SIGNAL(clicked()), (QObject*)connections, SLOT(slotRemoveHost()));
// #endif
  connect((QObject*)_widget_connections->ui_spinbox_hosts, SIGNAL(valueChanged(int)), (QObject*)connections, SLOT(slotMaxServents(int)));
  connect((QObject*)_widget_connections->ui_pushbutton_listclear, SIGNAL(clicked()), (QObject*)connections, SLOT(slotListClear()));
  connect((QObject*)_widget_connections->ui_pushbutton_listconnect, SIGNAL(clicked()), (QObject*)connections, SLOT(slotListConnect()));
  connect((QObject*)_widget_connections->ui_pushbutton_listremove, SIGNAL(clicked()), (QObject*)connections, SLOT(slotListRemove()));


  _widget_downloads->ui_listview_download->setColumnWidthMode(0, QListView::Manual);  // filename
  _widget_downloads->ui_listview_download->setColumnWidthMode(1, QListView::Maximum); // status
  _widget_downloads->ui_listview_download->setColumnWidthMode(2, QListView::Maximum); // size
  _widget_downloads->ui_listview_download->setColumnWidthMode(3, QListView::Maximum); // progress 
  _widget_downloads->ui_listview_download->setColumnWidthMode(4, QListView::Maximum); // host
  _widget_downloads->ui_listview_download->setColumnWidthMode(5, QListView::Maximum); // bandwidth
  _widget_downloads->ui_listview_download->setColumnWidthMode(6, QListView::Maximum); // Time
  _widget_downloads->ui_listview_download->setColumnWidthMode(7, QListView::Maximum); // Client
  _widget_downloads->ui_listview_download->setColumnWidth(0, 16*10);
  _widget_downloads->ui_listview_download->setColumnAlignment(0, AlignLeft);
  _widget_downloads->ui_listview_download->setColumnAlignment(1, AlignLeft);
  _widget_downloads->ui_listview_download->setColumnAlignment(2, AlignRight);
  _widget_downloads->ui_listview_download->setColumnAlignment(3, AlignRight);
  _widget_downloads->ui_listview_download->setColumnAlignment(4, AlignRight);
  _widget_downloads->ui_listview_download->setColumnAlignment(5, AlignRight);
  _widget_downloads->ui_listview_download->setColumnAlignment(6, AlignRight);
  _widget_downloads->ui_listview_download->setColumnAlignment(7, AlignLeft);
  _widget_downloads->ui_listview_download->setSorting(0);
  _widget_downloads->ui_listview_download->setColumnWidth(0, 30*10);
  _widget_downloads->ui_listview_download->setRootIsDecorated(true);

  _widget_connections->ui_listview_connections->setColumnWidthMode(0, QListView::Maximum); // host
  _widget_connections->ui_listview_connections->setColumnWidthMode(1, QListView::Maximum); // status
  _widget_connections->ui_listview_connections->setColumnWidthMode(2, QListView::Maximum); // messages (i/o)
  _widget_connections->ui_listview_connections->setColumnWidthMode(3, QListView::Maximum); // bandwidth
  _widget_connections->ui_listview_connections->setColumnWidthMode(4, QListView::Maximum); // uptime
  _widget_connections->ui_listview_connections->setColumnWidthMode(5, QListView::Maximum); // protocol
  _widget_connections->ui_listview_connections->setColumnWidthMode(6, QListView::Maximum); // user agent
  _widget_connections->ui_listview_connections->setColumnAlignment(0, AlignLeft);
  _widget_connections->ui_listview_connections->setColumnAlignment(1, AlignLeft);
  _widget_connections->ui_listview_connections->setColumnAlignment(2, AlignHCenter);
  _widget_connections->ui_listview_connections->setColumnAlignment(3, AlignHCenter);
  _widget_connections->ui_listview_connections->setColumnAlignment(4, AlignHCenter);
  _widget_connections->ui_listview_connections->setColumnAlignment(5, AlignRight);
  _widget_connections->ui_listview_connections->setColumnAlignment(6, AlignHCenter);
  _widget_connections->ui_listview_connections->setSorting(-1);

  _widget_shared->ui_listview_shared->setColumnWidthMode(0, QListView::Manual);  // filename
  _widget_shared->ui_listview_shared->setColumnWidthMode(1, QListView::Maximum); // uploads
  _widget_shared->ui_listview_shared->setColumnWidthMode(2, QListView::Maximum); // requests
  _widget_shared->ui_listview_shared->setColumnWidthMode(3, QListView::Maximum); // size
  _widget_shared->ui_listview_shared->setColumnAlignment(0, AlignLeft);
  _widget_shared->ui_listview_shared->setColumnWidth(0, 46*10);
  _widget_shared->ui_listview_shared->setColumnWidth(1, 5*10);
  _widget_shared->ui_listview_shared->setColumnWidth(2, 5*10);
  _widget_shared->ui_listview_shared->setColumnWidth(3, 10*10);
  _widget_shared->ui_listview_shared->setSorting(0);

  _widget_uploads->ui_listview_uploads->setColumnWidthMode(0, QListView::Manual);  // filename
  _widget_uploads->ui_listview_uploads->setColumnWidthMode(1, QListView::Maximum); // status
  _widget_uploads->ui_listview_uploads->setColumnWidthMode(2, QListView::Maximum); // host
  _widget_uploads->ui_listview_uploads->setColumnWidthMode(3, QListView::Maximum); // progress
  _widget_uploads->ui_listview_uploads->setColumnWidthMode(4, QListView::Maximum); // bandwidth
  _widget_uploads->ui_listview_uploads->setColumnWidthMode(5, QListView::Maximum); // time
  _widget_uploads->ui_listview_uploads->setColumnAlignment(0, AlignLeft);
  _widget_uploads->ui_listview_uploads->setColumnWidth(0, 29*10);
  _widget_uploads->ui_listview_uploads->setColumnWidth(1, 10*10);
  _widget_uploads->ui_listview_uploads->setColumnWidth(2, 10*10);
  _widget_uploads->ui_listview_uploads->setColumnWidth(5, 7*10);

  _widget_interrupted->ui_listview_interrupt->setColumnWidthMode(0, QListView::Manual);  // filename
  _widget_interrupted->ui_listview_interrupt->setColumnWidthMode(1, QListView::Maximum); // type
  _widget_interrupted->ui_listview_interrupt->setColumnWidthMode(2, QListView::Maximum); // size
  _widget_interrupted->ui_listview_interrupt->setColumnWidthMode(3, QListView::Maximum); // progress
  _widget_interrupted->ui_listview_interrupt->setColumnWidthMode(4, QListView::Maximum); // host
  _widget_interrupted->ui_listview_interrupt->setColumnAlignment(0, AlignLeft);
  _widget_interrupted->ui_listview_interrupt->setColumnWidth(0, 30*10);
  _widget_interrupted->ui_listview_interrupt->setColumnWidth(1, 7*10);
  _widget_interrupted->ui_listview_interrupt->setColumnWidth(2, 7*10);
  _widget_interrupted->ui_listview_interrupt->setColumnWidth(3, 7*10);
  _widget_interrupted->ui_listview_interrupt->setColumnWidth(4, 10*10);
  _widget_interrupted->ui_listview_interrupt->setRootIsDecorated(true);

  _widget_config->ui_listview_apps->setColumnWidthMode(0, QListView::Maximum);
  _widget_config->ui_listview_apps->setColumnWidthMode(1, QListView::Maximum);
  _widget_config->ui_listview_apps->setColumnWidth(0, 10*10);
  _widget_config->ui_listview_apps->setColumnWidth(1, 10*10);

  // initialise extensions for images, videos and music
  _widget_config->ui_lineedit_images->setText(IMAGES);
  _widget_config->ui_lineedit_video->setText(VIDEOS);
  _widget_config->ui_lineedit_audio->setText(MUSIC);

#ifndef SHARP
  _hostcache = NULL;
#endif

  // read configuration
  readConfiguration();

#ifndef SHARP  
  // set style settings
#if QT_VERSION < 300
  if( _style_s == "PLATINUM" ) slotStylePlatinum();
  if( _style_s == "SGI" ) slotStyleSGI();
  if( _style_s == "WINDOWS" ) slotStyleWindows();
  if( _style_s == "MOTIF" ) slotStyleMotif();
  if( _style_s == "MOTIFPLUS" ) slotStyleMotifPlus();
  if( _style_s == "CDE" ) slotStyleCDE();
#endif
#endif

#ifndef SHARP
  // get interface address
  _ip_update_timer = new QTimer(this);
  connect(_ip_update_timer, SIGNAL(timeout()), this, SLOT(slotIPUpdate()));
  connect(_widget_config->ui_pushbutton_updateip, SIGNAL(pressed()), SLOT(slotIPUpdate()));
  _ip_update_timer->start(_widget_config->ui_spinbox_updateinterval->value(), 10000);

  Interface inf;
  std::vector<std::string> if_vect;
  if_vect.push_back( std::string( QObject::tr("automatic", "network interface").latin1() ) );
  if_vect.push_back( std::string( QObject::tr("manual", "network interface").latin1() ) );
  if_vect.push_back( std::string( QObject::tr("file", "network interface").latin1() ) );
#if !defined(_WIN32)
  if_vect.push_back( std::string( QObject::tr("hostname", "network interface").latin1() ) );
#endif

  std::string if_default[] = {"eth0", "ppp0", "ippp0"};
  inf.getIfList(if_vect);


  for(j = 0; j < if_vect.size(); ++j) _widget_config->ui_combobox_interface->insertItem(if_vect[j].c_str());
  _widget_config->ui_combobox_interface->setCurrentItem( 0 );

  if(_pref_if == std::string( QObject::tr("manual", "network interface").latin1() ))
    {
      _widget_config->ui_lineedit_ip->setText(_last_addr.c_str());
      _widget_config->ui_combobox_interface->setCurrentItem( 1 );
    }
  else
    if( _pref_if == std::string( QObject::tr("hostname", "network interface").latin1() ) || 
        _pref_if == std::string( QObject::tr("file", "network interface").latin1() )     ||
        _pref_if == std::string( QObject::tr("automatic", "network interface").latin1() ) )
      {
        if( _pref_if == std::string( QObject::tr("file", "network interface").latin1() ) )
          _widget_config->ui_combobox_interface->setCurrentItem( 2 );
        if( _pref_if == std::string( QObject::tr("hostname", "network interface").latin1() ) )
          _widget_config->ui_combobox_interface->setCurrentItem( 3 );
        slotIPUpdate();
      }
    else
      {
        _widget_config->ui_lineedit_ip->setEnabled(false);
	
        std::string if_addr = "127.0.0.1";
        
        for(j = 0; j < 3; ++j)
          for(int k = 0; k < if_vect.size(); ++k)
            if(if_default[j] == if_vect[k])
              {
                _widget_config->ui_combobox_interface->setCurrentItem(k);
                if_addr = inf.getIfAddress(if_default[j]);
              }
        
        for(j = 0; j < if_vect.size(); ++j)
          if(_pref_if == if_vect[j])
            {
              _widget_config->ui_combobox_interface->setCurrentItem(j);
              if_addr = inf.getIfAddress(_pref_if);
              break;
            }
        
        if(if_addr.empty()) if_addr = "127.0.0.1";
        _widget_config->ui_lineedit_ip->setText(if_addr.c_str());
      }
#else
  _pref_if = "automatic";
  slotIPUpdate();
#endif

  // catch signal 13, PIPE BROKEN
#if !defined(_WIN32)
  struct sigaction sa;
  memset((void *)&sa, 0, sizeof(struct sigaction));
  sigemptyset(&sa.sa_mask);
  sa.sa_flags = 0;
  sa.sa_handler = SIG_IGN;
  sigaction(SIGPIPE, &sa, NULL);
#endif

  // initialize list of shared files
  slotRefreshSharedList();


  search_tabs = 0;
  // IconTabWidget is inherited by QTabWidget
  // first we create an empty QTabWidget

	QLayout* l = _widget_search->layout();
	QGridLayout* gd = (QGridLayout*) l;
  _widget_search->ui_tabwidget_search = new IconTabWidget( _widget_search, "ui_tabwidget_search");
	gd->addWidget( _widget_search->ui_tabwidget_search, 1, 0 );

  //_widget_search->ui_tabwidget_search = new IconTabWidget( page_search, "ui_tabwidget_search");
//_widget_search->ui_tabwidget_search = new IconTabWidget( _widget_search, "ui_tabwidget_search");

  //_widget_search->ui_tabwidget_search->setGeometry( 1, 1, 235, 210 );
  connect(_widget_search->ui_tabwidget_search, SIGNAL(iconPressed()), SLOT(slotCloseSearch()));
  connect(_widget_search->ui_tabwidget_search, SIGNAL(sigCurrentChanged(QWidget*)), SLOT(slotCurrentChanged(QWidget*)));
  
#ifndef SHARP
  // ui_tabwidget_search->tab is the initial empty tab for searching
  //_widget_search->page_searchLayout->addWidget( _widget_search->ui_tabwidget_search, 1, 0 );
  _widget_search->ui_tabwidget_search->removePage(_widget_search->tab);
  delete _widget_search->tab;
  _widget_search->tab = new SearchWidget(this);
  
  connect(_widget_search->tab, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotSearchDoubleClicked(QListViewItem*)));
  connect(_widget_search->tab, SIGNAL(rightButton(QListViewItem*, const QPoint&, int)), this, 
					SLOT(slotShowSearchContext(QListViewItem*, const QPoint&, int)));
  
  _widget_search->ui_tabwidget_search->addTab(_widget_search->tab, "");
  _widget_search->ui_tabwidget_search->showPage(_widget_search->tab);
	
  //_widget_search->ui_tabwidget_search->setMaximumSize( _widget_search->ui_tabwidget_search->maximumSize() );
#else
  // delete the tab which we created with the designer
  delete _widget_search->tab;
  // create a tab with an empty search listview
  _widget_search->tab = new SearchWidget( this );
  _widget_search->ui_tabwidget_search->setGeometry( 1, 1, 237, 210 );

  _widget_search->ui_tabwidget_search->addTab( _widget_search->tab, "" );
  _widget_search->ui_tabwidget_search->showPage( _widget_search->tab );
#endif


  // init IncomingConnect
  _current_port = 6346;
  std::vector<std::string>    str_ports;
  std::vector<unsigned int>   ports;
#ifndef SHARP
  StringManipulation          sm(std::string(_widget_config->ui_lineedit_listenport->text().latin1()));
#else
  StringManipulation          sm( "6346" );
#endif
  int                         n = 0;

  sm.split_to_vector(str_ports, ',');
  _incoming_connect = NULL;

  do
    {
      std::strstream str_p;
      str_p << str_ports[n++] << std::ends;
      unsigned p;
      str_p >> p;

      _incoming_connect = new IncomingConnect(p, 10);

      if( ! _incoming_connect->ok() ) 
        {
          delete _incoming_connect;
          _incoming_connect = NULL;
        }
      else
        {
          _current_port = p;
          break;
        }
    }
  while(n < str_ports.size());

  if( ! _incoming_connect )
    {
      std::strstream str;
      str << QObject::tr("Cannot bind to ports:") << std::endl << std::endl;
      for(i = 0; i < str_ports.size(); ++i) 
        {
          str << str_ports[i];
          if( i+1 < str_ports.size() ) str << std::endl;
        }
      str << std::ends;
      QMessageBox::warning(this, QObject::tr("Incomming connection bind error"), str.str(), QMessageBox::Ok, 0);
      str.freeze(false);
    }

// #ifndef SHARP
  // hostcache is obsolete, it's going to be removed in the future
  // init hostcache
//   if( ui_checkbox_enablehostcache->isChecked() )
//     {
//       _hostcache = new HostCache(ui_spinbox_hostcacheport->value(), 100, this);
//       if( !_hostcache->ok() ) 
// 		{
// 		  std::strstream str;
// 		  str << QObject::tr("Cannot bind to port") << " " << ui_spinbox_hostcacheport->value() << std::ends;
// 		  QMessageBox::warning(this, QObject::tr("HostCache bind error"), str.str(), QMessageBox::Ok, 0);
// 		  str.freeze(false);
// 		}
//     }
// #endif

  // init upload manager
  upload_manager = new UploadManager(this);

  // init download manager
  download_manager = new DownloadManager(this);

  QObject *o = (QObject*)download_manager;

  connect((QObject*)_widget_downloads->ui_pushbutton_abortdownload, SIGNAL(clicked()), o, SLOT(slotAbortDownload()));
  connect((QObject*)_widget_downloads->ui_pushbutton_removedownload, SIGNAL(clicked()), o, SLOT(slotRemoveDownload()));
  connect((QObject*)_widget_downloads->ui_pushbutton_resumedownload, SIGNAL(clicked()), o, SLOT(slotResumeDownload()));
  connect((QObject*)_widget_downloads->ui_pushbutton_clearinactive, SIGNAL(clicked()), o, SLOT(slotClearInactive()));

  _gWebCache = new GWebCacheManager(this);

  // read host list
  readHostList();

  // connect if "on start auto-connect" is checked
  if( _widget_config->ui_checkbox_conf_autoconnect->isChecked()) slotConnect();

  // download context menu
#ifndef SHARP
  _context_download = new QPopupMenu( _widget_downloads, QObject::tr("Download") );

  _context_download->insertItem( QObject::tr("Properties"), o, SLOT(slotDownloadProperties()), 
				 QAccel::stringToKey( QObject::tr("CTRL+P") ) );
  _context_download->insertItem( QObject::tr("Launch"), this, SLOT(slotLaunchSelectedDownloadItem()), 
				 QAccel::stringToKey( QObject::tr("CTRL+L") ) );
  _context_download->insertItem( QObject::tr("Move into Directory"), o, SLOT(slotMoveDownloads()), 
				 QAccel::stringToKey( QObject::tr("CTRL+M") ) );
  _context_download->insertSeparator();
  _context_download->insertItem( QObject::tr("Abort"), o, SLOT(slotAbortDownload()), 
				 QAccel::stringToKey( QObject::tr("CTRL+A") ) );
  _context_download->insertItem( QObject::tr("Remove from list"), o, SLOT(slotRemoveDownload()), 
				 QAccel::stringToKey( QObject::tr("CTRL+R") ) );
  _context_download->insertItem( QObject::tr("Delete from disc"), this, SLOT(slotDeleteDownload()), 
				 QAccel::stringToKey( QObject::tr("CTRL+Del") ) );
  _context_download->insertItem( QObject::tr("Resume"), o, SLOT(slotResumeDownload()), 
				 QAccel::stringToKey( QObject::tr("CTRL+S") ) );
  _context_download->insertSeparator();
  _context_download->insertItem( QObject::tr("Clear Inactive"), o, SLOT(slotClearInactive()), 
				 QAccel::stringToKey( QObject::tr("CTRL+C") ) );

  // begin: the following slots are implemented in QtellaSubSlotsContext.cpp
  // search context menu
  _context_search = new QPopupMenu( _widget_search, QObject::tr("Search") );

  _context_search->insertItem( QObject::tr("Download"), this, SLOT(slotDownloadAll()), 
			       QAccel::stringToKey( QObject::tr("CTRL+D") ) );
  _context_search->insertItem( QObject::tr("Download to"), this, SLOT(slotDownloadTo()), 
			       QAccel::stringToKey( QObject::tr("CTRL+T") ) );
  _context_search->insertSeparator();
  _context_search->insertItem( QObject::tr("Abort Download"), this, SLOT(slotSearchStopDownload()), 
			       QAccel::stringToKey( QObject::tr("CTRL+A") ) );
  _context_search->insertItem( QObject::tr("Remove from Download List"), this, SLOT(slotSearchRemoveDownload()), 
			       QAccel::stringToKey( QObject::tr("CTRL+R") ) );
  _context_search->insertItem( QObject::tr("Delete from disc"), this, SLOT(slotSearchDeleteDownload()), 
			       QAccel::stringToKey( QObject::tr("CTRL+Del") ) );
  _context_search->insertSeparator();
  _context_search->insertItem( QObject::tr("Block Host"), this, SLOT(slotBlockHost()), 
			       QAccel::stringToKey( QObject::tr("CTRL+B") ) );

  // upload context menu
  _context_upload = new QPopupMenu( _widget_uploads, QObject::tr("Upload") );

  _context_upload->insertItem( QObject::tr("Abort"), this, SLOT(slotAbortUpload()), 
			       QAccel::stringToKey( QObject::tr("CTRL+A") ) );
  _context_upload->insertItem( QObject::tr("Remove"), this, SLOT(slotRemoveUpload()), 
			       QAccel::stringToKey( QObject::tr("CTRL+R") ) );
  _context_upload->insertItem( QObject::tr("Block host"), this, SLOT(slotUploadBlockHost()), 
			       QAccel::stringToKey( QObject::tr("CTRL+B") ) );
  _context_upload->insertSeparator();
  _context_upload->insertItem( QObject::tr("Clear Inactive"), this, SLOT(slotClearInactiveUploads()), 
			       QAccel::stringToKey( QObject::tr("CTRL+C") ) );

  // shared files context menu
  _context_shared = new QPopupMenu( _widget_shared, QObject::tr("Shared Files") );

  _context_shared->insertItem( QObject::tr("Launch"), this, SLOT(slotSharedFilesLaunch()), 
			       QAccel::stringToKey( QObject::tr("CTRL+L") ) );
  _context_shared->insertItem( QObject::tr("Properties"), this, SLOT(slotSharedProperties()), 
			       QAccel::stringToKey( QObject::tr("CTRL+P") ) );
  _context_shared->insertItem( QObject::tr("Update List"), this, SLOT(slotRefreshSharedList()), 
			       QAccel::stringToKey( QObject::tr("CTRL+U" ) ) );
  _context_shared->insertItem( QObject::tr("Delete from disc"), this, SLOT(slotDeleteSharedFile()), 
			       QAccel::stringToKey( QObject::tr("CTRL+Del") ) );
  _context_shared->insertItem( QObject::tr("Rename file"), this, SLOT(slotRenameSharedFile()), 
			       QAccel::stringToKey( QObject::tr("CTRL+N") ) );
  // end

  // connect context menu
  _context_connect = new QPopupMenu( _widget_connections, QObject::tr("Connections") );

  _context_connect->insertItem( QObject::tr("Add to AutoConnect"), this, SLOT(slotAddHostAutoConnect()), 
				QAccel::stringToKey( QObject::tr("CTRL+A") ) );
  _context_connect->insertItem( QObject::tr("Disconnect"), (QObject*)connections, SLOT(slotRemoveHost()), 
				QAccel::stringToKey( QObject::tr("CTRL+D") ) );
  _context_connect->insertItem( QObject::tr("Block Host"), (QObject*)connections, SLOT(slotBlockHost()), 
				QAccel::stringToKey( QObject::tr("CTRL+B") ) );
  _context_connect->insertItem( QObject::tr("Show Handshake"), (QObject*)connections, SLOT(slotShowHandshake()), 
				QAccel::stringToKey( QObject::tr("CTRL+H") ) );
#endif
  _interrupted_downloads = new InterruptedDownloads(this, std::string(_widget_config->ui_lineedit_incompleted->text().latin1()));
  connect(_widget_interrupted->ui_button_refreshint, SIGNAL(pressed()), _interrupted_downloads, SLOT(update()));

  _widget_shared->ui_pushbutton_properties->hide();

  _widget_config->config_tabs->setTabEnabled( _widget_config->tab_auth, false );

#ifndef USEKDE
#ifndef SHARP
  ui_checkbox_fileassociations->hide();
  ui_checkbox_systemtray->hide();
#endif
#endif

#ifndef SHARP
  // version check
  unsigned long vers = 0;
  if( _prev_version.empty() ) vers = 0;
  else
    {
      std::vector<std::string>     v;
      StringManipulation           sm(_prev_version);
      std::string                  version;

      sm.split_to_vector(v, '.');
      for(i = 0; i < v.size(); ++i)
				{
					std::string::size_type idx = v[i].find_first_not_of("0123456789");
					if(idx != std::string::npos) v[i] = v[i].substr(0, idx);
					
					for(j = 0; j < (3 - v[i].size()); ++j) version += std::string("0");
					version += v[i];
				}
      
      std::strstream str;
      str << version << std::ends;
      str >> vers;
    }

  if( vers < 3005 && vers > 0 ) 
    {
      std::strstream str;
      str << "Since version 0.3.5 a new filename format for" << std::endl
					<< "interrupted downloads has been introduced. Before" << std::endl
					<< "starting any downloads you should convert the old" << std::endl
					<< "format to the new one." << std::endl
					<< "Select \"Convert Filenames\" from the \"File\" menu." << std::ends;
      QMessageBox::information(this, "New Filename Format", str.str(), QMessageBox::Ok, 0);
    }
#endif
  SearchPersistence::load();
}

const int QtellaSub::strtoint(const std::string& s)
{
  int            i;
  std::strstream str;
  str << s << std::ends;
  str >> i;
  return i;
}


void QtellaSub::readHostList()
{
  if( ! _widget_config->ui_checkbox_savehostlist->isChecked() ) return;

  QFile f( _hostlist_file.c_str() );

  if(f.open(IO_ReadOnly))
    {
      char buffer[64];
      int  r;
      while( (r = f.readLine(buffer, 64)) > 0)
        {
          std::strstream str;
          str << buffer << std::ends;
          std::string s;
          str >> s;
          _widget_connections->ui_listbox_hostlist->insertItem(s.c_str());
        }
      f.close();
    }
  else
    std::cerr << "Cannot open host list file" << std::endl;
}


QtellaSub::~QtellaSub()
{
  delete _incoming_connect;
  delete upload_manager;
  delete download_manager;
#ifndef SHARP
  delete _hostcache;
#endif
  // remove all files on exit ?
  if( _widget_config->ui_checkbox_conf_removeall->isChecked() ) removeFiles(-1);

  // remove files with size less/equal than x ?
  if( _widget_config->ui_checkbox_conf_removefiles->isChecked() ) 
    removeFiles( _widget_config->ui_spinbox_conf_filesize->value() );

  // save configuration
  slotApplyConfig();

  // save host list
  slotDisconnect();

  if(_widget_config->ui_checkbox_savehostlist->isChecked())
    {
      QFile f( _hostlist_file.c_str() );
      
      if(f.open(IO_WriteOnly))
        {
          for(int i = 0; i < _widget_connections->ui_listbox_hostlist->count(); ++i)
            {
              std::string s = static_cast<std::string>(_widget_connections->ui_listbox_hostlist->text(i).latin1());
              s += "\n";
              f.writeBlock(s.data(), s.size());
            }
          f.close();
        }
      else
        std::cerr << "Error opening host list file." << std::endl;
    }
}


void QtellaSub::slotAddHost()
{
  if(!timer_connection->isActive())
    timer_connection->start(500);
  connections->slotAddHost();
}


void QtellaSub::check_connections()
{
  connections->checkServants();
}

void QtellaSub::slotAddDirectory()
{
#ifndef SHARP
  QString dirName =
    QFileDialog::getExistingDirectory(0, this, 0, QObject::tr("Select shared directory"), true);

  if ( !dirName.isEmpty() ) _widget_config->ui_listbox_shareddirectories->insertItem( dirName );

  // check for already being shared directories
  std::vector<std::string> dirs;
  std::vector<std::string> removed;
  int i;

  for(i = 0; i < _widget_config->ui_listbox_shareddirectories->count(); ++i)
    {
      bool append = true;
      for(int j = 0; j < dirs.size(); ++j) 
        {
          std::string s( _widget_config->ui_listbox_shareddirectories->text(i).latin1() );
          if( (s.find(dirs[j]) == 0) || (dirs[j].find(s) == 0) )
            {
              append = false;
              if( dirs[j].size() > s.size() ) 
                {
                  removed.push_back(dirs[j]);
                  dirs[j] = s;
                }
              else removed.push_back(s);
            }
        }
      if(append) dirs.push_back( std::string(_widget_config->ui_listbox_shareddirectories->text(i).latin1()) );
    }

  _widget_config->ui_listbox_shareddirectories->clear();
  
  for(i = 0; i < dirs.size(); ++i) 
    _widget_config->ui_listbox_shareddirectories->insertItem( dirs[i].c_str() );

  if( ! removed.empty() )
    {
      std::strstream str;
      str << QObject::tr("These directories are already being shared:") << "\n\n";
      for(i = 0; i < removed.size(); ++i)
        str << removed[i] << "\n";
      str << std::ends;
      QMessageBox::warning(this, QObject::tr("Removed Directories"), str.str(), QMessageBox::Ok, 0);
      str.freeze(false);
    }

  slotRefreshSharedList();
#endif
}

void QtellaSub::slotRemoveDirectory()
{
  int index = _widget_config->ui_listbox_shareddirectories->currentItem();

  if(index>-1)
    _widget_config->ui_listbox_shareddirectories->removeItem(index);

  slotRefreshSharedList();
}

void QtellaSub::checkDirectories(const std::string& directory, std::vector<SharedFile*> *old)
{
  QDir   dir(directory.c_str());

  if(dir.exists())
    {
      QStringList dirlist = dir.entryList(QDir::Dirs);
      QStringList::Iterator it;

      for( it = dirlist.begin(); it != dirlist.end(); ++it )
				{
					std::string filename = (*it).latin1();
					if(filename!="." && filename!="..")
						checkDirectories( (directory+"/"+filename), old );
				}
			
      QStringList list = dir.entryList(QDir::Files);
      
      for( it = list.begin(); it!=list.end(); ++it )
				{
					std::string filename = (*it).latin1();
					
					std::string complete = directory;
					if( complete[complete.size()-1] != '/' ) complete += "/";
					complete += filename;
					
					QFile f(complete.c_str());
					
					if(f.exists())
						{
							//insert filename into the hash table
							_hash_table.insert(filename);
							//insert filesize into set of filesizes
							_sharedsize_set.insert(f.size());
							
							SharedViewItem *item = new SharedViewItem(_widget_shared->ui_listview_shared, filename.c_str());
							
							item->setText(1, "0");  // uploads
							item->setText(2, "0");  // requests
							
							std::strstream stream_fsize;
							stream_fsize << f.size() << std::ends;
							std::string    str(stream_fsize.str());
							item->setText(3, StringManipulation::insertDelimiter(str, ',', 3).c_str() );
							stream_fsize.freeze(false);
							
							vSharedFiles.push_back(new SharedFile(item, filename, directory, f.size()));
							
							for(int i = 0; i < (*old).size(); i++)
								if( *((*old)[i]) == *vSharedFiles.back() )
									{
										int up = (*old)[i]->uploads;
										int rq = (*old)[i]->requests;
										
										vSharedFiles.back()->uploads = up;
										vSharedFiles.back()->requests = rq;
										
										std::strstream str;
										str << up << std::ends;
										item->setText(1, str.str());
										str.freeze(false);
										str.seekp(0, std::ios::beg);
										str << rq << std::ends;
										item->setText(2, str.str());
										str.freeze(false);
									}
						}
				}
    }
}


void QtellaSub::downloadItem(QListViewItem *item, const std::string& directory)
{
  for(int m = 0; m < connections->_search.size(); m++)
    for(int i = 0; i < connections->_search[m]->vSearchResults.size(); i++)
      if( connections->_search[m]->vSearchResults[i]->item == item) 
				{
					QueryHitEntry q = *(connections->_search[m]->vSearchResults[i]);
					
					// item must be set to NULL to prevent the deletion of the item
					// by the constructor of the Download
					q.item = NULL;
					
					download_manager->addDownload(q, item, "", NULL, directory);
				}
}


void QtellaSub::slotSearchDoubleClicked(QListViewItem *item)
{
  downloadItem(item);
}

// search button in "Search" was clicked
void QtellaSub::slotSearch()
{
  search( _widget_search->ui_combobox_search->currentText().latin1() );
}

// an item in the combobox of "Search" was activated (e.g. enter)
void QtellaSub::slotSearch( const QString& s )
{
	search( s.latin1() );
}

const void QtellaSub::search(const std::string& query, const SearchParameters *parameters)
{
  if(query.size() < 2) return;
	
  bool found = false;
  for(int i = 0; i < _widget_search->ui_combobox_search->count(); ++i)
    if( _widget_search->ui_combobox_search->text(i) == _widget_search->ui_combobox_search->currentText() ) found = true;
  if(!found) _widget_search->ui_combobox_search->insertItem(_widget_search->ui_combobox_search->currentText(), 0);
	
  QPixmap remove_research(*(Icon::getInstance()->getRemoveResearch()));
	
  SearchWidget *c = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();
  if( c ) _search_column_size = c->ui_listview_search->columnWidth(2);
	
  if(search_tabs == 0)
    {
      _widget_search->ui_tabwidget_search->changeTab( _widget_search->ui_tabwidget_search->currentPage(), 
                                                      QIconSet(remove_research), query.c_str());
      connections->search(query, (SearchWidget*)( _widget_search->ui_tabwidget_search->currentPage()), parameters);
    }
  else
    {
      SearchWidget *s = new SearchWidget(this);

      connect(s, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotSearchDoubleClicked(QListViewItem*)));
      connect(s, SIGNAL(rightButton(QListViewItem*, const QPoint&, int)), this, SLOT(slotShowSearchContext(QListViewItem*, const QPoint&, int)));
      _widget_search->ui_tabwidget_search->addTab(s, QIconSet(remove_research), query.c_str());
      _widget_search->ui_tabwidget_search->showPage(s);

      connections->search(query, s, parameters);
    }

  search_tabs++;
  _widget_search->ui_pushbutton_stopsearch->setEnabled(true);
  _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Stop", "button text to stop the search") );
}


void QtellaSub::slotAddAutoConnect()
{
  std::string s = (const char*)_widget_connections->ui_lineedit_autoconnect->text();
  
  if(!s.empty())
    _widget_connections->ui_listbox_autoconnect->insertItem(s.c_str());

  slotApplyConfig();
  _widget_connections->ui_lineedit_autoconnect->setText("");
}


void QtellaSub::slotRemoveAutoConnect()
{
  int index = _widget_connections->ui_listbox_autoconnect->currentItem();

  if(index>-1)
    _widget_connections->ui_listbox_autoconnect->removeItem(index);

  slotApplyConfig();
}


void QtellaSub::sighandler(int i)
{
#ifdef QTELLA_WARNINGS
    std::cout << "signal: " << i << std::endl;
#endif
}


void QtellaSub::slotReadFile()
{
#ifndef SHARP
  QFileDialog d(this, 0, true);

  if(d.exec())
    {
      std::string s = static_cast<const char*>(d.selectedFile());

      std::fstream f;

      f.open(s.c_str(), std::ios::in );
      if(f.is_open())
        {
          while( !f.eof() )
            {
              char   buffer[1024];
              f.getline(buffer, 1023);
              std::string input = buffer;
              
              if(input.find(":") != std::string::npos)
                _widget_connections->ui_listbox_hostlist->insertItem( input.c_str(), 0);
            }
        }
    }
#endif
}



void QtellaSub::slotStopSearch()
{
  SearchWidget* sw  = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  std::vector<Search*>::iterator pos = connections->_search.begin();
  while((*pos)->sw != sw) ++pos;

  if( _widget_search->ui_pushbutton_stopsearch->text() == QObject::tr("Stop", "button text to stop the search") )
    {
      (*pos)->active = false;
      _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Delete", "button text to delete search tab") );
    }
  else
    {
      for(int j = 0; j < (*pos)->vSearchResults.size(); j++)
				{
					_interrupted_downloads->removeQueryHit((*pos)->vSearchResults[j]->size);
					delete (*pos)->vSearchResults[j];
				}
			
      connections->_search.erase(pos);

      if(search_tabs==1)
        {
          sw->ui_listview_search->clear();
          _widget_search->ui_tabwidget_search->changeTab(sw, QIconSet(0), "");
          _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Stop", "button text to stop the search") );
          _widget_search->ui_pushbutton_stopsearch->setEnabled(false);
        }
      else
        {
          _widget_search->ui_tabwidget_search->removePage(sw);
          delete sw;
          
          sw = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();
          pos = connections->_search.begin();
          while((*pos)->sw != sw) ++pos;
          if((*pos)->active)
            _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Stop", "button text to stop the search") );
          else
            _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Delete", "button text to delete search tab") );
        }
      
      search_tabs--;
    }
}

static int getSpeedIndex(Q_UINT16 speed)
{
  switch(speed) {
  case 64: return 1;
  case 128: return 2;
  case 350: return 3;
  case 1000: return 4;
  case 3000: return 5;
  default: return 0;
  }
}

void QtellaSub::slotCurrentChanged(QWidget* w)
{
  std::vector<Search*>::iterator pos = connections->_search.begin();
  while( pos != connections->_search.end() ) 
    {
      if( (*pos)->sw == (SearchWidget*)w ) break;
      ++pos;
    }

	if(pos != connections->_search.end()) 
		{
			Search &s = **pos;
		
			if(s.active)
        _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Stop", "button text to stop the search") );
      else
        _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Delete", "button text to delete search tab") );
			
			_widget_search -> ui_checkbox_searchaudio -> setChecked(s._audio);
			_widget_search -> ui_checkbox_searchvideo -> setChecked(s._video);
			_widget_search -> ui_checkbox_searchimages -> setChecked(s._images);
			_widget_search -> ui_checkbox_searchany -> setChecked(s._any);
			_widget_search -> ui_combobox_searchspeed -> setCurrentItem(getSpeedIndex(s._min_speed));
		}
}


void QtellaSub::removeFiles(const int size)
{
  long              lsize = size;
  std::string       directory(_widget_config->ui_lineedit_incompleted->text().latin1());

  if(size>-1) lsize = size << 10;
  QDir   dir(directory.c_str());

  if(directory.size()>0)
    if(directory[directory.size()-1]!='/') directory += "/";

  if(dir.exists())
    {
      QStringList list = dir.entryList(QDir::Files);
      
      for( QStringList::Iterator it = list.begin(); it!=list.end(); ++it )
				{
					std::string filename = (*it).latin1();
					std::string complete(directory+filename);
					
					QFile f(complete.c_str());
					
					if(filename.find(".part_") != std::string::npos)
						if(f.exists())
							if( (f.size() <= lsize) || (lsize==-1) ) f.remove();
				}
    }
}


void QtellaSub::launchFile(const std::string& filename)
{
  
#ifdef USEKDE

  if( ! _widget_config->ui_checkbox_fileassociations->isChecked() )
    {
      KFileOpenWithHandler open_with;
      new KRun(KURL(filename.c_str()));
      return;
    }
  else
    {

#endif
  
      std::string::size_type idx = filename.find_last_of(".");
      std::string            ext(filename.substr(idx+1));
      std::string            application;
      
      for(int i = 0; i < _applications.size(); ++i)
				if(_applications[i].first.find(ext) != std::string::npos) application = _applications[i].second;
			
      if(application.empty()) return;
      
#if !defined(_WIN32)
      if(!fork())
				{
					execlp( application.c_str(), _binary.c_str(), filename.c_str(), NULL );
					exit(0);
				}
#endif
  
#ifdef USEKDE
    }
#endif
  
}


void QtellaSub::slotSharedFilesLaunch(QListViewItem* item)
{
  std::vector<SharedFile*>::iterator    pos = vSharedFiles.begin();

  while(pos != vSharedFiles.end()) if(item == (*pos)->item) break; else ++pos;
  launchFile( (*pos)->directory + "/" + (*pos)->file );
}


void QtellaSub::launchFileList(std::vector<std::string>& files)
{
  int i;
  if(files.empty()) return;

#ifdef USEKDE

  if( ! _widget_config->ui_checkbox_fileassociations->isChecked() )
    {
      KFileOpenWithHandler open_with;
      for(i = 1; i <= files.size(); ++i) new KRun(KURL(files[i-1].c_str()));
      return;
    }
  else
    {

#endif
  
      std::string::size_type idx = files[0].find_last_of(".");
      std::string ext(files[0].substr(idx+1));
      std::string application;
      
      for(i = 0; i < _applications.size(); ++i)
	if(_applications[i].first.find(ext) != std::string::npos) application = _applications[i].second;
      
      if(application.empty()) return;
      
#if !defined(_WIN32)
      if(!fork())
				{
					const int N = 1000;
					char*     args[N];
					
					for(i = 1; i <= files.size(); ++i) 
						if(i < N-1) args[i] = const_cast<char*>(files[i-1].c_str());
					
					args[0] = const_cast<char*>(_binary.c_str());
					if(files.size()+1 < N) args[files.size()+1] = NULL; else args[N-1] = NULL;
					
					execvp( application.c_str(), args );
					exit(0);
				}
#endif

#ifdef USEKDE
    }  
#endif

}


void QtellaSub::slotAddApplication()
{
  AddApplication aa(this, "", true);

  if(aa.exec())
    {
      new QListViewItem(_widget_config->ui_listview_apps, aa.ui_lineedit_type->text(), aa.ui_lineedit_application->text());
      _applications.push_back( std::make_pair(aa.ui_lineedit_type->text().latin1(), aa.ui_lineedit_application->text().latin1()) );
    }
}


void QtellaSub::slotEditApplication()
{
  QListViewItem*    fc = _widget_config->ui_listview_apps->firstChild();
  
  while(fc)
    if(fc->isSelected())
      {
	AddApplication aa(this, "", true);
	aa.ui_lineedit_type->setText(fc->text(0));
	aa.ui_lineedit_application->setText(fc->text(1));
	if(aa.exec())
	  {
	    int i;
	    for(i = 0; i < _applications.size(); ++i)
	      if(_applications[i].first == std::string(fc->text(0).latin1())) break;
	    
	    fc->setText(0, aa.ui_lineedit_type->text());
	    fc->setText(1, aa.ui_lineedit_application->text());
	    _applications[i] = std::make_pair(aa.ui_lineedit_type->text().latin1(), 
																				aa.ui_lineedit_application->text().latin1());
	  }
	break;
      }
    else
      fc = fc->itemBelow();
}


void QtellaSub::slotRemoveApplication()
{
  QListViewItem*    fc = _widget_config->ui_listview_apps->firstChild();
  QListViewItem*    tmp;

  while(fc)
    if(fc->isSelected())
      {
	tmp = fc;
	std::string type(fc->text(0).latin1());
	std::string app(fc->text(1).latin1());
	std::vector< std::pair<std::string, std::string> >::iterator     pos = _applications.begin();
	while( ((*pos).first != type) && ((*pos).second != app) ) ++pos;
	_applications.erase(pos);
	fc = tmp->itemBelow();
	delete tmp;
      }
    else
      fc = fc->itemBelow();
}


void QtellaSub::slotDownloadDoubleClicked(QListViewItem* item)
{
  if(!item) return;

  int i = 0;

  for(i = 0; i < download_manager->_downloads.size(); ++i)
    if(item == (QListViewItem*)download_manager->_downloads[i]->_item) 
      {
		if(download_manager->_downloads[i]->_f) 
		  launchFile( std::string(download_manager->_downloads[i]->_f->name().latin1()) );
		break;
      }
}


void QtellaSub::slotLaunchSelectedDownloadItem()
{
  for(int i = 0; i < download_manager->_downloads.size(); ++i)
    if(download_manager->_downloads[i]->_item->isSelected())
      {
				launchFile( std::string(download_manager->_downloads[i]->_f->name().latin1()) );
				break;
      }
}


void QtellaSub::slotDownloadShowContext(QListViewItem* item, const QPoint& p, int column)
{
  _context_download->popup(p);
}


void QtellaSub::slotShowSearchContext(QListViewItem* item, const QPoint& p, int column)
{
  _context_search->setItemEnabled(0, true);    // download
  _context_search->setItemEnabled(1, false);   // stop
  _context_search->setItemEnabled(2, false);   // remove
  _context_search->setItemEnabled(3, false);   // delete

  SearchWidget *s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  for(int j = 0; j < connections->_search.size(); j++) 
    if(connections->_search[j]->sw == s)
      {
        for(int i = 0; i < connections->_search[j]->vSearchResults.size(); i++)
          if( connections->_search[j]->vSearchResults[i]->item->isSelected() )
            {
              if( download_manager->exists(*connections->_search[j]->vSearchResults[i]) )
                {
                  _context_search->setItemEnabled(0, false);  // download
                  _context_search->setItemEnabled(1, true);   // stop
                  _context_search->setItemEnabled(2, true);   // remove
                  _context_search->setItemEnabled(3, true);   // delete
                }
              break;
            }
        
        break;
      }
  
  _context_search->popup(p);
}


void QtellaSub::slotShowUploadContext(QListViewItem* item, const QPoint& p, int column)
{
  _context_upload->popup(p);
}


void QtellaSub::slotShowSharedContext(QListViewItem* item, const QPoint& p, int column)
{
  _context_shared->popup(p);
}


QtellaSub* QtellaSub::getInstance()
{
  return _instance;
}

void QtellaSub::slotClickedAutoConnect(int i, QListBoxItem* item, const QPoint& p)
{
  if(item) _widget_connections->ui_lineedit_autoconnect->setText(item->text());
}

void QtellaSub::slotConnectContext(QListViewItem* item, const QPoint& p, int i)
{
  _context_connect->popup(p);
}

void QtellaSub::slotAddHostAutoConnect()
{
  QListViewItem* item = _widget_connections->ui_listview_connections->selectedItem();
  if(item)
    _widget_connections->ui_listbox_autoconnect->insertItem(item->text(0));
}

void QtellaSub::slotUpdateAutoConnect()
{
  int i = _widget_connections->ui_listbox_autoconnect->currentItem();
  if(i != -1)
    _widget_connections->ui_listbox_autoconnect->changeItem(_widget_connections->ui_lineedit_autoconnect->text(), i);
}

void QtellaSub::slotChangeFinishedAudio()
{
#ifndef SHARP
  QString s = 
    QFileDialog::getExistingDirectory(NULL, this, "", QObject::tr("Directory for finished audio downloads"), true);
  if(s != QString::null) _widget_config->ui_lineedit_download_audio->setText(s);
#endif
}

void QtellaSub::slotChangeFinishedImage()
{
#ifndef SHARP
  QString s = QFileDialog::getExistingDirectory(NULL, this, "", QObject::tr("Directory for finished image downloads"), true);
  if(s != QString::null) _widget_config->ui_lineedit_download_images->setText(s);
#endif
}

void QtellaSub::slotChangeFinishedVideo()
{
#ifndef SHARP
  QString s = QFileDialog::getExistingDirectory(NULL, this, "", QObject::tr("Directory for finished video downloads"), true);
  if(s != QString::null) _widget_config->ui_lineedit_download_video->setText(s);
#endif
}

void QtellaSub::slotChangeFinishedAny()
{
#ifndef SHARP
  QString s = QFileDialog::getExistingDirectory(NULL, this, "", QObject::tr("Directory for finished any downloads"), true);
  if(s != QString::null) _widget_config->ui_lineedit_download_anything->setText(s);
#endif
}

void QtellaSub::slotChangeInterrupted()
{
#ifndef SHARP
  QString s = QFileDialog::getExistingDirectory(NULL, this, "", QObject::tr("Directory for incomplete downloads"), true);
  if(s != QString::null) _widget_config->ui_lineedit_incompleted->setText(s);
#endif
}

void QtellaSub::slotChangeLogfile()
{
#ifndef SHARP
  QFileDialog d(this, 0, true);
  if(d.exec()) _widget_logs->ui_lineedit_logfile->setText(d.selectedFile());
#endif
}

// void QtellaSub::slotSelectHostCacheLogFile()
// {
// #ifndef SHARP
//   QFileDialog d(this, 0, true);
//   if(d.exec()) ui_lineedit_hostcachelogfile->setText(d.selectedFile());
// #endif
// }

void QtellaSub::slotDeleteDownload()
{
  if( ! _show_delete_dialog )
    {
      download_manager->slotDelete();
      return;
    }

  DeleteDialog dd(this, 0, true);

  if( dd.exec() ) download_manager->slotDelete();
  _show_delete_dialog = ! dd.ui_checkbox_askagain->isChecked();
}

void QtellaSub::slotCloseSearch()
{
  SearchWidget * sw  = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

#ifdef SHARP
  if( _widget_config->ui_checkbox_group_size->isChecked() )
    slotGroupSize(0);
#else
  if( _widget_search->ui_checkbox_group_size->isChecked() )
    slotGroupSize(0);
#endif

  std::vector<Search*>::iterator pos = connections->_search.begin();

  while((*pos)->sw != sw) ++pos;

  (*pos)->active = false;
  
  for(int j = 0; j < (*pos)->vSearchResults.size(); j++) 
    {
      _interrupted_downloads->removeQueryHit((*pos)->vSearchResults[j]->size);
      delete (*pos)->vSearchResults[j];
    }

  connections->_search.erase(pos);

  if(search_tabs==1)
    {
      sw->ui_listview_search->clear();
      _widget_search->ui_tabwidget_search->changeTab(sw, QIconSet(0), "");
      _widget_search->ui_pushbutton_stopsearch->setEnabled(false);
    }
  else
    {
      _widget_search->ui_tabwidget_search->removePage(sw);
      delete sw;
      
      sw = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();
      pos = connections->_search.begin();
    }
  search_tabs--;
  SearchPersistence::save(connections->_search);
}


void QtellaSub::slotChangeInterface(const QString& s)
{
  slotIPUpdate();
}


void QtellaSub::slotLaunchInterruptedFile()
{
  std::vector<InterruptedFile> files;
  _interrupted_downloads->getSelectedFiles(files);

  std::vector<std::string> f;
  for(int i = 0; i < files.size(); ++i) f.push_back(files[i].completeName());
  launchFileList(f);
}


void QtellaSub::slotDeleteInterruptedFile()
{
  _interrupted_downloads->deleteSelectedFiles();
}


void QtellaSub::slotSearchInterruptedFile()
{
  _interrupted_downloads->searchSelectedFiles();
}


void QtellaSub::slotResumeInterruptedFile()
{
  _interrupted_downloads->resumeSelectedFiles();
}


void QtellaSub::slotAbortInterruptedFile()
{
  _interrupted_downloads->abortSelectedFiles();
}

void QtellaSub::slotInterruptedFileContext(QListViewItem* i, const QPoint& p, int j)
{
  _interrupted_downloads->slotShowContextMenu((InterruptedViewItem*)i, p, j);
}


// --

void QtellaSub::slotResubmitSearch()
{
  if( connections->_search.empty() ) return;

#ifdef SHARP
  if( _widget_config->ui_checkbox_group_size->isChecked() )
    slotGroupSize(0);
#else
  if( _widget_search->ui_checkbox_group_size->isChecked() )
    slotGroupSize(0);
#endif

  SearchWidget* sw  = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  std::vector<Search*>::iterator pos = connections->_search.begin();
  while((*pos)->sw != sw) ++pos;
  std::string query = (*pos)->query;

  _widget_search->ui_pushbutton_stopsearch->setText( QObject::tr("Stop", "button text to stop the search") );
  QPixmap remove_research(*(Icon::getInstance()->getRemoveResearch()));
  _widget_search->ui_tabwidget_search->changeTab(sw, QIconSet(remove_research), query.c_str());

  for(int j = 0; j < (*pos)->vSearchResults.size(); j++)
    {
      _interrupted_downloads->removeQueryHit((*pos)->vSearchResults[j]->size);
      delete (*pos)->vSearchResults[j];
    }

  connections->_search.erase(pos);
  connections->search( query, sw );
}


void QtellaSub::slotIPUpdate()
{
#ifndef SHARP
  std::string iface(_widget_config->ui_combobox_interface->currentText().latin1());

  _ip_update_timer->changeInterval(_widget_config->ui_spinbox_updateinterval->value() * 60000);

  if( iface == std::string( QObject::tr("manual", "network interface").latin1() ) )
    {
      _widget_config->ui_pushbutton_updateip->setEnabled(false);
      _widget_config->ui_lineedit_hostname->setEnabled(false);
      _widget_config->ui_lineedit_ip->setEnabled(true);
      _widget_config->ui_spinbox_updateinterval->setEnabled(false);
      return;
    }

  if( iface == std::string( QObject::tr("hostname", "network interface").latin1() ) )
    {
      _widget_config->ui_pushbutton_updateip->setEnabled(true);
      _widget_config->ui_lineedit_hostname->setEnabled(true);
      _widget_config->ui_lineedit_ip->setEnabled(false);
      _widget_config->ui_spinbox_updateinterval->setEnabled(true);

      _widget_config->ui_lineedit_ip->setText( Address::getIPOfHost((const char*)_widget_config->ui_lineedit_hostname->text()).c_str() );
      return;
    }

  if( iface == std::string( QObject::tr("file", "network interface").latin1() ) )
    {
      _widget_config->ui_pushbutton_updateip->setEnabled(true);
      _widget_config->ui_lineedit_hostname->setEnabled(true);
      _widget_config->ui_lineedit_ip->setEnabled(false);
      _widget_config->ui_spinbox_updateinterval->setEnabled(true);

      std::fstream   f;
      f.open( (const char*)(_widget_config->ui_lineedit_hostname->text()), std::ios::in );
      if( f.is_open() )
        {
          std::string ip;
          f >> ip;
          _widget_config->ui_lineedit_ip->setText( ip.c_str() );
        }
      
      return;
    }

  if( iface == std::string( QObject::tr("automatic", "network interface").latin1() ) )
    {
#ifdef _DEBUG
      qDebug( "QtellaSub:: automatic selected" );
#endif
      _widget_config->ui_lineedit_hostname->setEnabled(false);
      _widget_config->ui_lineedit_ip->setEnabled(false);
      _widget_config->ui_pushbutton_updateip->setEnabled(false);
      _widget_config->ui_spinbox_updateinterval->setEnabled(false);

      _widget_config->ui_lineedit_ip->setText( _last_addr.c_str() );

      return;
    }


  _widget_config->ui_pushbutton_updateip->setEnabled(true);
  _widget_config->ui_lineedit_hostname->setEnabled(false);
  _widget_config->ui_spinbox_updateinterval->setEnabled(true);

#if defined(_WIN32)
  // for windows the selected interface is the ip address
  _widget_config->ui_lineedit_ip->setText(iface.c_str());
#else
  // for linux/unix the selected interface is a network interface
  Interface i;
  _widget_config->ui_lineedit_ip->setText(i.getIfAddress(iface).c_str());
#endif
#endif
}


// system tray patch
void QtellaSub::closeEvent(QCloseEvent *e)
{
#ifdef USEKDE
  if( _widget_config->ui_checkbox_systemtray->isChecked() )
    if( isVisible() )
      hide();
    else 
      QWidget::closeEvent(e);
  else
    QWidget::closeEvent(e);
#else
  QWidget::closeEvent(e);
#endif
}


const std::string QtellaSub::getMyAddress()
{
  return _last_addr;
}


void QtellaSub::slotMenu( int id )
{
  if( id == HELP_ICON_ID )
    {
      slotInfo();
      return;
    }

  QWidget* w = NULL;

  switch( id )
    {
    case CONNECTIONS_ICON_ID:
      w = _widget_connections;
      break;
    case SEARCH_ICON_ID:
      w = _widget_search;
      break;
    case DOWNLOAD_ICON_ID:
      w = _widget_downloads;
      break;
    case UPLOAD_ICON_ID:
      w = _widget_uploads;
      break;
    case SHARED_ICON_ID:
      w = _widget_shared;
      break;
    case STATS_ICON_ID:
      w = _widget_stats;
      break;
    case INTERRUPTED_ICON_ID:
      w = _widget_interrupted;
      break;
    }

  if( w )
    {
#ifdef SHARP
      w->show();
      if( w != _widget_connections )
        _widget_connections->hide();
      if( w != _widget_search )
        _widget_search->hide();
      if( w != _widget_downloads )
        _widget_downloads->hide();
      if( w != _widget_uploads )
        _widget_uploads->hide();
      if( w != _widget_shared )
        _widget_shared->hide();
      if( w != _widget_stats )
        _widget_stats->hide();
      if( w != _widget_interrupted )
        _widget_interrupted->hide();
#else
			if( w->isVisible() )
				w->setFocus();
			else
				w->show();
#endif
    }
}


void QtellaSub::slotSettings()
{
  _widget_config->show();
#ifdef SHARP
  _widget_connections->hide();
  _widget_search->hide();
  _widget_downloads->hide();
  _widget_uploads->hide();
  _widget_shared->hide();
  _widget_stats->hide();
  _widget_interrupted->hide();
#endif
}
