#include "QtellaSub.h"
#include "StringManipulation.h"
#include "SearchWidget.h"
#include "WidgetConfig.h"
#include "WidgetSharedFiles.h"
#include "WidgetUploads.h"
#include "WidgetInterrupted.h"
#include "WidgetConnections.h"
#include "WidgetDownloads.h"
#include "WidgetStats.h"
#include "WidgetSearch.h"
#include "WidgetLogs.h"

#include <string>
#include <fstream>
#include <strstream>
#include <iostream>
#include <vector>

#include "qdir.h"
#include "qlineedit.h"
#include "qcheckbox.h"
#include "qlistview.h"
#include "qspinbox.h"
#include "qlistbox.h"
#include "qcombobox.h"
#include "qradiobutton.h"
#include "qtabwidget.h"
#include "qpopupmenu.h"

#undef _DEBUG

void QtellaSub::readConfiguration()
{
  QDir d;
  std::string homedir = d.homeDirPath().latin1();

  _show_delete_dialog = true;
  _read_config = true;
  _last_addr = "0.0.0.0";
  _use_opensourcep2p = false;

  _widget_config->ui_lineedit_download_video->setText( homedir.c_str() );
  _widget_config->ui_lineedit_download_audio->setText( homedir.c_str() );
  _widget_config->ui_lineedit_download_images->setText( homedir.c_str() );
  _widget_config->ui_lineedit_download_anything->setText( homedir.c_str() );

  _widget_config->ui_lineedit_incompleted->setText( homedir.c_str() );

#if !defined(_WIN32)
  conffile = homedir + "/.qtella";
  _hostlist_file = homedir + "/.qtella/hostlist";

  QDir dtmp = QDir::current();
  
  if( ! d.cd( conffile.c_str() ) )
    {
      // .qtella does not exist or its an old configuratoin file
      // try to rename the old config file
      d.rename( conffile.c_str(), ( conffile + ".old" ).c_str() );

      // create the .qtella directory
      if( ! d.mkdir( conffile.c_str() ) )
	{
	  std::cerr << "Cannot create configuration directory." << std::endl;
	  d.rename( ( conffile + ".old" ).c_str(), ( conffile + "/qtella" ).c_str() );
	  conffile += "/qtella";
	}
      else
	{
	  // on error restore the old config file
	  d.rename( ( conffile + ".old" ).c_str(), conffile.c_str() );
	}
    }
  else
    {
      dtmp.cd( dtmp.path() );
      conffile = conffile + "/qtella";
    }
#else
  conffile = "c:\\qtella.ini";
  _hostlist_file = "c:\\hostlist";
#endif

  std::ifstream   f( conffile.c_str() );
  unsigned        i;

  if( !f.fail() && f.is_open())
    {
      std::string input;
	  char buffer[1024];

      while( f.getline( buffer, 1024 ) )
		{
		  input = buffer;
		  StringManipulation s(input);
		  
		  s.remove_comments();
		  
		  std::string s1, s2;
		  s.split(s1, s2, '=');
		  
		  s.assign(s1);
		  s.remove_chars("\n ");
		  s1 = s.str();
		  
		  s.assign(s2);
		  s.remove_chars("\n");
		  s2 = s.str();
		  
		  //transform(s1.begin(), s1.end(), s1.begin(), toupper);
		  for(i = 0; i < s1.size(); ++i) s1[i] = toupper(s1[i]);
		  
		  if(!s1.empty())
			{
			  if(s1=="LAST_DL_TO_DIR") _last_download_to_dir = s2;
			  if(s1=="LASTADDR") _last_addr = s2;
			  if(s1=="IMAGES") _widget_config->ui_lineedit_images->setText(s2.c_str());
			  if(s1=="AUDIO") _widget_config->ui_lineedit_audio->setText(s2.c_str());
			  if(s1=="VIDEOS") _widget_config->ui_lineedit_video->setText(s2.c_str());
#ifndef SHARP
			  if(s1=="IFACE") _pref_if = s2;
			  if(s1=="LOGFILE") _widget_logs->ui_lineedit_logfile->setText(s2.c_str());
#endif
			  if( s1.substr(0, 8) == "DOWNLOAD" ) 
				{
				  QLineEdit* e = NULL;
		  
				  if( s1 == "DOWNLOAD_AUDIO" )
					e = _widget_config->ui_lineedit_download_audio;
				  if( s1 == "DOWNLOAD_VIDEO" )
					e = _widget_config->ui_lineedit_download_video;
				  if( s1 == "DOWNLOAD_IMAGE" )
					e = _widget_config->ui_lineedit_download_images;
				  if( s1 == "DOWNLOAD_ANY" )
					e = _widget_config->ui_lineedit_download_anything;
				  
				  if( e )
					if( ! s2.empty() && s2.find_first_not_of(" \n") != std::string::npos ) 
					  {
						// valid directory name
						e->setText( s2.c_str() );
						QDir d( s2.c_str() );
						if( ! d.exists() )
						  e->setText( homedir.c_str() );
					  }
				}

			  if(s1=="INCOMPLETE") 
				{
				  if( ! s2.empty() && s2.find_first_not_of(" \n") != std::string::npos ) 
            _widget_config->ui_lineedit_incompleted->setText(s2.c_str());
				  
				  QDir d( _widget_config->ui_lineedit_incompleted->text() );
				  if( ! d.exists() )
            _widget_config->ui_lineedit_incompleted->setText(homedir.c_str());
				}

#ifndef SHARP
			  if(s1=="PORT") _widget_config->ui_lineedit_listenport->setText(s2.c_str());
			  if(s1=="HOST_LIST_FILE") 
				if( !s2.empty() && s2.find_first_not_of(" \n") != std::string::npos ) 
				  _widget_config->ui_lineedit_hostlistfile->setText(s2.c_str());
        //			  if(s1=="HOSTCACHE_LOGFILE") ui_lineedit_hostcachelogfile->setText(s2.c_str());
			  if(s1=="HOSTNAME") _widget_config->ui_lineedit_hostname->setText(s2.c_str());
			  if(s1=="STYLE") _style_s = s2;
#endif
			  if(s1=="VERSION") _prev_version = s2;
			  
			  if(s1=="TABSIZE_DOWNLOAD") _widget_downloads->ui_listview_download->setColumnWidth(0, strtoint(s2));
			  if(s1=="TABSIZE_SHARED") _widget_shared->ui_listview_shared->setColumnWidth(0, strtoint(s2));
			  if(s1=="TABSIZE_UPLOADS") _widget_uploads->ui_listview_uploads->setColumnWidth(0, strtoint(s2));
			  if(s1=="TABSIZE_INTERRUPT") _widget_interrupted->ui_listview_interrupt->setColumnWidth(0, strtoint(s2));
			  if(s1=="TABSIZE_SEARCH") _search_column_size = strtoint(s2);

 	      if(s1=="SHAREDDIR")
          {
            std::vector<std::string> vString;
            s.assign(s2);
            s.split_to_vector(vString, ';');
            for(i=0; i<vString.size(); i++)
              _widget_config->ui_listbox_shareddirectories->insertItem(vString[i].c_str());
          }
		  
        if( s1 == "GROUP" )
          _widget_config->ui_lineedit_groupid->setText( s2.c_str() );

        if( s1 == "USER" )
          _widget_config->ui_lineedit_userid->setText( s2.c_str() );

        if( s1 == "RESERVER_IN" )
          if( s2 == "1" )
            _widget_config->ui_checkbox_reserve_in->setChecked( true );

        if( s1 == "RESERVE_UP" )
          if( s2 == "1" )
            _widget_config->ui_checkbox_reserve_up->setChecked( true );

        if( s1 == "GROUPS" )
          {
            std::vector< std::string > vstring;
            s.assign( s2 );
            s.split_to_vector( vstring, ';' );
            for( int i = 0; i < vstring.size(); ++i )
              _widget_config->ui_listbox_groups->insertItem( vstring[i].c_str() );
          }

        if( s1 == "USERS" )
          {
            std::vector< std::string > vstring;
            s.assign( s2 );
            s.split_to_vector( vstring, ';' );
            for( int i = 0; i < vstring.size(); ++i )
              _widget_config->ui_listbox_users->insertItem( vstring[i].c_str() );
          }

	      if(s1=="APPS")
          {
            std::vector<std::string> v;
            s.assign(s2);
            s.split_to_vector(v, ':');
            _applications.push_back( std::make_pair(v[0], v[1]) );
            new QListViewItem( _widget_config->ui_listview_apps, v[0].c_str(), v[1].c_str() );
          }

	      if(s1=="SPEED")
          {
            if(s2=="Modem") _widget_config->ui_combobox_speed->setCurrentItem(0);
            if(s2=="ISDN") _widget_config->ui_combobox_speed->setCurrentItem(1);
            if(s2=="ISDN2x") _widget_config->ui_combobox_speed->setCurrentItem(2);
            if(s2=="Cable/DSL") _widget_config->ui_combobox_speed->setCurrentItem(3);
            if(s2=="T1") _widget_config->ui_combobox_speed->setCurrentItem(4);
            if(s2=="T3") _widget_config->ui_combobox_speed->setCurrentItem(5);
          }
        
#ifdef SHARP
#define C _widget_config
#else
#define C _widget_search
#endif

	      if(s1=="SEARCHSPEED")
          {
            if(s2=="Modem") C->ui_combobox_searchspeed->setCurrentItem(0);
            if(s2=="ISDN") C->ui_combobox_searchspeed->setCurrentItem(1);
            if(s2=="ISDN2x") C->ui_combobox_searchspeed->setCurrentItem(2);
            if(s2=="Cable/DSL") C->ui_combobox_searchspeed->setCurrentItem(3);
            if(s2=="T1") C->ui_combobox_searchspeed->setCurrentItem(4);
            if(s2=="T3") C->ui_combobox_searchspeed->setCurrentItem(5);
          }

#ifdef SHARP
#define S _widget_stats
#else
#define S _widget_logs
#endif

	      if(s1=="LOGLEVEL")
          {
            if(s2=="Debug") S->ui_combobox_loglevel->setCurrentItem(0);
            if(s2=="Info") S->ui_combobox_loglevel->setCurrentItem(1);
            if(s2=="Errors") S->ui_combobox_loglevel->setCurrentItem(2);
          }
		  
	      if(s1=="MAXDOWNLOADS")
          {
            std::strstream str;
            int       max_downloads;
            str << s2 << std::ends;
            str >> max_downloads;
            _widget_config->ui_spinbox_maxdownloads->setValue(max_downloads);
          }
		  
 	      if(s1=="MAXUPLOADS")
          {
            std::strstream str;
            int       max_uploads;
            str << s2 << std::ends;
            str >> max_uploads;
            _widget_config->ui_spinbox_maxuploads->setValue(max_uploads);
          }
		  
 	      if(s1=="MAXUPLOADS_PER_USER")
          {
            std::strstream str;
            int       max_uploads;
            str << s2 << std::ends;
            str >> max_uploads;
            _widget_config->ui_max_up_per_user->setValue(max_uploads);
          }
		  
 	      if(s1=="UPLOADBANDWIDTH")
          {
            std::strstream str;
            int       upload_bandwidth;
            str << s2 << std::ends;
            str >> upload_bandwidth;
            _widget_config->ui_spinbox_upbandwidth->setValue(upload_bandwidth);
          }
		  
	      if(s1=="AUTOCONNECT")
          {
            std::vector<std::string> vString;
            s.assign(s2);
            s.split_to_vector(vString, ';');
            for(i=0; i<vString.size(); i++)
              _widget_connections->ui_listbox_autoconnect->insertItem(vString[i].c_str());
          }
		  
#ifndef SHARP
	      if(s1=="GEOMETRY")
					{
						std::vector<std::string> vString;
						s.assign(s2);
						s.split_to_vector(vString, ',');
						int a[4];
						for(i = 0; i < vString.size(); i++)
							{
								std::strstream str;
								str << vString[i] << std::ends;
								str >> a[i];
							}
						setGeometry( a[0], a[1], a[2], a[3] );
					}
				
// 				if( s1 == "SUB_WINDOWS_MAXIMIZED" )
// 					if( s2 == "1" )
// 						emit signalMaximizeWindows();

				QWidget* w = NULL;
				if( s1 == "GEO_CONNECTIONS" )
					w = _widget_connections;
				if( s1 == "GEO_SEARCH" )
					w = _widget_search;
				if( s1 == "GEO_DOWNLOADS" )
					w = _widget_downloads;
				if( s1 == "GEO_UPLOADS" )
					w = _widget_uploads;
				if( s1 == "GEO_STATS" )
					w = _widget_stats;
				if( s1 == "GEO_CONFIG" )
					w = _widget_config;
				if( s1 == "GEO_SHARED" )
					w = _widget_shared;
				if( s1 == "GEO_INTERRUPTED" )
					w = _widget_interrupted;
				if( s1 == "GEO_LOGS" )
					w = _widget_logs;
				if( w )
					{
						std::vector<std::string> vString;
						s.assign(s2);
						s.split_to_vector(vString, ',');
						int a[4];
						for(i = 0; i < vString.size(); i++)
							{
								std::strstream str;
								str << vString[i] << std::ends;
								str >> a[i];
							}
						w->setGeometry( a[0], a[1], a[2], a[3] );
					}
				
				w = NULL;
				if( s1 == "CONNECTIONS_VISIBLE" && s2 == "1" )
					w = _widget_connections;
				if( s1 == "SEARCH_VISIBLE" && s2 == "1" )
					w = _widget_search;
				if( s1 == "DOWNLOADS_VISIBLE" && s2 == "1" )
					w = _widget_downloads;
				if( s1 == "UPLOADS_VISIBLE" && s2 == "1" )
					w = _widget_uploads;
				if( s1 == "STATS_VISIBLE" && s2 == "1" )
					w = _widget_stats;
				if( s1 == "CONFIG_VISIBLE" && s2 == "1" )
					w = _widget_config;
				if( s1 == "SHARED_VISIBLE" && s2 == "1" )
					w = _widget_shared;
				if( s1 == "INTERRUPTED_VISIBLE" && s2 == "1" )
					w = _widget_interrupted;
				if( s1 == "LOGS_VISIBLE" && s2 == "1" )
					w = _widget_logs;
				if( w )
					w->showMaximized();
#endif

	      if(s1=="BLOCKED_HOSTS")
          {
            std::vector<std::string> vString;
            s.assign(s2);
            s.split_to_vector(vString, ';');
            for(i = 0; i < vString.size(); i++)
              _widget_config->ui_listbox_blockedhosts->insertItem( vString[i].c_str() );
          }
		  
	      if(s1=="FILENAME_LENGTH")
          {
            std::strstream str;
            str << s2 << std::ends;
            str >> i;
            _widget_config->ui_spinbox_filelength->setValue(i);
          }
	      
	      if(s1=="EXISTING_FILES")
          {
            if(s2=="0") _widget_config->ui_radiobutton_e_overwrite->setChecked(true);
            else
              if(s2=="1") _widget_config->ui_radiobutton_e_rename->setChecked(true);
              else
                _widget_config->ui_radiobutton_e_abort->setChecked(true);
          }
#ifndef SHARP
	      if(s1=="ENABLE_LOGFILE") if(s2=="1") _widget_logs->ui_checkbox_loginfile->setChecked(true);
#endif
	      if(s1=="SAVE_HOST_LIST")
          {
            if(s2=="0") _widget_config->ui_checkbox_savehostlist->setChecked(false);
            else
              _widget_config->ui_checkbox_savehostlist->setChecked(true);
          }
		  
	      if(s1=="ONEXIT_REMOVE_SIZE")
          {
            std::strstream str;
            int            size;
            str << s2 << std::ends;
            str >> size;
            _widget_config->ui_spinbox_conf_filesize->setValue(size);
          }
		  
	      if(s1=="ONEXIT_REMOVE") if(s2=="1") _widget_config->ui_checkbox_conf_removefiles->setChecked(true);
	      if(s1=="ONEXIT_REMOVEALL") if(s2=="1") _widget_config->ui_checkbox_conf_removeall->setChecked(true);
	      if(s1=="IGNORE_FIREWALLED") if(s2=="1") _widget_config->ui_checkbox_ignorefirewalled->setChecked(true);
	      if(s1=="IGNORE_BUSY") if(s2=="1") _widget_config->ui_checkbox_ignorebusy->setChecked(true);
	      if(s1=="FILTER_PRIVATE_IP") if(s2=="0") _widget_connections->ui_checkbox_filterip->setChecked(false);
	      if(s1=="ENABLE_IN_SEARCHES") if(s2=="1") _widget_logs->ui_checkbox_incomingsearch->setChecked(true);
	      if(s1=="ENABLE_LOGS") if(s2=="1") _widget_logs->ui_checkbox_enablelogs->setChecked(true);
	      if(s1=="ONSTART_CONNECT") if(s2=="1") _widget_config->ui_checkbox_conf_autoconnect->setChecked(true);
#ifndef SHARP
	      if(s1=="ENABLE_LOGFILE") if(s2=="1") _widget_logs->ui_checkbox_loginfile->setChecked(true);
	      //if(s1=="HOSTCACHE_ENABLE") if(s2=="1") ui_checkbox_enablehostcache->setChecked(true);
	      //if(s1=="HOSTCACHE_ENABLELOG") if(s2=="0") ui_checkbox_enablelogging->setChecked(false);
	      //if(s1=="HOSTCACHE_ENABLEFILELOG") if(s2=="1") ui_checkbox_hostcacheenablefilelog->setChecked(true);
	      if(s1=="FILE_ASSOCIATIONS") if(s2=="1") _widget_config->ui_checkbox_fileassociations->setChecked(true);
#endif
	      if(s1=="SHOW_DELETE_DIALOG") if(s2=="0") _show_delete_dialog = false;
	      if(s1=="SHOW_PROGR_BAR") if(s2=="0") _widget_config->ui_checkbox_showprogressbar->setChecked(false);
	      if(s1=="NUMERIC_PROGRESS") if(s2=="1") _widget_config->ui_checkbox_numericprogress->setChecked(true);
	      if(s1=="SHOW_UP_PROGR_BAR") if(s2=="0") _widget_config->ui_checkbox_up_showprogressbar->setChecked(false);
	      if(s1=="NUMERIC_UP_PROGRESS") if(s2=="1") _widget_config->ui_checkbox_up_progressvalue->setChecked(true);
	      if(s1=="HIDE_FILENAMES") if(s2=="1") _widget_config->ui_checkbox_hidefilename->setChecked(true);
	      if(s1=="HIDE_FILESIZE") if(s2=="1") _widget_config->ui_checkbox_hidefilesize->setChecked(true);
	      if(s1=="SORT_CASESENSITIVE") if(s2=="0") _widget_config->ui_checkbox_casesensitive->setChecked(false);
	      if(s1=="SEARCHES_MATCH") if(s2=="1") _widget_logs->ui_checkbox_searches_match->setChecked(true);
	      if(s1=="SYSTEM_TRAY") if(s2=="0") _widget_config->ui_checkbox_systemtray->setChecked(false);
	      if(s1=="GROUP_SIZE") if(s2=="1") _widget_search->ui_checkbox_group_size->setChecked(true);
	      if(s1=="SHOW_ONLY_ESTABLISHED") if(s2=="1") _widget_connections->ui_checkbox_showestablished->setChecked(true);

	      if(s1=="USE_OPENSOURCEP2P") if(s2=="1") _use_opensourcep2p = true;
// #ifndef SHARP
// 	      if(s1=="HOSTCACHE_PORT")
//           {
//             std::strstream str;
//             int i;
//             str << s2 << std::ends;
//             str >> i;
//             ui_spinbox_hostcacheport->setValue(i);
//           }
// #endif
	      if(s1=="RETRIES")
          {
            std::strstream str;
            int            n;
            str << s2 << std::ends;
            str >> n;
            _widget_config->ui_spinbox_conf_retries->setValue(n);
          }

	      if(s1=="INCONNECTS")
          {
            std::strstream str;
            int            n;
            str << s2 << std::ends;
            str >> n;
            _widget_connections->ui_spinbox_inconnects->setValue(n);
          }

	      if(s1=="DL_PER_HOST")
          {
            std::strstream str;
            int            n;
            str << s2 << std::ends;
            str >> n;
            _widget_config->ui_spinbox_dl_per_host->setValue(n);
          }
		  
	      if(s1=="IMAGES") _widget_config->ui_lineedit_images->setText(s2.c_str());
	      if(s1=="VIDEOS") _widget_config->ui_lineedit_video->setText(s2.c_str());
	      if(s1=="AUDIO") _widget_config->ui_lineedit_audio->setText(s2.c_str());
#ifndef SHARP
	      if(s1=="LOGFILE") _widget_logs->ui_lineedit_logfile->setText(s2.c_str());
#endif
	      if(s1=="ABORT_DOWNLOADS")
          {
            if(s2=="0") _widget_config->ui_radiobutton_a_contsize->setChecked(true);
            else
              if(s2=="1") _widget_config->ui_radiobutton_a_conthost->setChecked(true);
              else
                if(s2=="2") _widget_config->ui_radiobutton_a_contsizehost->setChecked(true);
                else
                  _widget_config->ui_radiobutton_a_startnew->setChecked(true);
          }
		  
	      if(s1=="NHOSTS")
          {
            std::strstream str;
            int       hosts;
            str << s2 << std::ends;
            str >> hosts;
            _widget_connections->ui_spinbox_hosts->setValue(hosts);
          }
// #ifndef SHARP
// 	      if(s1=="DELIVER_HOSTS")
// 			{
// 			  std::strstream str;
// 			  int       hosts;
// 			  str << s2 << std::ends;
// 			  str >> hosts;
// 			  ui_spinbox_deliverhosts->setValue(hosts);
// 			}
// #endif
	      if(s1=="TTL")
          {
            std::strstream str;
            int    ttl;
            str << s2 << std::ends;
            str >> ttl;
            _widget_config->ui_spinbox_ttl->setValue(ttl);
          }
#ifndef SHARP
	      if(s1=="IP_UPDATE_INTERVAL")
          {
            std::strstream str;
            int    i;
            str << s2 << std::ends;
            str >> i;
            _widget_config->ui_spinbox_updateinterval->setValue(i);
          }
#endif
// 	      if(s1 == "VIEW_CONNECTIONS") 
//           if(s2 == "0") 
//             {
//               _view->setItemChecked(1, false);
//               Tabular->removePage(page_connections);
//             }

// 	      if(s1 == "VIEW_SEARCH") 
//           if(s2 == "0") 
//             {
//               _view->setItemChecked(2, false);
//               Tabular->removePage(page_search);
//             }

// 	      if(s1 == "VIEW_DOWNLOADS") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(3, false);
// 				Tabular->removePage(page_downloads);
// 			  }

// 	      if(s1 == "VIEW_UPLOADS") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(4, false);
// 				Tabular->removePage(page_uploads);
// 			  }

// 	      if(s1 == "VIEW_SHARED_FILES") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(5, false);
// 				Tabular->removePage(page_shared_files);
// 			  }
// #ifndef SHARP
// 	      if(s1 == "VIEW_LOGS") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(6, false);
// 				Tabular->removePage(page_logs);
// 			  }
// #endif
// 	      if(s1 == "VIEW_STATISTICS") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(7, false);
// 				Tabular->removePage(page_statistics);
// 			  }
// #ifndef SHARP
// 	      if(s1 == "VIEW_HOSTCACHE") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(8, false);
// 				Tabular->removePage(page_hostcache);
// 			  }
// #endif
// 	      if(s1 == "VIEW_INTERRUPTED_DL") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(9, false);
// 				Tabular->removePage(page_interrupted_dl);
// 			  }

// 	      if(s1 == "VIEW_CONFIGURATION") 
// 			if(s2 == "0") 
// 			  {
// 				_view->setItemChecked(10, false);
// 				Tabular->removePage(page_configuration);
// 			  }

	    }
    }
      f.close();
    }
  else  // default configuration
    {
      _widget_connections->ui_listbox_autoconnect->insertItem("qtellaconnect.ath.cx:6347");
      _widget_connections->ui_listbox_autoconnect->insertItem("router.limewire.com:6346");
      _widget_connections->ui_listbox_autoconnect->insertItem("connect1.gnutellanet.com:6346");
      _widget_connections->ui_listbox_autoconnect->insertItem("connect2.gnutellanet.com:6346");
      _widget_connections->ui_listbox_autoconnect->insertItem("connect3.gnutellanet.com:6346");
      _widget_connections->ui_listbox_autoconnect->insertItem("connect4.gnutellanet.com:6346");
      _widget_connections->ui_listbox_autoconnect->insertItem("connect3.bearshare.net:6346");
      
      _prev_version = "99.0.0";
    }

  _read_config = false;
}


void QtellaSub::slotApplyConfig()
{
  _widget_config->hide();

  SearchWidget *c = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();
  if( c ) 
	_search_column_size = c->ui_listview_search->columnWidth(2);

#ifndef SHARP
  QRect        r = geometry();
#endif

  std::fstream f;

  f.open(conffile.c_str(), std::ios::out | std::ios::trunc);
  if(!f.is_open())
    {
      std::cerr << "Cannot open configuration file. " << conffile << std::endl;
      return;
    }

  f << "DOWNLOAD_AUDIO=" << (const char*)_widget_config->ui_lineedit_download_audio->text() << std::endl
    << "DOWNLOAD_VIDEO=" << (const char*)_widget_config->ui_lineedit_download_video->text() << std::endl
    << "DOWNLOAD_IMAGE=" << (const char*)_widget_config->ui_lineedit_download_images->text() << std::endl
    << "DOWNLOAD_ANY=" << (const char*)_widget_config->ui_lineedit_download_anything->text() << std::endl
    << "INCOMPLETE=" << (const char*)_widget_config->ui_lineedit_incompleted->text() << std::endl
#ifndef SHARP
    << "GEOMETRY=" << r.x() << "," << r.y() << "," << r.width() << "," << r.height() << std::endl
    << "PORT=" << (const char*)_widget_config->ui_lineedit_listenport->text() << std::endl
//     << "HOSTCACHE_LOGFILE=" << (const char*)ui_lineedit_hostcachelogfile->text() << std::endl
//     << "HOSTCACHE_PORT=" << ui_spinbox_hostcacheport->value() << std::endl
//     << "HOSTCACHE_ENABLE=" << ui_checkbox_enablehostcache->isChecked() << std::endl
//     << "HOSTCACHE_ENABLELOG=" << ui_checkbox_enablelogging->isChecked() << std::endl
//     << "HOSTCACHE_ENABLEFILELOG=" << ui_checkbox_hostcacheenablefilelog->isChecked() << std::endl
    << "ENABLE_LOGFILE=" << _widget_logs->ui_checkbox_loginfile->isChecked() << std::endl
    << "LOGFILE=" << (const char*)_widget_logs->ui_lineedit_logfile->text() << std::endl
//     << "DELIVER_HOSTS=" << ui_spinbox_deliverhosts->value() << std::endl
    << "IFACE=" << (const char*)_widget_config->ui_combobox_interface->currentText() << std::endl
    << "LASTADDR=" << (const char*)_widget_config->ui_lineedit_ip->text() << std::endl
    << "HOSTNAME=" << (const char*)_widget_config->ui_lineedit_hostname->text() << std::endl
    << "IP_UPDATE_INTERVAL=" << _widget_config->ui_spinbox_updateinterval->value() << std::endl
    << "HOST_LIST_FILE=" << (const char*)_widget_config->ui_lineedit_hostlistfile->text() << std::endl
    << "FILE_ASSOCIATIONS=" << _widget_config->ui_checkbox_fileassociations->isChecked() << std::endl
    << "STYLE=" << _style_s << std::endl
#endif
    << "SPEED=" << (const char*)_widget_config->ui_combobox_speed->currentText() << std::endl
    << "SEARCHSPEED=" << (const char*)_widget_search->ui_combobox_searchspeed->currentText() << std::endl
    << "LOGLEVEL=" << (const char*)_widget_logs->ui_combobox_loglevel->currentText() << std::endl;

  f << "MAXDOWNLOADS=" << _widget_config->ui_spinbox_maxdownloads->value() << std::endl
    << "MAXUPLOADS=" << _widget_config->ui_spinbox_maxuploads->value() << std::endl
    << "MAXUPLOADS_PER_USER=" << _widget_config->ui_max_up_per_user->value() << std::endl
    << "UPLOADBANDWIDTH=" << _widget_config->ui_spinbox_upbandwidth->value() << std::endl
    << "FILENAME_LENGTH=" << _widget_config->ui_spinbox_filelength->value() << std::endl
    << "SAVE_HOST_LIST=" << _widget_config->ui_checkbox_savehostlist->isChecked() << std::endl
    << "ONSTART_CONNECT=" << _widget_config->ui_checkbox_conf_autoconnect->isChecked() << std::endl
    << "ONEXIT_REMOVE=" << _widget_config->ui_checkbox_conf_removefiles->isChecked() << std::endl
    << "ONEXIT_REMOVEALL=" << _widget_config->ui_checkbox_conf_removeall->isChecked() << std::endl
    << "ONEXIT_REMOVE_SIZE=" << _widget_config->ui_spinbox_conf_filesize->value() << std::endl
    << "ENABLE_IN_SEARCHES=" << _widget_logs->ui_checkbox_incomingsearch->isChecked() << std::endl
    << "ENABLE_LOGS=" << _widget_logs->ui_checkbox_enablelogs->isChecked() << std::endl
    << "RETRIES=" << _widget_config->ui_spinbox_conf_retries->value() << std::endl
    << "IGNORE_FIREWALLED=" << _widget_config->ui_checkbox_ignorefirewalled->isChecked() << std::endl
    << "IGNORE_BUSY=" << _widget_config->ui_checkbox_ignorebusy->isChecked() << std::endl
    << "FILTER_PRIVATE_IP=" << _widget_connections->ui_checkbox_filterip->isChecked() << std::endl;

  f << "IMAGES=" << (const char*)_widget_config->ui_lineedit_images->text() << std::endl
    << "VIDEOS=" << (const char*)_widget_config->ui_lineedit_video->text() << std::endl
    << "AUDIO=" << (const char*)_widget_config->ui_lineedit_audio->text() << std::endl
    << "NHOSTS=" << _widget_connections->ui_spinbox_hosts->value() << std::endl
    << "TTL=" << _widget_config->ui_spinbox_ttl->value() << std::endl
    << "INCONNECTS=" << _widget_connections->ui_spinbox_inconnects->value() << std::endl
    << "VERSION=" << VERSION << std::endl
    << "DL_PER_HOST=" << _widget_config->ui_spinbox_dl_per_host->value() << std::endl
    << "SHOW_DELETE_DIALOG=" << _show_delete_dialog << std::endl
    << "TABSIZE_DOWNLOAD=" << _widget_downloads->ui_listview_download->columnWidth(0) << std::endl
    << "TABSIZE_SHARED=" << _widget_shared->ui_listview_shared->columnWidth(0) << std::endl
    << "TABSIZE_UPLOADS=" << _widget_uploads->ui_listview_uploads->columnWidth(0) << std::endl
    << "TABSIZE_INTERRUPT=" << _widget_interrupted->ui_listview_interrupt->columnWidth(0) << std::endl
    << "TABSIZE_SEARCH=" << _search_column_size << std::endl;

  f << "SHOW_PROGR_BAR=" << _widget_config->ui_checkbox_showprogressbar->isChecked() << std::endl
    << "NUMERIC_PROGRESS=" << _widget_config->ui_checkbox_numericprogress->isChecked() << std::endl
    << "HIDE_FILENAME=" << _widget_config->ui_checkbox_hidefilename->isChecked() << std::endl
    << "HIDE_FILESIZE=" << _widget_config->ui_checkbox_hidefilesize->isChecked() << std::endl
    << "SEARCHES_MATCH=" << _widget_logs->ui_checkbox_searches_match->isChecked() << std::endl
    << "SORT_CASESENSITIVE=" << _widget_config->ui_checkbox_casesensitive->isChecked() << std::endl
    << "SHOW_UP_PROGR_BAR=" << _widget_config->ui_checkbox_up_showprogressbar->isChecked() << std::endl
    << "NUMERIC_UP_PROGRESS=" << _widget_config->ui_checkbox_up_progressvalue->isChecked() << std::endl
    << "GROUP_SIZE=" << _widget_search->ui_checkbox_group_size->isChecked() << std::endl
    << "SYSTEM_TRAY=" << _widget_config->ui_checkbox_systemtray->isChecked() << std::endl
//     << "VIEW_CONNECTIONS=" << _view->isItemChecked(1) << std::endl
//     << "VIEW_SEARCH=" << _view->isItemChecked(2) << std::endl
    << "SHOW_ONLY_ESTABLISHED=" << _widget_connections->ui_checkbox_showestablished->isChecked() << std::endl;

  f << "USER=" << (const char*)_widget_config->ui_lineedit_userid->text() << std::endl
    << "GROUP=" << (const char*)_widget_config->ui_lineedit_userid->text() << std::endl
    << "RESERVE_IN=" << _widget_config->ui_checkbox_reserve_in->isChecked() << std::endl
    << "RESERVE_UP=" << _widget_config->ui_checkbox_reserve_up->isChecked() << std::endl;
  
  f << "GROUPS=";
  for( int i = 0; i < _widget_config->ui_listbox_groups->count(); ++i )
    f << (const char*)_widget_config->ui_listbox_groups->text( i ) << ";";
  f << std::endl;
  
  f << "USERS=";
  for( int i = 0; i < _widget_config->ui_listbox_users->count(); ++i )
    f << (const char*)_widget_config->ui_listbox_users->text( i ) << ";";
  f << std::endl;

  f //<< "VIEW_DOWNLOADS=" << _view->isItemChecked(3) << std::endl
    //<< "VIEW_UPLOADS=" << _view->isItemChecked(4) << std::endl
    //<< "VIEW_SHARED_FILES=" << _view->isItemChecked(5) << std::endl
    //<< "VIEW_LOGS=" << _view->isItemChecked(6) << std::endl
    //<< "VIEW_STATISTICS=" << _view->isItemChecked(7) << std::endl
    //<< "VIEW_HOSTCACHE=" << _view->isItemChecked(8) << std::endl
    //<< "VIEW_INTERRUPTED_DL=" << _view->isItemChecked(9) << std::endl
    //<< "VIEW_CONFIGURATION=" <<  _view->isItemChecked(10)<< std::endl
    << "USE_OPENSOURCEP2P=" << _use_opensourcep2p << std::endl
    << "LAST_DL_TO_DIR=" << _last_download_to_dir << std::endl
    << "SHAREDDIR=";

  int i;

  for(i = 0; i < _widget_config->ui_listbox_shareddirectories->count(); i++)
    f << (const char*)_widget_config->ui_listbox_shareddirectories->text(i) << ";";

  f << std::endl;
  
  for(i = 0; i < _applications.size(); ++i)
    f << "APPS=" << (_applications[i].first + ":" + _applications[i].second) << std::endl;

  f << "AUTOCONNECT=";
  for(i = 0; i < _widget_connections->ui_listbox_autoconnect->count(); i++)
    f << (const char*)_widget_connections->ui_listbox_autoconnect->text(i) << ";";
  f << std::endl;

  f << "EXISTING_FILES=";
  if(_widget_config->ui_radiobutton_e_overwrite->isChecked()) f << "0";
  if(_widget_config->ui_radiobutton_e_rename->isChecked()) f << "1";
  if(_widget_config->ui_radiobutton_e_abort->isChecked()) f << "2";
  f << std::endl;

  f << "ABORT_DOWNLOADS=";
  if(_widget_config->ui_radiobutton_a_contsize->isChecked()) f << "0";
  if(_widget_config->ui_radiobutton_a_conthost->isChecked()) f << "1";
  if(_widget_config->ui_radiobutton_a_contsizehost->isChecked()) f << "2";
  if(_widget_config->ui_radiobutton_a_startnew->isChecked()) f << "3";
  f << std::endl;

  f << "BLOCKED_HOSTS=";
  for(i = 0; i < _widget_config->ui_listbox_blockedhosts->count(); ++i)
    f << (const char*)_widget_config->ui_listbox_blockedhosts->text(i) << ";";
  f << std::endl;

#ifndef SHARP
	f << "CONNECTIONS_VISIBLE=" << _widget_connections->isVisible() << std::endl;
	f << "SEARCH_VISIBLE=" << _widget_search->isVisible() << std::endl;
	f << "DOWNLOADS_VISIBLE=" << _widget_downloads->isVisible() << std::endl;
	f << "UPLOADS_VISIBLE=" << _widget_uploads->isVisible() << std::endl;
	f << "STATS_VISIBLE=" << _widget_stats->isVisible() << std::endl;
	f << "CONFIG_VISIBLE=" << _widget_config->isVisible() << std::endl;
	f << "SHARED_VISIBLE=" << _widget_shared->isVisible() << std::endl;
	f << "INTERRUPTED_VISIBLE=" << _widget_interrupted->isVisible() << std::endl;
	f << "LOGS_VISIBLE=" << _widget_logs->isVisible() << std::endl;
#endif

	bool t = _widget_connections->isMaximized() | _widget_search->isMaximized() |
		_widget_downloads->isMaximized() | _widget_uploads->isMaximized() | _widget_stats->isMaximized() |
		_widget_config->isMaximized() | _widget_shared->isMaximized() | _widget_interrupted->isMaximized() |
		_widget_logs->isMaximized();
	f << "SUB_WINDOWS_MAXIMIZED=" << t << std::endl;
	if( ! t )
		{
			f << "GEO_CONNECTIONS=";
			f << _widget_connections->parentWidget()->pos().x() << "," 
				<< _widget_connections->parentWidget()->pos().y() << ","
				<< _widget_connections->width() << "," << _widget_connections->height() << std::endl;
			f << "GEO_SEARCH=";
			f << _widget_search->parentWidget()->pos().x() << "," 
				<< _widget_search->parentWidget()->pos().y() << ","
				<< _widget_search->width() << "," << _widget_search->height() << std::endl;
			f << "GEO_DOWNLOADS=";
			f << _widget_downloads->parentWidget()->pos().x() << "," 
				<< _widget_downloads->parentWidget()->pos().y() << ","
				<< _widget_downloads->width() << "," << _widget_downloads->height() << std::endl;
			f << "GEO_UPLOADS=";
			f << _widget_uploads->parentWidget()->pos().x() << "," 
				<< _widget_uploads->parentWidget()->pos().y() << ","
				<< _widget_uploads->width() << "," << _widget_uploads->height() << std::endl;
			f << "GEO_STATS=";
			f << _widget_stats->parentWidget()->pos().x() << "," 
				<< _widget_stats->parentWidget()->pos().y() << ","
				<< _widget_stats->width() << "," << _widget_stats->height() << std::endl;
			f << "GEO_CONFIG=";
			f << _widget_config->parentWidget()->pos().x() << "," 
				<< _widget_config->parentWidget()->pos().y() << ","
				<< _widget_config->width() << "," << _widget_config->height() << std::endl;
			f << "GEO_SHARED=";
			f << _widget_shared->parentWidget()->pos().x() << "," 
				<< _widget_shared->parentWidget()->pos().y() << ","
				<< _widget_shared->width() << "," << _widget_shared->height() << std::endl;
			f << "GEO_INTERRUPTED=";
			f << _widget_interrupted->parentWidget()->pos().x() << "," 
				<< _widget_interrupted->parentWidget()->pos().y() << ","
				<< _widget_interrupted->width() << "," << _widget_interrupted->height() << std::endl;
			f << "GEO_LOGS=";
			f << _widget_logs->parentWidget()->pos().x() << "," 
				<< _widget_logs->parentWidget()->pos().y() << ","
				<< _widget_logs->width() << "," << _widget_logs->height() << std::endl;
		}

  f.close();
}


const void QtellaSub::setReportedIP(const std::string& ip)
{
#ifndef SHARP
  std::string iface(_widget_config->ui_combobox_interface->currentText().latin1());

  if( iface == std::string( QObject::tr("automatic", "network interface").latin1() ) )
    {
      _last_addr = ip;
      slotIPUpdate();
    }
#else
  _last_addr = ip;
#endif
}


void QtellaSub::slotCancelConfig()
{
	_widget_config->hide();
}


// 	_widget_connections->showMaximized();
// 	_widget_search->showMaximized();
// 	_widget_downloads->showMaximized();
// 	_widget_uploads->showMaximized();
// 	_widget_stats->showMaximized();
// 	_widget_config->showMaximized();
// 	_widget_shared->showMaximized();
// 	_widget_interrupted->showMaximized();
// 	_widget_logs->showMaximized();
