#include "QtellaSub.h"
#include "SearchViewItem.h"
#include "BlockHost.h"
#include "Search.h"
#include "Connections.h"
#include "SearchWidget.h"
#include "QueryHitEntry.h"
#include "WidgetConfig.h"

#include <qlistbox.h>
#include <qlistview.h>
#include <qfiledialog.h>
#include <qlineedit.h>
#include <qdialog.h>

void QtellaSub::slotAddBlockedHost()
{
  BlockHost bh(0, 0, true);
  
  if( bh.exec() == QDialog::Accepted )
    _widget_config->ui_listbox_blockedhosts->insertItem(bh.ui_lineedit_ip->text());
}


void QtellaSub::slotDeleteBlockedHost()
{
  int i = 0;

  while( i < _widget_config->ui_listbox_blockedhosts->count() )
    if( _widget_config->ui_listbox_blockedhosts->isSelected(i) )
      _widget_config->ui_listbox_blockedhosts->removeItem(i);
    else
      ++i;
}


void QtellaSub::slotGroupSize(int state)
{
  // 2 = on
  // 0 = off

  std::vector<Search*>::iterator pos = connections->_search.begin();

  for( pos; pos != connections->_search.end(); ++pos )
    {
      if( state == 0 )
		{
		  QListViewItem* item = (*pos)->sw->ui_listview_search->firstChild();
		  
		  while( item )
			{
			  QListViewItem* child = item->firstChild();
			  while( child )
				{
				  child->moveItem( item );
				  child = item->firstChild();
				}
			  item = item->nextSibling();
			}
		  
		}
      else
		if ( state == 2 )
		  {
			Search::SIZEMAP m;
			Search::SIZEMAP::iterator p = (*pos)->_size_map.begin();
			
			while( p != (*pos)->_size_map.end() )
			  {
				static_cast<SearchViewItem*>(p->second->item)->_group_parent = false;
				
				Search::SIZEMAP::iterator n = m.find( p->first );
				
				if( n == m.end() )
				  m.insert( std::make_pair( p->first, p->second ) );
				else
				  {
					static_cast<SearchViewItem*>( n->second->item )->_group_parent = true;
					
					(*pos)->sw->ui_listview_search->takeItem( p->second->item);
					n->second->item->insertItem( p->second->item );
				  }
				
				++p;
			  }
		  }
    }
}


void QtellaSub::slotChangeHostlistFile()
{
#ifndef SHARP
  QFileDialog d(this, 0, true);

  if(d.exec())
      _widget_config->ui_lineedit_hostlistfile->setText( d.selectedFile() );
#endif
}
