#include "QtellaSub.h"
#include "SharedFile.h"
#include "SearchWidget.h"
#include "Connections.h"
#include "DownloadManager.h"
#include "UploadManager.h"
#include "Search.h"
#include "DownloadTo.h"
#if !defined(_WIN32)
#include "AudioFile.h"
#endif
#include "SearchSharedFiles.h"
#include "SearchViewItem.h"
#include "RenameFile.h"
#include "QueryHitEntry.h"
#include "SharedViewItem.h"
#include "WidgetSearch.h"
#include "WidgetSharedFiles.h"
#include "WidgetConfig.h"

#include <string>
#include <strstream>
#include <vector>
#include <iostream>
#include <iomanip>

#include "qlistbox.h"
#include "qcheckbox.h"
#include "qtabwidget.h"
#include "qdialog.h"
#include "qlabel.h"
#include "qfile.h"
#include "qmessagebox.h"
#include "qlineedit.h"

void QtellaSub::slotDownloadAll()
{
  int           m = -1;
  int           i;
  SearchWidget* s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  for(i = 0; i < connections->_search.size(); i++) 
    if(connections->_search[i]->sw == s) m = i;

  if(m > -1)
    {
      std::multimap< unsigned long, QueryHitEntry* > mm;

      for(i = 0; i < connections->_search[m]->vSearchResults.size(); i++)
	if( connections->_search[m]->vSearchResults[i]->item->isSelected() )
	  {
	    QueryHitEntry*    qhe = connections->_search[m]->vSearchResults[i];
	    unsigned long     fs  = qhe->size;

	    mm.insert( std::make_pair( fs, qhe ) );
	  }

      std::multimap< unsigned long, QueryHitEntry* >::iterator pos = mm.begin();
      std::vector< QueryHitEntry* > v;
      
      while( pos != mm.end() )
	{
	  v.push_back(pos->second);
	  ++pos;
	  while( ( pos != mm.end() ) && ( pos->first == v[0]->size ) ) 
	    {
	      v.push_back(pos->second);
	      ++pos;
	    }

	  download_manager->addDownload(v); // download these files as segmented download
	  v.clear();
	}
    }
}


void QtellaSub::slotDownloadTo()
{
  int i;
  DownloadTo dt(0, 0, true);

  for(i = 0; i < _widget_config->ui_listbox_shareddirectories->count(); ++i)
    dt.ui_listbox->insertItem( _widget_config->ui_listbox_shareddirectories->text(i) );

  dt.ui_lineedit->setText( _last_download_to_dir.c_str() );

  if( dt.exec() != QDialog::Accepted ) return;

  std::string dir;
  if( dt.ui_checkbox_shared->isChecked() )
    if( dt.ui_listbox->currentItem() != -1 ) dir = (const char*)dt.ui_listbox->currentText();

  if( dt.ui_checkbox_other->isChecked() )
    dir = (const char*)dt.ui_lineedit->text();

  if( dir.empty() ) return;

  int          m = -1;
  SearchWidget *s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  for(i = 0; i < connections->_search.size(); i++) 
    if(connections->_search[i]->sw == s) m = i;

  if(m > -1)
    {
      int counts = 0;

      for(i = 0; i < connections->_search[m]->vSearchResults.size(); i++)
        if( connections->_search[m]->vSearchResults[i]->item->isSelected() )
          {
            downloadItem(connections->_search[m]->vSearchResults[i]->item, dir);
            counts++;
          }
    }
}


void QtellaSub::slotSearchStopDownload()
{
  SearchWidget *s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  for(int j = 0; j < connections->_search.size(); j++) 
    if(connections->_search[j]->sw == s)
      {
	for(int i = 0; i < connections->_search[j]->vSearchResults.size(); i++)
	  if( connections->_search[j]->vSearchResults[i]->item->isSelected() )
	    {
	      download_manager->abortDownload(*connections->_search[j]->vSearchResults[i]);
	      break;
	    }
	
	break;
      }
}

void QtellaSub::slotSearchRemoveDownload()
{
  SearchWidget *s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  for(int j = 0; j < connections->_search.size(); j++) 
    if(connections->_search[j]->sw == s)
      {
	for(int i = 0; i < connections->_search[j]->vSearchResults.size(); i++)
	  if( connections->_search[j]->vSearchResults[i]->item->isSelected() )
	    download_manager->removeDownload(*connections->_search[j]->vSearchResults[i]);
	
	break;
      }
}

void QtellaSub::slotSearchDeleteDownload()
{
  SearchWidget *s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  for(int j = 0; j < connections->_search.size(); j++) 
    if(connections->_search[j]->sw == s)
      {
	for(int i = 0; i < connections->_search[j]->vSearchResults.size(); i++)
	  if( connections->_search[j]->vSearchResults[i]->item->isSelected() )
	    {
	      download_manager->deleteDownload(*connections->_search[j]->vSearchResults[i]);
	      break;
	    }
	
	break;
      }
}


void QtellaSub::slotAbortUpload()
{
  upload_manager->abortUpload();
}


void QtellaSub::slotRemoveUpload()
{
  upload_manager->removeUpload();
}


void QtellaSub::slotUploadBlockHost()
{
  upload_manager->blockHost(_widget_config->ui_listbox_blockedhosts);
}


void QtellaSub::slotClearInactiveUploads()
{
  upload_manager->removeInactiveUploads();
}


void QtellaSub::slotSharedFilesLaunch()
{
  std::vector<std::string> files;

  std::vector<SharedFile*>::iterator  pos = vSharedFiles.begin();
  while(pos != vSharedFiles.end())
    {
      if((*pos)->item->isSelected()) files.push_back( (*pos)->directory + "/" + (*pos)->file );
      ++pos;
    }

  launchFileList(files);
}


void QtellaSub::slotSharedProperties()
{
  std::vector<SharedFile*>::iterator  pos = vSharedFiles.begin();
  while(pos != vSharedFiles.end())
    {
      if((*pos)->item->isSelected()) 
	{
	  AudioFile p(this, tr("Properties", "of mp3 files"), true);
	  p.setFile((*pos)->directory, (*pos)->file, true);
	  p.setProperty();
	  p.exec();
	  break;
	}
      else
	++pos;
    }
}


void QtellaSub::slotRefreshSharedList()
{
  std::vector<SharedFile*>  old = vSharedFiles;

  number_shared_files = 0;
  shared_size = 0;

#ifndef SHARP
  mutex_shared_files.lock();
#endif

  vSharedFiles.clear();
  _hash_table.clear();
  _sharedsize_set.clear();

  int i;

  for(i = 0; i < _widget_config->ui_listbox_shareddirectories->count(); i++)
    {
      std::string directory = (const char*)_widget_config->ui_listbox_shareddirectories->text(i);

      if( ! directory.empty() && directory[directory.size()-1] == '/' )
        directory.erase( directory.size(), 1 );
      
      checkDirectories(directory, &old);
    }

  for(i = 0; i < old.size(); i++) delete old[i];

  for(i = 0; i < vSharedFiles.size(); ++i)
    shared_size += vSharedFiles[i]->size;

  number_shared_files = vSharedFiles.size();

#ifndef SHARP
  mutex_shared_files.unlock();
#endif

  // status line

  connections->_statistic.shared_files = number_shared_files;
  connections->_statistic.shared_size = shared_size;

  unsigned long files = number_shared_files;
  double        size  = shared_size;
  std::strstream str;
  std::string u;

  str.seekp(0, std::ios::beg);
  if(files > 1024) { files = files >> 10; u = "K"; };
  if(files > 1024) { files = files >> 10; u = "M"; };
  str << files << u << std::ends;
  _widget_shared->ui_textlabel_sharedfiles->setText(str.str());
  str.freeze(false);
  
  u = "";
  str.seekp(0, std::ios::beg);
  str.setf(std::ios::fixed);
  if(size > 1024) { size /= 1024; u = "KB"; }
  if(size > 1024) { size /= 1024; u = "MB"; }
  str << std::setprecision(1) << size << u << std::ends;
  _widget_shared->ui_textlabel_sharedsize->setText(str.str());
  str.freeze(false);

  SearchSharedFiles::getInstance()->update();
}


void QtellaSub::slotDeleteSharedFile()
{
  std::vector<SharedFile*>::iterator  pos = vSharedFiles.begin();
  
  for(pos; pos != vSharedFiles.end(); ++pos)
    if( (*pos)->item->isSelected() )
      {
	QFile f( (*pos)->completeFilename().c_str() );
	f.remove();
      }

  slotRefreshSharedList();
}


void QtellaSub::slotRenameSharedFile()
{
  std::vector<SharedFile*>::iterator  pos = vSharedFiles.begin();
  
  for(pos; pos != vSharedFiles.end(); ++pos)
    if( (*pos)->item->isSelected() )
      {
	RenameFile rf(this, 0, true);

	rf.ui_textlabel_directory->setText( (*pos)->directory.c_str() );
	rf.ui_edit_filename->setText( (*pos)->file.c_str() );

	if( rf.exec() )
	  if( ! (*pos)->renameFile(std::string(rf.ui_edit_filename->text().latin1())) )
	    QMessageBox::warning(this, tr("Error"), tr("Cannot rename file."), QMessageBox::Ok, 0);
      }
}


void QtellaSub::slotBlockHost()
{
  SearchWidget* s = (SearchWidget*) _widget_search->ui_tabwidget_search->currentPage();

  if( ! s )
    return;

  for( int i = 0; i < connections->_search.size(); ++i )
    if( connections->_search[i]->sw == s )
      {
        // found the right window with the list
        
        for( int j = 0; j < connections->_search[i]->vSearchResults.size(); ++j )
          if( connections->_search[i]->vSearchResults[j]->item->isSelected() )
            {
              // add host to the blocked host list if it does not exist yet
              bool        e = false;
              std::string b = connections->_search[i]->vSearchResults[j]->addr.strIP();
              
              for( int k = 0; k < _widget_config->ui_listbox_blockedhosts->count(); ++k )
                {
                  std::string a = static_cast<const char*>( _widget_config->ui_listbox_blockedhosts->text( k ) );
                  
                  if( a == b )
                    {
                      e = true;
                      break;
                    }
                }
              
              if( ! e )
                _widget_config->ui_listbox_blockedhosts->insertItem( b.c_str() );
              
              break;
            }
      }
}
