#include "QtellaSub.h"
#include "Info.h"
#include "Connections.h"
#include "InterruptedDownloads.h"
#include "WidgetStats.h"
#include "WidgetLogs.h"

#include <string>

#if QT_VERSION < 300
#include <qplatinumstyle.h>
#include <qwindowsstyle.h>
#include <qmotifstyle.h>
#include <qmotifplusstyle.h>
#include <qcdestyle.h>
#include <qsgistyle.h>
#else
#include <qstylefactory.h>
#endif

#ifdef USEKDE
#if QT_VERSION < 300      /* patch by N.Cat 2002/03/07 */
#include "kdestyle.h" 
#endif
#endif

#include "qfont.h"
#include "qfontdialog.h"
#include "qwidget.h"
#include "qstring.h"
#include "qtabwidget.h"
#include "qtimer.h"
#include "qlabel.h"
#include "qpopupmenu.h"
#include "qlistbox.h"

void QtellaSub::slotStyle(int st)
{
#if QT_VERSION >= 300
  QStyle *style=QStyleFactory::create(_style->text(st).mid(1));
  if(style)
    qApp->setStyle(style);
#endif
}

void QtellaSub::slotStylePlatinum()
{
#ifndef SHARP
#if QT_VERSION < 300
  qApp->setStyle( new QPlatinumStyle() );
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(0, true);
  _style_s = "PLATINUM";
#endif
#endif
}

void QtellaSub::slotStyleWindows()
{
#ifndef SHARP
#if QT_VERSION < 300
  qApp->setStyle( new QWindowsStyle() );
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(2, true);
  _style_s = "WINDOWS";
#endif
#endif
}

void QtellaSub::slotStyleMotif()
{
#ifndef SHARP
#if QT_VERSION < 300
  qApp->setStyle( new QMotifStyle() );
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(3, true);
  _style_s = "MOTIF";
#endif
#endif
}

void QtellaSub::slotStyleMotifPlus()
{
#ifndef SHARP
#if QT_VERSION < 300
  qApp->setStyle( new QMotifPlusStyle() );
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(4, true);
  _style_s = "MOTIFPLUS";  
#endif
#endif
}

void QtellaSub::slotStyleCDE()
{
#ifndef SHARP
#if QT_VERSION < 300
  qApp->setStyle( new QCDEStyle() );
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(5, true);
  _style_s = "CDE";
#endif
#endif
}

void QtellaSub::slotStyleSGI()
{
#ifndef SHARP
#if QT_VERSION < 300
  qApp->setStyle( new QSGIStyle() );
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(1, true);
  _style_s = "SGI";
#endif
#endif
}

void QtellaSub::slotStyleKDE()
{
#ifndef SHARP
#if QT_VERSION < 300
#ifdef USEKDE
  qApp->setStyle( new KDEStyle() );
  qApp->setPalette(_palette, true);
  menu->setPalette(_menu_palette, true);
  for(int i = 0; i < 7; ++i) _style->setItemChecked(i, false);
  _style->setItemChecked(6, true);
  _style_s = "KDE";
#endif
#endif
#endif
}

void QtellaSub::slotChangeFont()
{
#ifndef SHARP
  bool ok;

  QFont font = QFontDialog::getFont(&ok, _current_font, this);

  if(ok)
    {
      _current_font = font;
      qApp->setFont(font, true);
    }
#endif
}

// void QtellaSub::slotViewChanged(int id)
// {
// #ifndef SHARP
//   QWidget* a[10] = { 
// #else
//   QWidget* a[8] = {
// #endif
//     page_connections, 
//     page_search, 
//     page_downloads, 
//     page_uploads,
//     page_shared_files, 
// #ifndef SHARP
//     page_logs, 
// #endif
//     page_statistics, 
// #ifndef SHARP
//     page_hostcache,
// #endif
//     page_interrupted_dl, 
//     page_configuration 
//   };

// #ifndef SHARP
//   QString titles[10] = {
// #else
//   QString titles[8] = {
// #endif
//     tr("Connections"),
//     tr("Search"),
//     tr("Downloads"),
//     tr("Uploads"),
//     tr("Shared Files"),
// #ifndef SHARP
//     tr("Logs"),
// #endif
//     tr("Statistics"),
// #ifndef SHARP
//     tr("HostCache"),
// #endif
//     tr("Interrupted DL"),
//     tr("Configuration")
//   };

//   if( _view->isItemChecked(id) )
//     {
//       _view->setItemChecked(id, false);
//       Tabular->removePage(a[id-1]);
//     }
//   else
//     {
//       int position = id - 1;

//       for(int i = 1; i < id; ++i)
// 	if( ! _view->isItemChecked(i) ) --position;

//       _view->setItemChecked(id, true);
//       Tabular->insertTab(a[id-1], titles[id-1], position);
//     }
// }

void QtellaSub::slotConnect()
{
  QtellaSub::getInstance()->_incoming_allowed = true;

  if( ! timer_connection->isActive() )
    {
      connections->start();
      timer_connection->start(1000);
    }
}


void QtellaSub::slotDisconnect()
{
  QtellaSub::getInstance()->_incoming_allowed = false;

  if( timer_connection->isActive() )
    {
      timer_connection->stop();
      connections->disconnect();
    }
}

void QtellaSub::slotConvertFilenames()
{
  _interrupted_downloads->convertFilenames();
}

void QtellaSub::slotInfo()
{
  Info i(this, tr("Info"), true);
  i.ui_textlabel_version->setText( ( std::string(VERSION) + std::string(ADDITIONAL_VERSION_STR) ).c_str() );
  i.exec();
}

void QtellaSub::slotClearLog()
{
  _widget_logs->ui_listbox_logs->clear();
}
