#include "Gnutella.h"
#include "Query.h"
#include "Message.h"

Query::Query(const Q_UINT8 ttl, const Q_UINT8 hops, const std::string id, const Q_UINT16 speed, const std::string search)
  : _id(id), _ttl(ttl), _hops(hops), _min_speed(speed), _search(search)
{
  toString();
}

Query::Query(const Q_UINT8 ttl, const Q_UINT8 hops, const std::string id, const std::string data)
  : _id(id), _ttl(ttl), _hops(hops)
{
  _min_speed = Message::str_uint16(data.substr(0, 2).c_str());
  _search = data.substr(2);

  toString();
}

void Query::toString()
{
  std::string s = _search;

  if(_search.size() > 0)
    if(_search[_search.size()-1] != 0) s.append("\0\0", 2);

  Q_UINT32 payload = 2 + s.size();

  _data = _id;

  _data += static_cast<char>(CMD_QUERY);
  _data += static_cast<char>(_ttl);
  _data += static_cast<char>(_hops);

  _data.append( Message::uint_str(payload) );
  _data.append( Message::uint_str(_min_speed) );
  _data.append( s );
}

