#include "QueryHitEntry.h"
#include "QtellaSub.h"
#include <qlistview.h>

const int QueryHitEntry::Busy = 1;
const int QueryHitEntry::Ready = 2;
const int QueryHitEntry::Firewalled = 4;
const int QueryHitEntry::Unknown = 8;

QueryHitEntry::QueryHitEntry(std::string& filename, const Q_UINT32 size, const Q_UINT32 index, const Q_UINT32 speed, int status, Address& addr, std::string& id, QListViewItem *item)
{
  this->filename = filename;
  this->size = size;
  this->index = index;
  this->addr = addr;
  this->id = id;
  this->item = item;
  this->speed = speed;
  this->status = status;
}

QueryHitEntry::QueryHitEntry()
{
  filename = "";
  size = 0;
  index = 0;
  addr = Address();
  id = "";
  item = NULL;
  speed = 0;
  status = Unknown;
}

QueryHitEntry::~QueryHitEntry()
{
  if(item)
    {
      QtellaSub* p = QtellaSub::getInstance();
      p->_search_item_set.erase(p->_search_item_set.find(item));
      
      delete item;
      item = NULL;
    }
}


bool QueryHitEntry::firewalled()
{
  return ( (status&Firewalled) > 0);
}
