#include "Search.h"
#include "SearchWidget.h"
#include "QueryHitEntry.h"

Search::Search( std::string id, SearchWidget *sw, Q_UINT16 min_speed, 
				bool audio, bool video, bool images, bool any, bool active)
  : _min_speed(min_speed), _audio(audio), _video(video), _images(images), _any(any)
{
  this->id = id;
  this->sw = sw;
  this->active = active;
}

Search::~Search()
{
  for(int i = 0; i < vSearchResults.size(); i++) delete vSearchResults[i];
}

const bool Search::duplicate( const Q_UINT32 ip, const QueryResult& qr )
{
	if( _multiple_filter.find( ip ) == _multiple_filter.end() ) 
		{
			// IP was unknown
			_multiple_filter[ip].insert( qr._filename );
			return false;
		}
	
	if( _multiple_filter[ip].find( qr._filename ) != _multiple_filter[ip].end() )
		// Known IP, known file
		return true;
	
	// Known IP, unknown file => insert it
	_multiple_filter[ip].insert(qr._filename);
	return false;
}

void Search::mutateID( const std::string& id )
{
	this->id = id;
}
