#include "../include/SearchDialog.h"
#include <qlineedit.h>

/* 
 *  Constructs a SearchDialog which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SearchDialog::SearchDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : BSearchDialog( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SearchDialog::~SearchDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

void SearchDialog::setQuery(std::string s)
{
  ui_lineedit->setText(s.c_str());
}

std::string SearchDialog::getQuery()
{
  return std::string(ui_lineedit->text().latin1());
}
