#include <iostream>
#include <qdir.h>
#include <qfile.h>
#include <qregexp.h>
#include <qstring.h>
#include <qtabwidget.h>
#include <qtextstream.h>

#include "Search.h"
#include "SearchPersistence.h"
#include "SearchPersistenceParser.h"

static QRegExp amp("\\&");
static QRegExp quot("\"");

void SearchPersistence::save(const std::vector<Search *> &search)
{
      QString searchFileName = QDir::homeDirPath() + "/.qtella/searches.xml";
      QFile storage(searchFileName);
      if (!storage.open(IO_WriteOnly)) {
	    std::cerr << "Unable to create searches memo file " << searchFileName << endl;
	    return;
      }

      QTextStream stream(&storage);
      stream << "<?xml version=\"1.0\"?>\n<SEARCHES VERSION=\"1.0\">\n";
      for(std::vector<Search *>::const_iterator i = search.begin(); i != search.end(); ++i) {
	    const Search &s = (**i);
	    stream << "\t<SEARCH QUERY=\"";
	    QString l = s.query.c_str();
	    l.replace(amp, "&amp;");
	    l.replace(quot, "&quot;");
	    stream << l << '"';
	    if (s._audio) stream << " AUDIO=\"1\"";
	    if (s._video) stream << " VIDEO=\"1\"";
	    if (s._images) stream << " IMAGES=\"1\"";
	    if (s._any) stream << " ANY=\"1\"";
	    if (s._min_speed) stream << " MINSPEED=\"" << s._min_speed << '"';
	    stream << "/>\n";
      }
      stream << "</SEARCHES>\n";
}

void SearchPersistence::load()
{
      QString searchFileName = QDir::homeDirPath() + "/.qtella/searches.xml";
      QFile storage(searchFileName);
      if (!storage.open(IO_ReadOnly)) return;

      QXmlInputSource source(&storage);
      QXmlSimpleReader reader;
      SearchPersistenceParser parser;
      reader.setContentHandler(&parser);
      reader.parse(&source);
}
