#include "QtellaSub.h"
#include "SearchParameters.h"
#include "SearchPersistenceParser.h"

static const QString searches = "SEARCHES";
static const QString search_ = "SEARCH";
static const QString minspeed = "MINSPEED";
static const QString any = "ANY";
static const QString images = "IMAGES";
static const QString video = "VIDEO";
static const QString audio = "AUDIO";
static const QString query = "QUERY";

static void setBoolean(const QXmlAttributes &attr, const QString &fieldName, bool *field)
{
  QString value = attr.value(fieldName);
  if (value.isNull()) return;
  *field = true;
}

static void processSearch(const QXmlAttributes &attr)
{
  QString q = attr.value(query);
  if (q.isNull()) return;

  SearchParameters s;
  setBoolean(attr, audio, &s._audio);
  setBoolean(attr, video, &s._video);
  setBoolean(attr, images, &s._images);
  setBoolean(attr, any, &s._any);
  QString speed = attr.value(minspeed);
  if (!speed.isNull()) s._speed = speed.toUInt();
  std::string qu;
  qu.assign(q.latin1(), q.length());
  QtellaSub::getInstance() -> search(qu, &s);
}

bool SearchPersistenceParser::startElement(const QString&, const QString&localName, const QString&, const QXmlAttributes &attr)
{
  if (localName == searches)
    return true;
  else if (localName == search_)
    processSearch(attr);
  // Ignore unknown tags
  return true;
}
