#include "SearchSharedFiles.h"
#include "QtellaSub.h"
#include "SharedFile.h"
#include <cctype>

SearchSharedFiles* SearchSharedFiles::_instance = NULL;

SearchSharedFiles::SearchSharedFiles()
{
}

SearchSharedFiles* SearchSharedFiles::getInstance()
{
  if(!_instance) _instance = new SearchSharedFiles();
  return _instance;
}

void SearchSharedFiles::update()
{
  QtellaSub* p = QtellaSub::getInstance();

  _v.clear();

  for(int i = 0; i < p->vSharedFiles.size(); ++i)
    {
      std::string::size_type  idx;
      std::string             f = p->vSharedFiles[i]->file;
      std::string             sub;

      do
	{
	  idx = f.find_first_of(" -,()[]{}_");
	  if(idx != std::string::npos) 
	    {
	      sub = f.substr(0, idx);
	      f.erase(0, idx + 1);
	    }
	  else
	    {
	      sub = f;
	      f.erase();
	    }

	  if(sub.size() > 2)
	    {
	      for(int j = 0; j < sub.size(); ++j) sub[j] = tolower(sub[j]);

	      std::map<std::string, std::set<int> >::iterator pos = _v.find(sub);
	      if(pos == _v.end())
		{
		  std::set<int> s;
		  s.insert(i);
		  _v.insert( std::make_pair(sub, s) );
		}
	      else
		(pos->second).insert(i);
	    }
	}
      while(!f.empty());
    }
}

void SearchSharedFiles::search(std::string query, std::vector<int>& index_vector)
{
  std::string::size_type           idx;
  std::string                      sub;
  std::vector< std::set<int> >     v;
  int                              counter = 0;

  if(query.empty()) return;
  
  while(query[query.size()-1] == '\0') 
    {
      query = query.substr(0, query.size()-1);
      if(query.empty()) return;
    }

  std::string::size_type end = query.find('\0');
  if (end != std::string::npos) {
	// Discard extra data after the first '\0' in the query (for example, urn: or
	// anything else)
	query = query.substr(0, end);
  }

  do
    {
      idx = query.find_first_of(" -,()[]{}_");

      if(idx != std::string::npos) 
	{
	  sub = query.substr(0, idx);
	  query.erase(0, idx + 1);
	}
      else
	{
	  sub = query;
	  query.erase();
	}
      
      if(sub.size() > 2)
	{
	  ++counter;
	  for(int j = 0; j < sub.size(); ++j) sub[j] = tolower(sub[j]);

	  std::map<std::string, std::set<int> >::iterator pos = _v.find(sub);
	  if(pos == _v.end())
	    return;
	  else
	    v.push_back(pos->second);
	}
    }
  while(!query.empty());



  if(v.empty()) return;

  std::set<int>::iterator     pos = v[0].begin();

  if(v.size() == 1)
    {
      while(pos != v[0].end()) index_vector.push_back(*(pos++));
      return;
    }

  while(pos != v[0].end())
    {
      counter = 0;
      for(int i = 1; i < v.size(); ++i)
	if(v[i].find(*pos) != v[i].end()) ++counter;
	else
	  break;

      if(counter == (v.size()-1)) index_vector.push_back(*pos);
      ++pos;
    }
}
