#include "SearchViewItem.h"
#include "Connections.h"
#include "QueryHitEntry.h"
#include "QtellaSub.h"
#include "Search.h"
#include "SearchWidget.h"
#include "WidgetConfig.h"

#include <qlistview.h>
#include <qstring.h>
#include <qcheckbox.h>

#include <strstream>
#include <algorithm>
#include <cctype>

SearchViewItem::SearchViewItem(QListViewItem *parent, Connections* connections, QListView *search_list)
  : QListViewItem(parent, NULL, ""), _connections(connections), _parent(search_list), _group_parent(false)
{
}

SearchViewItem::SearchViewItem(QListView *parent, Connections* connections)
  : QListViewItem(parent), _connections(connections), _parent(parent), _group_parent(true)
{
}

SearchViewItem::SearchViewItem(QListView *parent, Connections* connections, QListViewItem *after)
  : QListViewItem(parent, after), _connections(connections), _parent(parent), _group_parent(true)
{
}

/* */

SearchViewItem::SearchViewItem( QListViewItem *parent, Connections* connections, QListView *search_list,
				const char* a, const char* b, const char* c, const char* d,
				const char* e, const char* f, const char* g )
  : QListViewItem(parent, a, "", b, c, d, e, f ), 
    _connections(connections), _parent(search_list), _group_parent(false)
{
  setData( a, b, c, d, e, f, g );
  setText( 7, g );
}

SearchViewItem::SearchViewItem( QListView *parent, Connections* connections, const char* a, const char* b,
				const char* c, const char* d, const char* e, const char* f, const char* g )
  : QListViewItem( parent, a, "", b, c, d, e, f ), 
    _connections(connections), _parent(parent), _group_parent(true)
{
  setData( a, b, c, d, e, f, g );
  setText( 7, g );
}

SearchViewItem::SearchViewItem( QListView *parent, Connections* connections, QListViewItem *after, const char* a,
				const char* b, const char* c, const char* d, const char* e,
				const char* f, const char* g )
  : QListViewItem( parent, after, a, "", b, c, d, e, f ), 
    _connections(connections), _parent(parent), _group_parent(true)
{
  setData( a, b, c, d, e, f, g );
  setText( 7, g );
}


const void SearchViewItem::setData( const char* hit, const char* filename, const char* type, const char* size,
				    const char* addr, const char* agent, const char* info )
{
  std::strstream str1;
  str1 << hit << std::ends;
  str1 >> _hit_counter;

  _filename_original = filename;

  for( int i = 0; i < _filename_original.size(); ++i )
	_filename_lower += tolower( _filename_original[i] );

//   transform( _filename_original.begin(), _filename_original.end(), back_inserter( _filename_lower ), tolower );

  std::string type_low( type );
  for( int j = 0; j < type_low.size(); ++j )
	_type += tolower( type_low[j] );

//   transform( type_low.begin(), type_low.end(), back_inserter( _type ), tolower );

  std::string ssize( size );
  std::string::size_type idx;
  while( ( idx = ssize.find( "," ) ) != std::string::npos )
    ssize.replace( idx, 1, "" );

  std::strstream str2;
  str2 << ssize << std::ends;
  str2 >> _size;

  _address = addr;
  _agent = agent;
  _info = info;
}


const void SearchViewItem::setState( const Q_UINT32 speed, const int state )
{
  _speed = speed;
  _state = state;
}


#if QT_VERSION >= 300
int SearchViewItem::compare( QListViewItem* item, int column, bool ascending ) const
{
  SearchViewItem* i = (SearchViewItem*)item;

  switch( column )
    {
    case 0: // hit counter
      if( _hit_counter < i->_hit_counter )
        return -1;
      else
        if( _hit_counter == i->_hit_counter )
          return 0;
        else
          return 1;
      
    case 1: // status
      if( _state == i->_state )
        {
          if( _speed > i->_speed )
            return -1;
          else
            if( _speed == i->_speed )
              return 0;
            else
              return 1;
        }
      else
        if( _state < i->_state )
          return -1;
        else
          return 1;
      
    case 2: // filename
      if( QtellaSub::getInstance()->_widget_config->ui_checkbox_casesensitive->isChecked() )
        {
          if( _filename_original < i->_filename_original )
            return -1;
          else
            if( _filename_original == i->_filename_original )
              return 0;
            else
              return 1;
        }
      else
        {
          if( _filename_lower < i->_filename_lower )
            return -1;
          else
            if( _filename_lower == i->_filename_lower )
              return 0;
            else
              return 1;
        }
      
    case 3: // type
      if( _type < i->_type )
        return -1;
      else
        if( _type == i->_type )
          return 0;
        else
          return 1;
      
    case 4: // size
      if( _size < i->_size )
        return -1;
      else
        if( _size == i->_size )
          return 0;
        else
          return 1;
      
    case 5: // address
      if( _address < i->_address )
        return -1;
      else
        if( _address == i->_address )
          return 0;
        else
          return 1;
      
    case 6: // agent
      if( _agent < i->_agent )
        return -1;
      else
        if( _agent == i->_agent )
          return 0;
        else
          return 1;
      
    case 7: // info
      if( _info < i->_info )
        return -1;
      else
        if( _info == i->_info )
          return 0;
        else
          return 1;
    }
  
  return 0;
}
#else
QString SearchViewItem::key(int column, bool ascending) const
{
  switch(column)
    {
    case 2:  // filename
      if( QtellaSub::getInstance()->_widget_config->ui_checkbox_casesensitive->isChecked() )
        return text(column).left(30); // if sorting is case-sensitive just return the string as it is
      else
        return text(column).lower().left(30);
      
    case 4:  // filesize
    case 0:  // hit number
      return text(column).rightJustify(15, '0') + text(0).rightJustify(10, '0');
      break;

    case 1:  // status
      int  i = 0;
      int  j = 0;
      int  n_search = _connections->_search.size();
      bool found = false;

      if(!n_search) break;

      for(i = 0; i < n_search; ++i)
        if(_connections->_search[i]->sw->ui_listview_search == _parent)
          {
            for(j = 0; j < _connections->_search[i]->vSearchResults.size(); ++j)
              if(_connections->_search[i]->vSearchResults[j]->item == (QListViewItem*)this ||
                 _connections->_search[i]->vSearchResults[j]->item == NULL )
                {
                  found = true;
                  break;
                }
            break;
          }
      
      if(found)
        {
          Q_UINT32 speed  = _connections->_search[i]->vSearchResults[j]->speed;
          int      status = _connections->_search[i]->vSearchResults[j]->status;
          
          std::string s_status;
          
          if(status & QueryHitEntry::Ready) s_status = "A";
          if(status & QueryHitEntry::Unknown) s_status = "C";
          if(status & QueryHitEntry::Firewalled) s_status = "B";
          if(status & QueryHitEntry::Busy) s_status = "D";
          
          std::strstream str;
          str << (999999-speed) << std::ends;
          
          std::string s(str.str());
          str.freeze(false);
          while(s.size() < 10) s.insert(0, "9");
          
          QString ret( (s_status+s).c_str() );
          return(ret + text(0).rightJustify(5, '0'));
        }
    }
  
  return text(column);
}
#endif
