#include "SearchWidget.h"
#include "QtellaSub.h"
#include <qlistview.h>

/* 
 *  Constructs a SearchWidget which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
SearchWidget::SearchWidget( QWidget* parent,  const char* name, WFlags fl )
    : BSearchWidget( parent, name, fl )
{
  this->parent = (QtellaSub*) parent;

  ui_listview_search->setColumnWidthMode(0, QListView::Maximum); // counter
  ui_listview_search->setColumnWidthMode(1, QListView::Maximum); // status
#ifndef SHARP
  ui_listview_search->setColumnWidthMode(2, QListView::Manual);  // filename
  ui_listview_search->setColumnWidth(2, this->parent->_search_column_size);
#else
  ui_listview_search->setColumnWidthMode(2, QListView::Maximum); // filename
#endif
  ui_listview_search->setColumnWidthMode(3, QListView::Maximum); // type
  ui_listview_search->setColumnWidthMode(4, QListView::Maximum); // size
  ui_listview_search->setColumnWidthMode(5, QListView::Maximum); // host
  ui_listview_search->setColumnWidthMode(6, QListView::Maximum); // vendor
  ui_listview_search->setColumnAlignment(0, AlignLeft);
  ui_listview_search->setColumnAlignment(1, AlignHCenter);
  ui_listview_search->setColumnAlignment(2, AlignLeft);
  ui_listview_search->setColumnAlignment(3, AlignRight);
  ui_listview_search->setColumnAlignment(4, AlignRight);
  ui_listview_search->setColumnAlignment(5, AlignRight);
  ui_listview_search->setColumnAlignment(6, AlignLeft);

  ui_listview_search->setShowSortIndicator(true);
  ui_listview_search->setSorting(2, true);        // sort filenames by default
  ui_listview_search->setRootIsDecorated(true);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SearchWidget::~SearchWidget()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void SearchWidget::slotDoubleClick(QListViewItem *item)
{
  doubleClicked(item);
}

void SearchWidget::slotRightButton(QListViewItem* item, const QPoint& p, int column)
{
  rightButton(item, p, column);
}
