#include "SHA1Storage.h"
#include "SharedFile.h"
#include "SharedViewItem.h"

#include <qdir.h>

SharedFile::SharedFile(SharedViewItem *item, std::string file, std::string directory, unsigned long size, int uploads, int requests)
{
  this->file = file;
  this->directory = directory;
  this->size = size;
  this->uploads = uploads;
  this->requests = requests;
  this->item = item;
  _sha1 = SHA1StorageInstance.get(this);
}


SharedFile::~SharedFile()
{
  delete item;
}


std::string SharedFile::completeFilename()
{
  std::string f = directory;
  
  if(f.size() > 0)
    if( f[f.size()-1] != '/' ) f += "/";

  f += file;
  
  return f;
}


bool SharedFile::renameFile(std::string newname)
{
  QDir d;

  if( d.rename( completeFilename().c_str(), (directory + "/" + newname).c_str() ) )
    {
      file = newname;
      item->setText(0, newname.c_str());
      return true;
    }

  return false;
}
