#include "Statistic.h"

#include <iomanip>

Statistic::Statistic()
  : in_ping_n(0), in_pong_n(0), in_query_n(0), in_hit_n(0), in_push_n(0),
    in_ping_b(0), in_pong_b(0), in_query_b(0), in_hit_b(0), in_push_b(0),
    out_ping_b(0), out_pong_b(0), out_query_b(0), out_hit_b(0), out_push_b(0),
    out_ping_n(0), out_pong_n(0), out_query_n(0), out_hit_n(0), out_push_n(0),
    hits_qtel_n(0), hits_lime_n(0), hits_bear_n(0), hits_othe_n(0),
    hits_gtkg_n(0), hits_gnot_n(0), hits_snut_n(0), hits_xolo_n(0),
    hits_gnuc_n(0), hits_mrph_n(0),
    loads_usucc(0), loads_uabor(0), loads_usize(0), loads_dsucc(0), loads_dabor(0), loads_dsize(0),
    shared_files(0), shared_size(0), _n_sha1_queries(0)
{
}


std::string Statistic::str(const double value, const int prec)
{
  double      v = value;
  std::string m;

  if(v > 1024) { v /= 1024; m = "K"; };
  if(v > 1024) { v /= 1024; m = "M"; };
  if(v > 1024) { v /= 1024; m = "G"; };
  if(v > 1024) { v /= 1024; m = "T"; };
  
  std::strstream str;

  str.setf(std::ios::fixed);
  str << std::setprecision(prec) << v << m << std::ends;

  std::string s = str.str();
  str.freeze(false);

  return s;
}


const unsigned long Statistic::in_all_n()
{
  return in_ping_n + in_pong_n + in_query_n + in_hit_n + in_push_n;
}


const double Statistic::in_all_b()
{
  return in_ping_b + in_pong_b + in_query_b + in_hit_b + in_push_b;
}

const unsigned long Statistic::out_all_n()
{
  return out_ping_n + out_pong_n + out_query_n + out_hit_n + out_push_n;
}


const double Statistic::out_all_b()
{
  return out_ping_b + out_pong_b + out_query_b + out_hit_b + out_push_b;
}


const unsigned long Statistic::hits_all_n()
{
  return hits_qtel_n + hits_lime_n + hits_bear_n + 
    hits_gtkg_n + hits_gnot_n + hits_snut_n + hits_xolo_n + hits_othe_n +
    hits_mrph_n + hits_gnuc_n;
}
