#include "StringManipulation.h"

#include <cctype>
#include <strstream>

StringManipulation::StringManipulation(const std::string& s)
{
  this->s.assign( s.data(), s.size() );
}

void StringManipulation::remove_comments(const char c)
{
  std::string::size_type  pos;

  pos = s.find_first_of(c);

  if(pos != std::string::npos)
    s.erase(pos);
}

void StringManipulation::split(std::string &sleft, std::string &sright, const char c)
{
  std::string::size_type  pos;

  pos = s.find_first_of(c);

  sleft.erase();
  sright.erase();

  if(pos!=std::string::npos)
    {
      sleft = this->s.substr(0, pos);
      sright = this->s.substr(pos+1);
    }
}

std::string StringManipulation::str()
{
  return s;
}

void StringManipulation::assign(const std::string& s)
{
  this->s = s;
}

void StringManipulation::remove_chars(const std::string& chars)
{
  std::string::iterator  iterator;

  for( unsigned i = 0; i < chars.size(); i++ )
    for(iterator=s.begin(); iterator!=s.end(); )
      if(*iterator==chars[i])
	iterator = s.erase(iterator);
      else
	++iterator;
}

void StringManipulation::split_to_vector(std::vector<std::string> &str, const char c)
{
  std::string             s = this->s;
  std::string::size_type  pos;

  while( (pos = s.find(c)) != std::string::npos )
    {
      if( ! s.substr( 0, pos ).empty() )
	str.push_back(s.substr(0, pos));
      s = s.substr(pos+1);
    }
  
  if(!s.empty()) str.push_back(s);
}

std::string StringManipulation::to_lower()
{
  for( unsigned i = 0; i < s.size(); ++i) s[i] = tolower(s[i]);
  return s;
}

std::string StringManipulation::insertDelimiter(const std::string& str, char delimiter, int pos)
{
  std::string s(str);
  std::string del;
  del += delimiter;
  int m = s.size();
  for(int j = 1; j <= (m-1)/pos; ++j) s.insert(m-pos*j, del);
  return s;
}

void StringManipulation::extractWords(std::vector<std::string>& v, unsigned length)
{
  std::string::size_type  idx;
  std::string             sub;
  std::string             f(s);

  while(!f.empty())
    {
      idx = f.find_first_of(" -,.()[]{}_");
      if(idx != std::string::npos) 
	{
	  sub = f.substr(0, idx);
	  f.erase(0, idx + 1);
	}
      else
	{
	  sub = f;
	  f.erase();
	}

      if(sub.size() >= length)
	{
	  for( unsigned j = 0; j < sub.size(); ++j) sub[j] = tolower(sub[j]);
	  v.push_back(sub);
	}
    }
}


const void StringManipulation::replace( const char c, const std::string& by )
{
  std::string::size_type idx;

  while( ( idx = s.find(c) ) != std::string::npos )
    s.replace( idx, 1, by );
}


const std::string StringManipulation::toString( const unsigned long l )
{
  std::strstream str;
  str << l << std::ends;
  std::string s( str.str() );
  str.freeze(false);
  return insertDelimiter( s, ',', 3 );
}
