#include "UploadManager.h"
#include "QtellaSub.h"
#include "Upload.h"
#include "Push.h"
#include "WidgetUploads.h"
#include "WidgetConfig.h"

#include "qhostaddress.h"
#include "qsocket.h"
#include "qstring.h"
#include "qspinbox.h"
#include "qlistview.h"
#include "qtimer.h"
#include "qlabel.h"
#include "qlistbox.h"

#include <strstream>
#include <iostream>
#include <iomanip>

UploadManager::UploadManager(QtellaSub *parent) 
  : _parent(parent)
{
  _timer = new QTimer(this);
  connect(_timer, SIGNAL(timeout()), SLOT(slotTimer()));
  _timer->start(1000);
}


UploadManager::~UploadManager()
{
  std::list<Upload*>::iterator pos = upload_list.begin();

  for( pos; pos != upload_list.end(); ++pos) delete *pos;
}


void UploadManager::slotTimer()
{
  std::list<Upload*>::iterator pos = upload_list.begin();
  double  bandwidth = 0;

  for(pos; pos != upload_list.end(); ++pos) 
    if((*pos)->getState() == Upload::Connected) bandwidth += (*pos)->readBandwidth();

#ifndef SHARP
  std::strstream str;
  str.setf(std::ios::fixed);
  str << std::setprecision(1) << static_cast<double>(bandwidth) << " KB/s" << std::ends;
  _parent->_widget_uploads->ui_textlabel_upbandwidth->setText(str.str());
  str.freeze(false);
#endif

  // remove busy uploads
  pos = upload_list.begin();

  while( pos != upload_list.end() )
    if( ((*pos)->getState() == Upload::Busy) || ((*pos)->getState() == Upload::NotFound) )
      {
	delete *pos;
	pos = upload_list.erase(pos);
      }
    else
      ++pos;
}


int UploadManager::numberUploads()
{
  int upload_counter = 0;
  std::list<Upload*>::iterator  pos = upload_list.begin();
  
  for( pos; pos != upload_list.end(); ++pos )
    if( ((*pos)->getState() == Upload::Connected) || ((*pos)->getState() == Upload::Connecting) )
      upload_counter++;
  
  return upload_counter;
}


const int UploadManager::numberUploadsFromHost( const std::string& ip )
{
  int upload_counter = 0;
  std::list<Upload*>::iterator  pos = upload_list.begin();
  
  for( pos; pos != upload_list.end(); ++pos )
    if( ( ( (*pos)->getState() == Upload::Connected ) || ( (*pos)->getState() == Upload::Connecting ) )
	&& ( (*pos)->getRemoteIP() == ip ) )
      upload_counter++;
  
  return upload_counter;  
}


void UploadManager::addPushUpload(Push p)
{
  upload_list.push_back(new Upload(this, p));
}


void UploadManager::addUpload(const std::string& data, QSocket* socket)
{
  upload_list.push_back(new Upload(this, data, socket));
}


void UploadManager::abortUpload()
{
  std::list<Upload*>::iterator  pos;

  for(pos = upload_list.begin(); pos != upload_list.end(); ++pos)
    if( _parent->_widget_uploads->ui_listview_uploads->isSelected( (*pos)->item ) )
      {
	(*pos)->abortUpload();
	break;
      }
}


void UploadManager::removeUpload()
{
  std::list<Upload*>::iterator  pos = upload_list.begin();

  while( pos != upload_list.end() )
    if( _parent->_widget_uploads->ui_listview_uploads->isSelected( (*pos)->item ) )
      {
	(*pos)->abortUpload();
	delete *pos;
	pos = upload_list.erase(pos);
      }
    else
      ++pos;
}


void UploadManager::removeInactiveUploads()
{
  std::list<Upload*>::iterator  pos = upload_list.begin();

  while( pos != upload_list.end() )
    if( ((*pos)->getState() != Upload::Start) && ((*pos)->getState() != Upload::Connected) )
      {
	delete *pos;
	pos = upload_list.erase(pos);
      }
    else
      ++pos;
}


void UploadManager::blockHost(QListBox* blockedlist)
{
  std::list<Upload*>::iterator  pos = upload_list.begin();

  while( pos != upload_list.end() )
    {
      if( _parent->_widget_uploads->ui_listview_uploads->isSelected( (*pos)->item ) )
        blockedlist->insertItem( ((*pos)->item)->text(2) );
      ++pos;
    }
}
