#ifdef SHARP
#include <qpe/qpeapplication.h>
#else
#include <qapplication.h>
#endif

#include <qnamespace.h>
#include <qtranslator.h>
#include <qtextcodec.h>

#include "QtellaSub.h"

#ifdef USEKDE
#include "kaboutdata.h"
#include "kuniqueapp.h"  /* system tray patch */
#include "kapp.h"
#include "kcmdlineargs.h"
#endif

#ifndef SHARP
#define UNIQUE_APP
#endif

#undef UNIQUE_APP

int main(int argc, char **argv)
{
#ifndef SHARP
#ifdef USEKDE
  KAboutData about("Qtella", "Qtella", VERSION);
  about.addAuthor( "Daniel Etzold", 0, "detzold@qtella.net" );

  KCmdLineArgs::init( argc, argv, &about);

#ifdef UNIQUE_APP
  KUniqueApplication::addCmdLineOptions();
  KUniqueApplication a;  // system tray patch
#else
  KApplication a;
#endif

  QTranslator* translator = new QTranslator( 0 );
  translator->load( QString("qtella_") + QTextCodec::locale(), LANG_DIR );
  a.installTranslator( translator );

  QtellaSub qtella(&a, argv[0]);
#endif
#endif

#ifdef QT
#ifdef SHARP
  QPEApplication a( argc, argv );
#else
  QApplication a(argc, argv);
#endif

  QTranslator* translator = new QTranslator( 0 );
  translator->load( QString("qtella_") + QTextCodec::locale(), LANG_DIR );
  a.installTranslator( translator );

#ifdef SHARP
  QtellaSub qtella(&a, argv[0], Qt::WStyle_Customize | Qt::WStyle_Maximize | Qt::WStyle_NoBorder | Qt::WStyle_Title);
#else
  QtellaSub qtella(&a, argv[0], Qt::WStyle_SysMenu | Qt::WStyle_MinMax);
#endif
#endif

  a.setMainWidget(&qtella);
  qtella.show();
  
  return a.exec();
}
