/*
 * $Id: collection.h,v 1.15 2000/08/24 15:05:25 tal197 Exp $
 *
 * The collection widget provides an area for displaying a collection of
 * objects (such as files). It allows the user to choose a selection of
 * them and provides signals to allow popping up menus, detecting double-clicks
 * etc.
 *
 * Thomas Leonard, <tal197@users.sourceforge.net>
 */


#ifndef __COLLECTION_H__
#define __COLLECTION_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define COLLECTION(obj) GTK_CHECK_CAST((obj), collection_get_type(), Collection)
#define COLLECTION_CLASS(klass) GTK_CHECK_CLASS_CAST((klass), \
					collection_get_type(), CollectionClass)
#define IS_COLLECTION(obj) GTK_CHECK_TYPE((obj), collection_get_type())

/* If the display gets mucked up then remember to fix it next time we get the
 * chance.
 */
enum
{
	PAINT_NORMAL,		/* Just redraw what we need to */
	PAINT_OVERWRITE,	/* Draw everything */
	PAINT_CLEAR,		/* Blank everything, then redraw */
};


typedef struct _Collection       Collection;
typedef struct _CollectionClass  CollectionClass;
typedef struct _CollectionItem   CollectionItem;
typedef void (*CollectionDrawFunc)(GtkWidget *widget,
			     	  CollectionItem *item,
			     	  GdkRectangle *area,
				  gpointer user_data);
typedef gboolean (*CollectionTestFunc)( Collection *collection,
					int point_x, int point_y,
			       		CollectionItem *item,
			       		int width, int height,
					gpointer user_data);

struct _CollectionItem
{
	gpointer	data;
	gboolean	selected;
};

struct _Collection
{
	GtkWidget 	parent_widget;

	GtkAdjustment	*vadj;
	guint		last_scroll;	/* Current/previous scroll value */

	CollectionDrawFunc draw_item;
	CollectionTestFunc test_point;
	gpointer	cb_user_data;	/* Passed to above two functions */
	int		paint_level;	/* Complete redraw on next paint? */
	GdkGC		*bg_gc;		/* NULL unless pixmap background */
	
	gboolean	lasso_box;	/* Is the box drawn? */
	int		drag_box_x[2];	/* Index 0 is the fixed corner */
	int		drag_box_y[2];
	GdkGC		*xor_gc;

	CollectionItem	*items;
	gint		cursor_item;		/* -1 if not shown */
	gint		cursor_item_old;	/* May be -1 */
	gint		wink_item;		/* -1 if not active */
	gint		wink_timeout;
	guint		columns;
	gint		number_of_items;	/* (often compared with -1) */
	guint		item_width, item_height;

	guint		number_selected;

	guint		array_size;

	gint		auto_scroll;	/* Timer */
};

struct _CollectionClass
{
	GtkWidgetClass 	parent_class;

	void 		(*gain_selection)(Collection 	*collection,
				     guint		time);
	void 		(*lose_selection)(Collection 	*collection,
				     guint		time);
};

guint   collection_get_type   		(void);
GtkWidget *collection_new          	(GtkAdjustment *vadj);
void    collection_clear           	(Collection *collection);
void	collection_clear_except		(Collection *collection, gint item);
gint    collection_insert          	(Collection *collection, gpointer data);
void    collection_remove          	(Collection *collection, gint item);
void    collection_unselect_item	(Collection *collection, gint item);
void    collection_select_item		(Collection *collection, gint item);
void 	collection_toggle_item		(Collection *collection, gint item);
void 	collection_select_all		(Collection *collection);
void 	collection_clear_selection	(Collection *collection);
void	collection_draw_item		(Collection *collection, gint item,
					 gboolean blank);
void 	collection_set_functions	(Collection *collection,
					 CollectionDrawFunc draw_item,
					 CollectionTestFunc test_point,
					 gpointer user_data);
void 	collection_set_item_size	(Collection *collection,
					 int width, int height);
void 	collection_qsort		(Collection *collection,
					 int (*compar)(const void *,
						       const void *));
int 	collection_find_item		(Collection *collection,
					 gpointer data,
					 int (*compar)(const void *,
						       const void *));
int 	collection_get_item		(Collection *collection, int x, int y);
void 	collection_set_cursor_item	(Collection *collection, gint item);
void 	collection_wink_item		(Collection *collection, gint item);
void 	collection_delete_if		(Collection *collection,
			  		 gboolean (*test)(gpointer item,
						          gpointer data),
			  		 gpointer data);
void 	collection_move_cursor		(Collection *collection,
					 int drow, int dcol);
void	collection_set_autoscroll	(Collection *collection,
					 gboolean auto_scroll);
void	collection_lasso_box		(Collection *collection, int x, int y);
void	collection_end_lasso		(Collection *collection,
					 GdkFunction fn);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __COLLECTION_H__ */
