.TH sane-find-scanner 1 "15 Sep 2002"
.IX sane-find-scanner
.SH NAME
sane-find-scanner - find SCSI and USB scanners and their device files
.SH SYNOPSIS
.B sane-find-scanner
.RB [\-h|\-?]
.RB [\-v]
.RB [\-q]
.RB [\-f]
.RI [devname]
.SH DESCRIPTION
.B sane-find-scanner
is a command-line tool to find SCSI and some USB scanners and determine their
Unix device files. It's part of the sane-backends package.
.PP
For 
.B SCSI
scanners, it checks the default generic SCSI device files (e.g., /dev/sg0) and
/dev/scanner. The test is done by sending a SCSI inquiry command and looking
for a device type of "scanner" or "processor" (some old HP scanners seem to
send "processor"). So sane-find-scanner will find any SCSI scanner connected
to those default device files even if it isn't supported by any SANE backend.
.PP
For
.B USB
scanners, first the USB kernel scanner device files (e.g. /dev/usb/scanner0),
/dev/usb/scanner, and /dev/usbscanner are tested. The files are opened and the
vendor and device ids are determined if the operating system supports this
feature. Currently USB scanners are only found this way if they are supported
by the Linux scanner module or the FreeBSD or OpenBSD uscanner driver. After
that test, sane-find-scanner tries to scan for USB devices found by the USB
library libusb (if available). There is no special USB class for scanners, so
the heuristics used to distinguish scanners from other USB devices is not
perfect. sane-find-scanner will even find USB scanners, that are not supported
by any SANE backend.
.PP
sane-find-scanner won't find parallel
port scanners, or scanners connected to proprietary ports.

.SH OPTIONS
.TP 8
.B \-h, \-?
Prints a short usage message.
.TP 8
.B \-v
Verbose output. If used once, sane-find-scanner shows every device name and
the test result.  If used twice, SCSI inquiry information and the USB device
descriptors are also printed.
.TP 8
.B \-q
Be quiet. Print only the devices, no comments.
.TP 8
.B \-f
Force opening all explicitely given devices as SCSI and USB devices. That's
useful if sane-find-scanner is wrong in determing the device type.
.TP 8
.B devname
Test device file "devname". No other devices are checked if devname is given.
.SH EXAMPLE
.B sane-find-scanner -v
.br
Check all SCSI and USB devices for available scanners and print a line for
every device file.
.PP
.B sane-find-scanner /dev/scanner
.br
Look for a (SCSI) scanner only at /dev/scanner and print the result.
.SH "SEE ALSO"
sane(7), sane-scsi(5), sane-usb(5), scanimage(1), xscanimage(1), xsane(1),
sane-"backendname"(5)
.SH AUTHOR
Oliver Rauch, Henning Meier-Geinitz and others
.SH SUPPORTED PLATFORMS
USB support is limited to Linux (kernel, libusb), FreeBSD (kernel,
libusb), NetBSD (libusb), OpenBSD (kernel, libusb). Detecting the vendor and
device ids only works with Linux or libusb.
.PP
SCSI support is available on Irix, EMX, Linux, Next, AIX, Solaris, FreeBSD,
NetBSD, OpenBSD, and HP-UX.

.SH BUGS
No support for parallel port scanners yet. 
