.TH sane-teco2 5 "19 March 2002"
.IX sane-teco2
.SH NAME
sane-teco2 - SANE backend for TECO / RELISYS scanners
.SH DESCRIPTION
The
.B sane-teco2
library implements a SANE (Scanner Access Now Easy) backend that
provides access to some TECO SCSI flatbed scanners. This backend
should be considered
.B alpha-quality
software! TECO scanners are sold under
various brands like Relisys, Piotech, TRUST. This backend may or
may not support yours.
.PP
The scanners that should work with this backend are:
.PP
.RS
   Vendor Model           TECO model       status
.br
----------------------  --------------  -----------
.br
  Relisys Scorpio Super 3  VM3575         tested
  Apollo Express 6         VM656A         tested
  Scorpio Pro-S            VM6586         tested

.RE

Note that the untested scanner will not be directly supported. You
should contact the author for that.

The TECO VM number can usually be found at the back of the
scanner. It is also part of the FCC ID. 

The options the backend supports can either be selected through
command line options to programs like scanimage or through GUI
elements in xscanimage or xsane.

.br
If you have any success with a scanner not listed here, or if you have
any strange behavior, please report to the backend maintainer or to
the SANE mailing list.

Valid command line options and their syntax can be listed by using 
.RS
scanimage --help -d teco2
.RE

.TP
.B Scan Mode

.TP
.B --mode
selects the basic mode of operation of the scanner valid choices are 
.I Black & White
,
.I Grayscale
and
.I Color
The Black & White mode is black and white only (1 bit). Grayscale
will produce 256 levels of gray (8 bits). Color will produce a 24 bits
color image.

.TP
.B --resolution
selects the resolution for a scan. The scanner can do all resolutions
between 1 and 600, in increments of 1.


.TP
.B Geometry options

.TP
.B -l -t -x -y 
control the scan area: -l sets the top left x coordinate, -t the top
left y coordinate, -x selects the width and -y the height of the scan
area. All parameters are specified in millimeters by default.


.TP
.B Enhancement options

.TP
.B --custom-gamma
(color mode only) allows the user to specify a gamma table (see the
next 3 parameters).

.TP 
.B --red-gamma-table 
(color mode only) can be used to download a user defined
gamma table for the red channel. The table must be 256 bytes long.

.TP 
.B --green-gamma-table 
(color mode only) can be used to download a user defined
gamma table for the green channel. The table must be 256 bytes long.

.TP
.B --blue-gamma-table 
(color mode only) can be used to download a user defined gamma table
for the blue channel. The table must be 256 bytes long.


.TP 
.B --preview
requests a preview scan. The resolution used for that scan is 22 dpi
and the scan area is the maximum allowed. The scan mode is user
selected. The default is "no".


.SH CONFIGURATION FILE
The configuration file @CONFIGDIR@/teco2.conf supports only one information: the device name to use (eg /dev/scanner).


.SH FILES
.TP
.I @LIBDIR@/libsane-teco2.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-teco2.so
The shared library implementing this backend (present on systems that
support dynamic loading).


.SH ENVIRONMENT
.TP
.B SANE_DEBUG_TECO2
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend. E.g.,
a value of 128 requests all debug output to be printed. Smaller levels
reduce verbosity.


.SH LIMITATIONS
The windows TWAIN driver has many more options than this SANE
backend. However they are only software adjustments. This backend only
implements what the scanner can support.


.SH BUGS

Plenty. Parts of this backend are still under development.


.SH "SEE ALSO"

sane\-scsi(5), scanimage(1), xscanimage(1), xsane(1), sane(7)


.SH AUTHOR

The package is actively maintained by Frank Zago.
    http://fz.eryx.net/sane/#teco2

.SH CREDITS

Thanks to:
.TP
Gerard Klaver for his relentless VM3575 testings.
.TP
Mark Plowman for providing the first SCSI traces from a VM3575.
.TP
Andreas Klaedtke for providing the first SCSI traces from a VM6586 and for his testing, and to Stefan von Dombrowski for his testing.
.TP
Nicolas Peyresaubes for providing the first SCSI traces from a VM656A and for his testing.
.TP
Dave Parker for testing the support for the VM6575.
