.TH sane-scsi 5 "15 Sep 2002"
.IX sane-usb
.SH NAME
sane-usb - USB configuration tips for SANE
.SH DESCRIPTION
This manual page contains information on how to access scanners
with a USB interface.
.SH GENERAL INFO
This manual page describes the access of USB scanners over the sanei_usb
interface. Most SANE USB backends use the sanei_usb interface, only sm3600
accesses the USB directly by libusb. Have a look at sane-sm3600 and section
"LIBUSB ACCESS TIPS" of this manual page for that backend.
.PP
Two methods for accessing USB devices are used by sanei_usb: direct access
using the kernel scanner driver and access over libusb. sanei_usb tries both
methods, if they are available. Currently USB access is tested for Linux
(kernel, libusb), FreeBSD (kernel, libsub), NetBSD (libusb), and OpenBSD
(kernel, libusb). Libusb access should also work on Mac OS X (Darwin) and any
other operating system supported by libusb but hasn't been tested yet. For
installation issues, also check the @DOCDIR@/README.platform files.
.PP
Most backends will detect USB scanners automatically using "usb" configuration
file lines. This method allows to identify scanners by the USB vendor and
product numbers.  The syntax for specifying a scanner this way is:
.PP
.RS
usb
.I VENDOR PRODUCT
.RE
.PP
where
.I VENDOR
is the USB vendor id, and
.I PRODUCT
is the USB product id of the scanner. Both ids are non-negative integer
numbers in decimal or hexadecimal format. The correct values for these fields
can be found by looking into the syslog (e.g., /var/log/messages) or under
Linux by issuing the command "cat /proc/bus/usb/devices/".  This is an example
of a config file line:
.PP
.RS
usb 0x055f 0x0006
.RE
.PP
would have the effect that all USB devices in the system with a vendor id of
0x55f and a product id of 0x0006 would be probed and recognized by the
backend. The same config line in decimal format looks like this:
.PP
.RS
usb 1375 6
.RE
.PP
If your scanner is not detected automatically, it may be necessary to edit the
appropriate backend configuration file before using SANE for the first time.
For most systems, the configuration file should list the name of the USB
device file that the scanner is connected to (e.g., under Linux,
.B /dev/usb/scanner0
or
.B /dev/usbscanner0
is such a USB device, the device file for FreeBSD is e.g.
.BR /dev/uscanner0 ).
If libusb is used, the device name looks like the following example:
.B libusb:001:002
.PP
Do
.I not
create a symlink from
.B /dev/scanner
to the USB device because this link is used by the SCSI backends. The scanner
may be confused if it receives SCSI commands. 
.PP
For a detailed description of each backend's configuration file, please refer
to the relevant backend manual page (e.g. sane-mustek_usb for Mustek USB
scanners).
.PP

.SH WHEN TO USE WHICH ACCESS METHOD
Generally speaking, if your scanner works with one method, there is no need
to switch to the other one.
.PP
Libusb is the more general approach and will be able to access any
scanner. Also, it supports more platforms. However, the library must be
available and installed on the system and setting permissions isn't easy at
least on Linux.
.PP
Autodetecting scanners and using USB control messages with the kernel access
method only works with recent (>=v2.4.12) Linux kernels. If you need one of
these two features on a different platform, use libusb instead.

.SH KERNEL SCANNER DRIVER TIPS
Ensure that the access permissions for the USB device are set appropriately.
We recommend to add a group "scanner" to /etc/group which contains all users
that should have access to the scanner.  The permission of the device should
then be set to allow group read and write access.  For example, if the scanner
is at USB device
.BR /dev/usb/scanner0 ,
then the following two commands would set the permission correctly:
.PP
.RS
$ chgrp scanner /dev/usb/scanner0
.br
$ chmod 660 /dev/usb/scanner0
.RE
.PP
If your scanner isn't detected automatically by your operating system's
scanner driver, you need to tell the kernel the vendor and product ids of your
scanner. For 
.BR Linux ,
this can be done with modprobe parameters: First, remove the scanner module
(rmmod scanner), then load it again: modprobe scanner vendor=0x0001
product=0x0002. Use the appropriate vendor and product ids (e.g. from syslog
or cat /proc/bus/usb/devices). For OpenBSD the kernel must be recompiled. For
details look at @DOCDIR@/README.openbsd. Similar approaches should be used for
the other BSDs.
.PP
Linux kernel messages in syslog like "kernel: scanner.c: open_scanner(1):
Unable to access minor data" can be ignored. They are generated when SANE
scans all available USB devices for scanners.
.SH LIBUSB ACCESS TIPS
Libusb can only access your scanner if it's not claimed by the kernel scanner
driver. If you want to use libusb, unload the kernel driver (e.g. rmmod
scanner under Linux) or disable the driver when compiling a new kernel. For
Linux, your kernel needs support for the USB filesystem (usbfs) and that
filesystem must be mounted. That's done automatically, if /etc/fstab contains
a line like this:
.PP
.RS
none /proc/bus/usb usbfs defaults  0  0
.RE
.PP
The permissions for the device files used by libusb must be adjusted for user
access. Otherwise only root can use SANE devices. For
.IR Linux ,
the devices are located in /proc/bus/usb/. There are directories named
e.g. "001" (the bus name) containing files "001", "002" etc. (the device
files). The right device files can be found out by running scanimage -L as
root. Setting permissions with "chmod" is not permanent, however. They will be
resetted after reboot or replugging the scanner. It's also possible to mount
the usbfs with the option "devmode=0666", e.g. by using the following line in
/etc/fstab:
.PP
.RS
none /proc/bus/usb usbfs defaults,devmode=0666  0  0
.RE
.PP
However, this way everyone has access to all USB devices. Another way to set
permissions is to use the hotplug utilities
(http://linux-hotplug.sourceforge.net/), which support dynamic setting of
access permissions. Last, the frontends can be run as root. However, that's
not recommended for security reasons.
.PP
For the
.IR BSDs ,
the device files are named /dev/ugen*. Use chmod to apply appropriate
permissions.

.SH ENVIRONMENT
.TP
.B SANE_DEBUG_SANEI_USB
If the library was compiled with debug support enabled, this
environment variable controls the debug level for the USB I/O
subsystem.  E.g., a value of 128 requests all debug output to be
printed.  Smaller levels reduce verbosity. Values greater than 4 enable
libusb debugging (if available).
.SH "SEE ALSO"
sane(7), sane\-find\-scanner(1), sane\-"backendname"(5), sane-scsi(5)
.SH AUTHOR
Henning Meier-Geinitz. Some parts were copied from the sane-scsi manual page.
