.TH sane-mustek_pp 5 "22 June 2000"
.IX sane-mustek_pp
.SH NAME
sane-mustek_pp - SANE backend for Mustek parallel port flatbed scanners
.SH DESCRIPTION
The
.B sane-mustek_pp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Mustek parallel port flatbed scanners.  The
following scanners might work with this backend:
.PP
.RS
Model:           ASIC ID:  CCD Type:  works:
.br
---------------- --------- ---------- -------
.br
SE 6000 P        1013      00          yes
.br
SM 4800 P        1013      04          yes
.br
SE 1200 ED Plus  1015      01          no
.br
SM 1200 ED Plus  1015      01          no
.br
SE 12000 P       1505      05          no
.br
SE 600 CP        1015      00          no
.br
SM 600 CP        1015      00          no
.br
600 III EP Plus  1013/1015 00/01       yes
.br
SE 600 SEP       1013      ??          yes
.br
600 II EP        ????      ??          no
.br
MD9848           1015      00          yes
.RE
.PP
Please note that this backend is still under construction. I don't know
which scanners work or which will work in future releases.
.PP
Some scanners work faster when 
.B EPP/ECP
is enabled in the BIOS.
.PP
Note that the backend needs to run as root. To allow user access to the scanner
run the backend through the network interface. Note also that the backend
.I does not
support
.I parport sharing ,
i.e. if you try printing while scanning, your computer may crash. This backend
also conflicts with the
.I sane\-musteka4s2
backend. You can only enable one of them in your dll.conf.

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I port addr
.RE
.PP
Where
.B addr
is the base address of the port your scanner is attached to. Known ports are
.B 0x378
(lp1)
.B 0x278
(lp2) and
.B 0x3C8
(lp0). Note that if you are using a Kernel 2.2.x or better and you have only one
parallel port this port is named lp0 regardless of the base address. However,
this backend requires the base address of your port.
You can rename any device using the
.PP
.RS
.I name devname
.br
.I model model
.br
.I vendor vendor
.RE
.PP
options. These options aply to the last port option.

.SH CONFIGURATION
Please make sure to edit mustek_pp.conf
.B before
you use the backend.
.PP
The contents of the
.B mustek_pp.conf
file is a list of options and device names that correspond to Mustek
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.
.PP
The seven options supported are
.BR io\-mode ,
.BR wait\-bank ,
.BR strip\-height ,
.BR niceload ,
.BR auth ,
.BR wait-lamp ,
and
.BR buffer .

Option
.B io-mode
defines the mode of the sanei_pa4s2 interface. Possible values are
.BR try_mode_uni
and
.BR alt_lock .
This option may appear for each possible value. try_mode_uni allows
the UNI port mode, however this may disable the (better) EPP mode. alt_lock
toggles between two different ways to lock the port for scanner access.
This option must come before any port definition or it won't have the effect
you'd expect.

Option
.B wait-bank
defines the maximal time in msecs the backend waits for the bank to change. The
default value is 700. If this option is given after the port option, only this
device is affected. If this value is to low, you will get wrong colors and
stripes in the scanned image.

Option
.B strip-height
is a option that limits the maximum height of the strip scanned with
a single read command.  The height is specified in lines. If this option is
given after the port option, only this device is affected. A strip\-height of
zero allows to scan as much as fits into the scan buffer.

Option
.B niceload
tries to avoid to heavy load. Note that this reduces scan speed. This is a
global option.

Option
.B auth
turns on user authentification for this scanner. Use this if you want access
control and if you have enabled this at compile time. This option must come
after a port option.

Option
.B wait-lamp
allows you to control the time the backend waits for the lamp to warm up. The
time is specified in secs. The default value is 5 secs. Some scanners need
longer to warm up. A value of 0 makes the backend start without waiting. 
However the backend will wait at least 2 secs before turning the lamp off
again. If this option is given after a port option it affects only this
device.

Option
.B buffer
allows you to change the size of the scan buffer. The size must be specified in
bytes. The default value is 1 megabyte. If this opttion is given after the port
option, only this device is affected. If you have limited the strip\-height,
you only need a scan buffer of
.PP
.RS
.B 8.5 * dpi * 3 * strip\-height bytes.
.RE
.PP

.PP
A sample configuration file is shown below:
.PP
.RS
# GLOBAL #
.br

.br
# enable this option, if you think your scanner
.br
# supports the UNI protocol
.br
# note however that this might disable the better
.br
# EPP protocol
.br
#option io-mode try_mode_uni
.br

.br
# choose between two different ways to lock to port
.br
option io-mode alt_lock
.br

.br
# set the maximal height (in lines) of a strip
.br
# scanned (default: no limit)
.br
#option strip-height 0
.br

.br
# wait n msecs for bank to change (default: 700
.br
# msecs) if this value is to low, stripes my appear
.br
# in the scanned image
.br
#option wait-bank 700
.br

.br
# size (in bytes) of scan buffer (default: 
.br
# 1 megabyte)
.br
#option buffer 1048576
.br

.br
# try to avoid to heavy load. Note that this
.br
# reduces scan speed
.br
option niceload
.br

.br
# Define the time the lamp has to be on before
.br
# scan starts (default 5 secs)
.br
#option wait-lamp 5
.br

.br

.br
# DEVICES #
.br

.br
# specify the port your scanner is connected to.
.br
# Possible are 0x378 (lp1) 0x278 (lp2) and 
.br
# 0x3c8 (lp0)
.br
port 0x378
.br

.br
# the following options are local to this scanner
.br

.br
 # scan maximal 16 lines for one sane_read() call
.br
 option strip-height 16
.br

.br
 # we just need 16 * 3 * 300 * 8.5 bytes
.br
 option buffer 122400
.br

.br
 # this scanner needs max 250 msecs to change 
.br
 # the bank
.br
 option wait-bank 250
.br

.br
 # My scanner is a MD9848 from Medion using the
.br
 # Mustek chipset
.br
 name MD9848
.br
 vendor Medion
.br

.br
 # Enable this option, if you want user
.br
 # authentification *and* if it's enabled at
.br
 # compile time
.br
 #option auth
.br

.br
 # Some scanners (especially ASIC 1013) need
.br
 # longer to warm up. This option specifies
.br
 # the time to wait for the lamp to get hot
.br
 #option wait-lamp 15
.br

.RE

.SH FILES
.TP
.I @CONFIGDIR@/mustek_pp.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-mustek_pp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-mustek_pp.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_MUSTEK_PP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.PP
.RS
level   debug output
.br
------- ------------------------------
.br
 0       nothing
.br
 1       errors
.br
 2       warnings & minor errors
.br
 3       additional information
.br
 4       debug information
.br
 5       code flow (not supported yet)
.br
 6       special debug information
.RE
.PP
 
.PP
.SH "SEE ALSO"
sane\-musteka4s2(5), sane\-mustek(5)
.TP
For latest bug fixes and information see
.I http://home.germany.net/freestyle/sane/

.SH AUTHOR
Jochen Eisinger <jochen.eisinger@gmx.net>

.SH ACKNOWLEDGEMENTS
Jeff DeFouw for his musteka4s2 backend
.br
Henning Meier-Geinitz for his help
.SH BUGS
Too many... please send bug reports to 
.I sane\-devel@mostang.com
.PP
.RS
* 1013 support isn't bullet proofed
.br
* 1505 support isn't even present
.br
* 1015 only works for CCD type 0
.RE
.
