/* copyright (C) 2001 Sun Microsystems, Inc.*/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SCROLLKEEPER_H
#define SCROLLKEEPER_H

#include <libxml/tree.h>

#define _(String) gettext (String)

#define SCROLLKEEPERLOCALEDIR "/usr/share/locale"

#define PATHLEN		256

extern void sk_warning(int, char *, ...);
extern void check_ptr(void *, char *);
extern char **sk_get_language_list(void);
extern int is_file(char *);
extern int is_dir(char *);
extern int apply_stylesheets(char *, char *, int, char **, char **);
extern int copy_file(char *, char *);
extern int install(char *, char *, char *, int);
extern void create_database_directory(char *, char *);
extern void uninstall(char *, char *, int);
extern xmlDocPtr merge_locale_trees(char *, char *, char *);
extern int update_doc_url_in_omf_file(char *, char *, char *);

#endif /* SCROLLKEEPER_H */
