#!/usr/bin/tcl

#############################################################
# SecPanel - ListServer
# Service for remote file selection and scp
# Version 0.1 (SecPanel 0.30)
# Author: Steffen Leich <leich@wiwi.uni-marburg.de>
#############################################################

global clientpass, authenticated, busy;

# gets set with each listserver-launch
set clientpass <PASS-XXXXX>

set authenticated 0
set busy 0

proc scpAuth {sock} {
    global pass clientpass authenticated

    if {! $authenticated} {
	gets $sock passandport
	
	set serverpass [lindex [split $passandport] 1]
	if {$serverpass != $clientpass} {
	    puts "Wrong authentication from ListClient (SecPanel)\nHad to reject connection"
	    close $sock
	    return
	} else {
	    set authenticated 1
	    puts "SecPanel sent good authentication.\nNow serving..."
	    GiveList $sock
	}
    } else {
	GiveList $sock
    }
}

proc Accept {sock addr port} {
    global main busy
    puts "Connection from $addr on port $port"

    if {! $busy} {
	fconfigure $sock -buffering line
	fileevent $sock readable "scpAuth $sock"
	set busy 1
    } else {
	puts "*** SECOND CONNECTION FROM $addr:$port - HAD TO REJECT CONNECTION! ***"
	close $sock
    }	
}

proc GiveList {sock} {
    global main env
    if {[eof $sock] || [catch {gets $sock input}]} {
	close $sock
	puts "closed connection to $sock"
    } else {
	set dir [lindex [split $input \t] 0]
	set hmode [lindex [split $input \t] 1]

	if {$dir == "++InitListing"} {
	    if [info exists env(HOME)] {
		set dir $env(HOME)
	    } else {
		set dir "/"
	    }
	}
	if {$dir == "++CloseYourSelf"} {
	    close $sock
	    close $main
	    puts "SecPanel ListServer exiting"
	    exit
	}
	
	if $hmode {
	    set gpat "glob -nocomplain \"$dir/.*\" \"$dir/*\""
	} else {
	    set gpat "glob -nocomplain \"$dir/*\""
	}
	
	# Checking rights and existance...

	puts $sock "+++++$dir"
	foreach f [lsort [eval $gpat]] {
	    if {[file tail "$f"] == ".." || [file tail "$f"] == "."} {
		continue
	    }
	    if [file isdirectory "$f"] {
		puts $sock "++ $f"
	    } else {
		puts $sock "$f"
	    }
	}
	puts $sock "+++++"
    }
}

set main [socket -server Accept -myaddr 127.0.0.1 9920]
puts "SecPanel ListServer waiting for connections..."

# Tell SecPanel that we are prepared to send filelistings
set callbacksocket [socket localhost 9910]
fconfigure $callbacksocket -buffering line
puts $callbacksocket "opengui $clientpass"
puts "Sent CallBack to SecPanel"
close $callbacksocket

vwait forever

