/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2002  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <gtk/gtk.h>
#include <stdlib.h>

#include "misc.h"
#include "miscui.h"
#include "options.h"
#include "callbacks.h"
#include "cmdl.h"
#include "searchwm.h"

gint main (gint argc, gchar *argv[]) {
	config selectwm_config;
	GtkWidget *button;

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
#endif
	gtk_init (&argc, &argv);

	selectwm_config.SaveOnExit = TRUE;
	selectwm_config.ConfigFile = g_string_new ("");
	g_string_printf (selectwm_config.ConfigFile, "%s/.selectwmrc", getenv ("HOME"));

	get_cmdl_opt (argc, argv, &selectwm_config);
	
	button = make_main_window (&selectwm_config);

	if (0 == read_config (&selectwm_config)) {
		switch (askbox (_("There isn't any window manager configured !\nShould I search for known ones ?\n\nYou can also edit the list by right clicking on it."))) {
			case GTK_RESPONSE_YES:
				find_wm (&selectwm_config);
				break;
			default:
				break;
		}
	} else {
		if (selectwm_config.delay > 0.05) {
			selectwm_config.elapsed_delay = selectwm_config.delay;
			selectwm_config.timer = gtk_timeout_add (100, timerfnc, &selectwm_config);
		}
	}

	if (selectwm_config.restart_selectwm) gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	gtk_widget_show (selectwm_config.window);

	gtk_main ();
	g_string_free (selectwm_config.ConfigFile, TRUE);
	return 0;
}
