#!/bin/sh
#
# The purpose of this script is a customization
# of specially compiled html source, used for
# the creation of WinHelp documentation
# Author: Viktor Levandovskyy, 30/01/2002
#
####################################################

# Run only once!
# It should be started from htmlwin/ directory
# if no other specified


# We assume there are index.htm, sing_[abt,ovr,toc].htm,
# and sing_[1..896].htm. There are also pics (gif, jpg).

#####################################################################
# In order to have good-looking Contents,                           #
# we have to remove extra "Singular Manual:" substring in the title #
# in all files                                                      #
#####################################################################

    echo -n "processing $1: "
    sed 's/Singular Manual: //g' <$1 >./xx 
    mv ./xx $1
    echo -n "title, "

###################################################################
# Extra navigation: remove the top panel, leave only the bottom.  #
################################################################### 

    touch ./xx ./yy ./begin ./end ./hrsize

# first appearance of <TABLE
    egrep -h -n -s -e "<TABLE" <$1  >./xx
    cut -d: -f1 <./xx >./yy
    head -1 <./yy >./begin

# first appearance of </TABLE>
    egrep -h -n -s -e "</TABLE>" <$1  >./xx
    cut -d: -f1 <./xx >./yy
    head -1 <./yy >./end

# first appearance of <HR SIZE=1> (horisontal line)
    egrep -h -n -s -e "<HR SIZE=1>" <$1  >./xx
    cut -d: -f1 <./xx >./yy
    head -1 <./yy >./hrsize

# action
    sed -e `cat ./begin`,`cat ./end`d -e `cat ./hrsize`d <$1 >./xx
    mv ./xx $1
    echo -n "navigation("`cat ./begin`,`cat ./end`"), "
    rm ./yy ./begin ./end ./hrsize


#########################################################################
# in all "Index" and one "pause" pages, replace symbols which           #
# are wrongly treated (< and >)                                         #
#########################################################################

    touch ./xx

    if egrep -e "<TITLE>".*"Index" <$1  > /dev/null
    then
	sed -e 's/cp\_<\"/cp\_\"\&\#60\;/g' -e 's/cp\_>\"/cp\_\"\&\#62;/g' -e 's/<b>><\/b>/\<b\>\&\#62\;\<\/b\>/g' -e 's/<b><<\/b>/<b>\&\#60\;<\/b>/g' <$1 >./xx
	cp ./xx $1
	echo -n "index page, "
	if egrep -e "<</TH" <$1 > /dev/null
	then
	    sed -e 's/<</\&\#60\;</g' <$1 >./xx
	    cp ./xx $1
	    echo -n "< page,"
	fi
    fi

    if egrep -e "<TITLE>".*"pause" <$1  > /dev/null
    then
	sed -e 's/<return>/\&\#60\;return\&\#62\;/g' <$1 >./xx 
	cp ./xx $1
	echo -n "pause page, "
    fi    
    rm ./xx

    echo "finished."

# That's all, folks
