dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

AC_DEFUN(GST_REVISION, [

VERSION=[`echo '$1'|sed 's/$[^0-9.]*//g'`]
VERSION_INFO=$2

AC_SUBST(VERSION_INFO)

# Split the version number
[
  ST_MAJOR_VERSION=`echo $VERSION| sed "s%\\..*%%g"`
  if test `echo $VERSION| sed "s%[^.]%%g"` = ".."; then
    ST_MINOR_VERSION=`echo $VERSION| sed "s%.*\\.\\(.*\\)\\..*%\\1%g"`
    ST_EDIT_VERSION=`echo $VERSION| sed "s%.*\\.%%g"`
  else
    ST_MINOR_VERSION=`echo $VERSION| sed "s%.*\\.%%g"`
    ST_EDIT_VERSION=0
  fi
]

AC_DEFINE_UNQUOTED(VERSION_INFO, "$VERSION_INFO",
                   [Version of the GNU Smalltalk interface library])
AC_DEFINE_UNQUOTED(ST_MAJOR_VERSION, $ST_MAJOR_VERSION,
                   [Major version of GNU Smalltalk])
AC_DEFINE_UNQUOTED(ST_VERSION_INFO, $ST_VERSION_INFO,
                   [Version of the GNU Smalltalk interface library])
AC_DEFINE_UNQUOTED(ST_MINOR_VERSION, $ST_MINOR_VERSION,
                   [Minor version of GNU Smalltalk])
AC_DEFINE_UNQUOTED(ST_EDIT_VERSION, $ST_EDIT_VERSION,
                   [Patch level version of GNU Smalltalk])
AC_DEFINE_UNQUOTED(MAINTAINER, "$MAINTAINER",
                   [E-Mail address of the person maintaining this package])
])
# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

dnl Calls several commonly used macros; also provides support for
dnl selectively enabling or disabling some GCC optimizations
dnl
AC_DEFUN(GST_PROG_CC, [
AC_REQUIRE([AC_PROG_CC])
AC_REQUIRE([AC_PROG_CPP])
AC_REQUIRE([AC_PROG_GCC_TRADITIONAL])
AC_REQUIRE([AC_AIX])
AC_REQUIRE([AC_ISC_POSIX])

ifelse([$1$2], , , [dnl
if test "$GCC" = yes; then
  gcc_help="`$CC -v --help 2>&1`"
  case "$gcc_help" in
    *peephole*) ;;
    *) gcc_help="-ffloat-store -fdefault-inline -fdefer-pop -fforce-mem \
	-fforce-addr -fomit-frame-pointer -finline -finline-functions \
	-fkeep-inline-functions -ffunction-cse -ffast-math \
	-fstrength-reduce -fthread-jumps -fcse-follow-jumps \
	-fcse-skip-blocks -frerun-cse-after-loop -fexpensive-optimizations \
	-fdelayed-branch -fschedule-insns -fschedule-insns2 \
	-fcaller-saves -funroll-loops -funroll-all-loops -fpeephole "
  esac

  ifelse([$1], , , [
    for i in $1; do
      case "$gcc_help" in
        *-f$i*) CFLAGS="$CFLAGS -f$i" ;;
        *)	;;
      esac
    done
  ])dnl
  ifelse([$2], , , [
    for i in $2; do
      case "$gcc_help" in
        *-f$i*) CFLAGS="$CFLAGS -fno-$i" ;;
        *)	;;
      esac
    done
  ])dnl
fi
])dnl
])dnl


# serial 1

AC_DEFUN(AM_PATH_LISPDIR,
 [# If set to t, that means we are running in a shell under Emacs.
  # If you have an Emacs named "t", then use the full path.
  test "$EMACS" = t && EMACS=
  AC_PATH_PROGS(EMACS, emacs xemacs, no)
  if test $EMACS != "no"; then
    AC_MSG_CHECKING([where .elc files should go])
    dnl Set default value
    lispdir="\$(datadir)/emacs/site-lisp"
    emacs_flavor=`echo "$EMACS" | sed -e 's,^.*/,,'`
    if test "x$prefix" = "xNONE"; then
      if test -d $ac_default_prefix/share/$emacs_flavor/site-lisp; then
	lispdir="\$(prefix)/share/$emacs_flavor/site-lisp"
      else
	if test -d $ac_default_prefix/lib/$emacs_flavor/site-lisp; then
	  lispdir="\$(prefix)/lib/$emacs_flavor/site-lisp"
	fi
      fi
    else
      if test -d $prefix/share/$emacs_flavor/site-lisp; then
	lispdir="\$(prefix)/share/$emacs_flavor/site-lisp"
      else
	if test -d $prefix/lib/$emacs_flavor/site-lisp; then
	  lispdir="\$(prefix)/lib/$emacs_flavor/site-lisp"
	fi
      fi
    fi
    AC_MSG_RESULT($lispdir)
  fi
  AC_SUBST(lispdir)])


# serial 40 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" \
LN_S="$LN_S" NM="$NM" RANLIB="$RANLIB" \
DLLTOOL="$DLLTOOL" AS="$AS" OBJDUMP="$OBJDUMP" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $lt_target \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

case "$target" in
NONE) lt_target="$host" ;;
*) lt_target="$target" ;;
esac

# Check for any special flags to pass to ltconfig.
#
# the following will cause an existing older ltconfig to fail, so
# we ignore this at the expense of the cache file... Checking this 
# will just take longer ... bummer!
#libtool_flags="--cache-file=$cache_file"
#
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
ifdef([AC_PROVIDE_AC_LIBTOOL_DLOPEN],
[libtool_flags="$libtool_flags --enable-dlopen"])
ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[libtool_flags="$libtool_flags --enable-win32-dll"])
AC_ARG_ENABLE(libtool-lock,
  [  --disable-libtool-lock  avoid locking (might break parallel builds)])
test "x$enable_libtool_lock" = xno && libtool_flags="$libtool_flags --disable-lock"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$lt_target" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[*-*-cygwin* | *-*-mingw*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  AC_CHECK_TOOL(OBJDUMP, objdump, false)
  ;;
])
esac
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])])

# AC_LIBTOOL_WIN32_DLL - declare package support for building win32 dll's
AC_DEFUN(AC_LIBTOOL_WIN32_DLL, [AC_BEFORE([$0], [AC_LIBTOOL_SETUP])])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED, [dnl
define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC, [dnl
define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL, [dnl
define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_FAST_INSTALL(no)])

# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$lt_target" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library and INCLTDL to the include flags for
# the libltdl header and adds --enable-ltdl-convenience to the
# configure arguments.  Note that LIBLTDL and INCLTDL are not
# AC_SUBSTed, nor is AC_CONFIG_SUBDIRS called.  If DIR is not
# provided, it is assumed to be `libltdl'.  LIBLTDL will be prefixed
# with '${top_builddir}/' and INCLTDL will be prefixed with
# '${top_srcdir}/' (note the single quotes!).  If your package is not
# flat and you're not using automake, define top_builddir and
# top_srcdir appropriately in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL='${top_builddir}/'ifelse($#,1,[$1],['libltdl'])/libltdlc.la
  INCLTDL='-I${top_srcdir}/'ifelse($#,1,[$1],['libltdl'])
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library and INCLTDL to the include flags for
# the libltdl header and adds --enable-ltdl-install to the configure
# arguments.  Note that LIBLTDL and INCLTDL are not AC_SUBSTed, nor is
# AC_CONFIG_SUBDIRS called.  If DIR is not provided and an installed
# libltdl is not found, it is assumed to be `libltdl'.  LIBLTDL will
# be prefixed with '${top_builddir}/' and INCLTDL will be prefixed
# with '${top_srcdir}/' (note the single quotes!).  If your package is
# not flat and you're not using automake, define top_builddir and
# top_srcdir appropriately in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL='${top_builddir}/'ifelse($#,1,[$1],['libltdl'])/libltdl.la
    INCLTDL='-I${top_srcdir}/'ifelse($#,1,[$1],['libltdl'])
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
    INCLTDL=
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

dnl This is just to silence aclocal about the macro not being used
ifelse([AC_DISABLE_FAST_INSTALL])dnl

AC_DEFUN(GST_C_SIGNED, [

AC_CACHE_CHECK(for signed, gst_cv_c_signed,
[AC_TRY_COMPILE(, [signed int x; ],
    gst_cv_c_signed=yes, gst_cv_c_signed=no)
])
test $gst_cv_c_signed = no && \
  AC_DEFINE_UNQUOTED(signed, ,
                [Define as empty if the C compiler doesn't support it.])

])dnl

AC_DEFUN(GST_C_GOTO_VOID_P, [

AC_CACHE_CHECK(for goto void *, gst_cv_c_goto_void_p,
[AC_TRY_COMPILE(, [
    void *x = &&label;
    goto *x;
    label: ],
    gst_cv_c_goto_void_p=yes, gst_cv_c_goto_void_p=no)
])
test $gst_cv_c_goto_void_p = yes && \
  AC_DEFINE(HAVE_GOTO_VOID_P, 1, [Define if your CC has the '&&' and 'goto void *' GCC extensions.])

])dnl

AC_DEFUN(GST_C_OLDCC, [

AC_CACHE_CHECK(for old ANSI CC (no void *), gst_cv_c_oldcc,
[AC_TRY_COMPILE(, [void *x; ],
    gst_cv_c_oldcc=no, gst_cv_c_oldcc=yes)
])

test $gst_cv_c_oldcc = yes && \
  AC_DEFINE(OLDCC, 1, Define if the C compiler doesn't support void *)

])dnl

AC_DEFUN(GST_C_SYMBOLSET, [

# This test outputs the list of symbols which /bin/cc or /lib/cpp
# define and which we had the foresight to guess at.  When
# cross-compiling, we only consider /lib/cpp.
AC_CACHE_CHECK(builtin preprocessor symbol set, gst_cv_machine_defines,
[   syms="AMIX BIT_MSF BSD BSD4_3 BSD_NET2 CMU CRAY DGUX DOLPHIN DPX2 \
	GO32 GOULD_PN HP700 I386 I80960 I960 Lynx M68000 M68K MACH \
	MIPSEB MIPSEL MSDOS MTXINU MULTIMAX MVS \
	M_COFF M_I186 M_I286 M_I386 M_I8086 M_I86 M_I86SM \
	M_SYS3 M_SYS5 M_SYSIII M_SYSV M_UNIX M_XENIX \
	NeXT OCS88 OSF1 PARISC PC532 PORTAR POSIX \
	PWB R3000 RES RISC6000 RT Sun386i SVR3 SVR4 \
	SYSTYPE_BSD SYSTYPE_SVR4 SYSTYPE_SYSV Tek4132 Tek4300 \
	UMAXV USGr4 USGr4_2 UTEK UTS UTek UnicomPBB UnicomPBD Utek \
	VMS WIN32 Xenix286 \
	_AIX _AIX32 _AIX370 _AM29000 _COFF _CRAY _CX_UX _EPI \
	_IBMESA _IBMR2 _M88K _M88KBCS_TARGET \
	_MIPSEB _MIPSEL _M_COFF _M_I86 _M_I86SM _M_SYS3 \
	_M_SYS5 _M_SYSIII _M_SYSV _M_UNIX _M_XENIX _NLS _PGC_ _R3000 \
	_SYSTYPE_BSD _SYSTYPE_BSD43 _SYSTYPE_SVR4 \
	_SYSTYPE_SYSV _SYSV3 _U370 _UNICOS \
	__386BSD__ __BIG_ENDIAN __BIG_ENDIAN__ __BSD_4_4__ \
	__CYGWIN__ __CYGWIN32__ __DGUX__ __DPX2__ __H3050R __H3050RX \
	__LITTLE_ENDIAN __LITTLE_ENDIAN__ __MACH__ _MSC_VER \
	__MIPSEB __MIPSEB__ __MIPSEL __MIPSEL__ \
	__Next__ __OS2__ __OSF1__ __PARAGON__ __PGC__ __PWB __STDC__ \
	__SVR4_2__ __UMAXV__ __WIN32__ _WIN32 \
	____386BSD____ __alpha __alpha__ __amiga \
	__bsd4_2 __bsd4_2__ __bsdi__ __convex__ \
	__host_mips__ \
	__hp9000s200 __hp9000s300 __hp9000s400 __hp9000s500 \
	__hp9000s500 __hp9000s700 __hp9000s800 \
	__hppa __hpux __hp_osf __ia64 __ia64__ __i386 __i386__ \
	__i486 __i486__ __i860 __i860__ __ibmesa __ksr1__ __linux__ \
	__m68k __m68k__ __m88100__ __m88k __m88k__ \
	__mc68000 __mc68000__ __mc68020 __mc68020__ \
	__mc68030 __mc68030__ __mc68040 __mc68040__ \
	__mc88100 __mc88100__ __mips __mips__ \
	__motorola__ __osf__ __pa_risc __sparc__ __stdc__ \
	__sun __sun__ __svr3__ __svr4__ __ultrix __ultrix__ \
	__unix __unix__ __uxpm__ __uxps__ __vax __vax__ \
	_host_mips _mips _unix \
	a29k aegis aix aixpc alliant alpha am29000 amiga \
	ansi ardent apollo ardent att386 att3b \
	bsd bsd43 bsd4_2 bsd4_3 bsd4_4 bsdi bull \
	cadmus clipper concurrent convex cray ctix \
	dmert encore gcos gcx gimpel gould \
	hbullx20 hcx host_mips hp200 hp300 hp700 hp800 \
	hp9000 hp9000s300 hp9000s400 hp9000s500 \
	hp9000s700 hp9000s800 hp9k8 hppa hpux \
	ia64 i386 i486 i80960 i860 iAPX286 ibm \
	ibm032 ibmrt interdata is68k \
	ksr1 linux luna luna88k m68k m88100 m88k \
	mc300 mc500 mc68000 mc68010 mc68020 mc68030 \
	mc68040 mc68060 mc68k mc68k32 mc700 \
	mc88000 mc88100 merlin mert mips mvs n16 \
	ncl_el ncl_mr \
	news1500 news1700 news1800 news1900 news3700 \
	news700 news800 news900 ns16000 ns32000 \
	ns32016 ns32332 ns32k nsc32000 os osf \
	parisc pc532 pdp11 plexus posix pyr \
	riscix riscos scs sequent sgi sinix sony sony_news \
	sonyrisc sparc sparclite spectrum stardent stratos \
	sun sun3 sun386 svr4 sysV68 sysV88 \
	titan tower tower32 tower32_200 tower32_600 tower32_700 \
	tower32_800 tower32_850 tss u370 u3b u3b2 u3b20 u3b200 \
	u3b20d u3b5 ultrix unix unixpc unos vax venix vms \
	xenix z8000"

    if test $cross_compiling != yes; then
      # Some cpp's do not define any symbols, but instead let /bin/cc do it
      # for them.  For such machines, not using CPP to run this test (instead
      # creating a program which printf's them to stdout) may prove useful.
      (echo "#include <stdio.h>"			;\
      echo "main ()" 					;\
      echo "{"						;\
      Q=\\\"						;\
      for i in $syms; do				 \
	echo "#ifdef $i"				;\
	echo "  printf(\"$Q$i$Q, \");"			;\
	echo "#endif"					;\
      done						;\
      echo "  printf (\"\n\");"				;\
      echo "  exit (0);"				;\
      echo "}")						>conftest.$ac_ext

      dnl Stolen from AC_TRY_RUN's definition
      AC_TRY_EVAL(ac_link) && gst_cv_machine_defines=`./conftest 2>/dev/null`
    fi
    if test -z "$gst_cv_machine_defines"; then
      (for i in $syms; do				 \
	echo "#ifdef $i"				;\
	echo "\"$i\","					;\
	echo "#endif"					;\
      done)						>conftest.$ac_ext

      gst_cv_machine_defines=`(eval "$ac_cpp conftest.$ac_ext") | grep ","`
    fi
    rm -rf conftest*
])

AC_DEFINE_UNQUOTED(MACHINE_DEFINES, $gst_cv_machine_defines,
  [The set of builtin preprocessor symbols which are defined on the target.])

])dnl

AC_DEFUN(GST_C_VARARGS, [

AC_CHECK_HEADERS(stdarg.h)
AC_CACHE_CHECK(whether va_arg(..., char) works, gst_cv_working_va_arg, [
  old_CFLAGS="$CFLAGS"
  if test "$GCC" = yes; then
    CFLAGS="$CFLAGS -O2"
  else
    CFLAGS="$CFLAGS -O"
  fi

  AC_TRY_LINK([
#   include <stdarg.h>

    int testfunc (int test, ...)
    {
      va_list args;
      char    test2;
  
      va_start(args, test);
      test = va_arg(args, char);
    }], [
      testfunc(5, '3');
      return 0;
    ],
    gst_cv_working_va_arg=yes,
    gst_cv_working_va_arg=no
  )
  CFLAGS="$old_CFLAGS"
])

if test $gst_cv_working_va_arg = no; then
  AC_DEFINE(PICKY_VA_ARG, 1,
            [Define if your system does not support va_arg(..., char)])
fi

])dnl

AC_DEFUN(GST_DOUBLE_ALIGNMENT, [

AC_CACHE_CHECK(for double alignment, gst_cv_double_alignment, [
AC_TRY_RUN([
  main(argc)
  int argc;
  {
    long vec[3];
    double *testptr;

    /* The argument to exit is always 0, and the reference to argc
     * has no purpose other than that to fool the optimizer -- of
     * course argc != -1, so exit's parameter will always be 0 and
     * the test will only fail if the program segfaults.
     */
    testptr = (double *) &vec[1];
    exit (*testptr == 1.0 && argc == -1);
  }],
  gst_cv_double_alignment=SIZEOF_CHAR_P,
  gst_cv_double_alignment="2*SIZEOF_CHAR_P",
  gst_cv_double_alignment="2*SIZEOF_CHAR_P")     dnl Assume the worst
])

AC_DEFINE_UNQUOTED(DOUBLE_ALIGNMENT, $gst_cv_double_alignment,
               [Define this to the memory alignment required by type "double"])

])dnl

define(AC_IS_AUTOHEADER,ifelse(index(defn([AC_CHECK_FUNCS]),@@@),-1,no,yes))
AC_DEFUN(GST_FUNC_WAITPID, [
AC_REQUIRE([AC_HEADER_SYS_WAIT])
AC_CHECK_FUNCS(wait wait3 waitpid)

ifelse(AC_IS_AUTOHEADER,yes,, [dnl
# Check whether we have no waitpid, but we can emulate it
if test $ac_cv_func_waitpid = no; then
  if test $ac_cv_func_wait = yes || test $ac_cv_func_wait3 = yes; then
    LIBOBJS="$LIBOBJS waitpid.o" AC_DEFINE(HAVE_WAITPID)
  fi
fi
])])dnl

AC_DEFUN(GST_FUNC_OBSTACK, [

AC_CACHE_CHECK(for obstacks, am_cv_func_obstack, [
  AC_TRY_LINK([#include "obstack.h"],
	      [struct obstack *mem;obstack_free(mem,(char *) 0)],
	      am_cv_func_obstack=yes,
	      am_cv_func_obstack=no)
])

if test $am_cv_func_obstack = yes; then
  AC_DEFINE(HAVE_OBSTACK, 1, [Define if your system has obstacks.])
else
  LIBOBJS="$LIBOBJS obstack.o"
fi

])dnl

AC_DEFUN(GST_FUNC_STRTOUL, [

# Check for strtoul.  Under some versions of AIX, strtoul returns
# an incorrect terminator pointer for the string "0".
AC_CACHE_CHECK(for strtoul, gst_cv_working_strtoul, [
  exec AC_FD_MSG>/dev/null
  AC_CHECK_FUNC(strtoul, gst_cv_working_strtoul=yes, gst_cv_working_strtoul=no)
  if test $gst_cv_working_strtoul = yes; then
    AC_TRY_RUN([
      extern int strtoul();
      int main()
      {
	char *string = "0";
	char *term;
	int value;
	value = strtoul(string, &term, 0);
	exit((value != 0) || (term != (string+1)));
      }], ,
      [gst_cv_working_strtoul="yes, but broken"],
      [gst_cv_working_strtoul="yes, but cross-compiling"])
  fi
  test "$silent" != yes && exec AC_FD_MSG>&1
])

test "$gst_cv_working_strtoul" != yes && LIBOBJS="$LIBOBJS strtoul.o"

])dnl

AC_DEFUN(GST_FUNC_LOCALTIME, [

AC_CACHE_CHECK(whether localtime caches the timezone, emacs_cv_localtime_cache,
[AC_REQUIRE([AC_HEADER_TIME])
AC_TRY_RUN(
    [#if defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
    # include <sys/time.h>
    #endif
    #if !defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
    # include <time.h>
    #endif
    #if STDC_HEADERS
    # include <stdlib.h>
    #endif

    extern char **environ;
    unset_TZ ()
    {
      char **from, **to;
      for (to = from = environ; (*to = *from); from++)
        if (! (to[0][0] == 'T' && to[0][1] == 'Z' && to[0][2] == '='))
          to++;
    }
    char TZ_GMT0[] = "TZ=GMT0";
    char TZ_PST8[] = "TZ=PST8";
    main()
    {
      time_t now = time ((time_t *) 0);
      int hour_GMT0, hour_unset;
      if (putenv (TZ_GMT0) != 0)
        exit (1);
      hour_GMT0 = localtime (&now)->tm_hour;
      unset_TZ ();
      hour_unset = localtime (&now)->tm_hour;
      if (putenv (TZ_PST8) != 0)
        exit (1);
      if (localtime (&now)->tm_hour == hour_GMT0)
        exit (1);
      unset_TZ ();
      if (localtime (&now)->tm_hour != hour_unset)
        exit (1);
      exit (0);
    }],
    emacs_cv_localtime_cache=no, emacs_cv_localtime_cache=yes,

    [# Assume the worst when cross-compiling.
    emacs_cv_localtime_cache=yes])
])
test $emacs_cv_localtime_cache = yes && \
  AC_DEFINE(LOCALTIME_CACHE, 1, [Define if your system's localtime(3) caches the timezone.])

])dnl

AC_DEFUN(GST_HAVE_TCLTK, [

AC_ARG_WITH(tcl, 
	[  --with-tcl=path         set path to tclConfig.sh [default=ask tclsh]])

AC_ARG_WITH(tk, 
	[  --with-tk=path          set path to tkConfig.sh [default=same as Tcl]])

AC_MSG_CHECKING(for Tcl 8.x)
if test -z "$with_tcl" -o "$with_tcl" = yes; then
  exec AC_FD_MSG>/dev/null
  AC_PATH_PROG(TCLSH, tclsh)
  test "$silent" != yes && exec AC_FD_MSG>&1
  if test -n "$TCLSH"; then
    # Remove the last component from the path
    with_tcl=`echo 'puts $tcl_library' | $TCLSH | sed 's,\(.*\)/.*,\1,'`
  else
    with_tcl=no
  fi
fi
if test -z "$with_tk" -o "${with_tk}" = yes; then
  with_tk=$with_tcl
fi
test -f "$with_tcl/tclConfig.sh" || with_tcl=no
test -f "$with_tk/tkConfig.sh" || with_tk=no

AC_MSG_RESULT($with_tcl)
AC_MSG_CHECKING(for Tk 8.x)
AC_MSG_RESULT($with_tk)

AC_CACHE_CHECK(how to link with Tcl/Tk 8.x, gst_cv_tcltk_libs, [
  exec AC_FD_MSG>/dev/null

  gst_cv_tcltk_libs="not found"

  if test "$with_tcl" != no -a "$with_tk" != no; then
    # Get the values we need from the Tcl/Tk configuration files
    . $with_tcl/tclConfig.sh
    . $with_tk/tkConfig.sh

    # The indirection is required by Tcl/Tk
    gst_cv_tcltk_libs="$TCL_LIBS $TK_XLIBSW $TCL_LIB_SPEC $TK_LIB_SPEC"
    gst_cv_tcltk_libs=`eval echo $gst_cv_tcltk_libs`
    gst_cv_tcltk_includes="$TK_XINCLUDES -I$TCL_PREFIX/include"

    test "$TCL_PREFIX" != "$TK_PREFIX" &&
      gst_cv_tcltk_includes="$gst_cv_tcltk_includes -I$TK_PREFIX/include"

    save_cppflags="$CPPFLAGS"
    save_libs="$LIBS"
    CPPFLAGS="$CPPFLAGS $gst_cv_tcltk_includes"
    LIBS="$LIBS $gst_cv_tcltk_libs"

    # Check the headers & libraries
    AC_EGREP_CPP(everything_fine, [
#include <tcl.h>
#include <tk.h>
#ifdef TCL_MAJOR_VERSION
#ifdef TK_MAJOR_VERSION
#if ((TCL_MAJOR_VERSION == $TCL_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
#if ((TK_MAJOR_VERSION == $TK_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
    everything_fine
#endif
#endif
#endif
#endif], , gst_cv_tcltk_libs="not found")

    AC_CHECK_FUNC(Tcl_ObjSetVar2, , gst_cv_tcltk_libs="not found")
    AC_CHECK_FUNC(Tk_CreatePhotoImageFormat, , gst_cv_tcltk_libs="not found")
    CPPFLAGS="$save_cppflags"
    LIBS="$save_libs"
  fi
  test "$silent" != yes && exec AC_FD_MSG>&1
])

if test "$gst_cv_tcltk_libs" != "not found"; then
  AC_MSG_CHECKING(include path for Tcl/Tk)
  AC_MSG_RESULT($gst_cv_tcltk_includes)
  TCL_LIBS="$gst_cv_tcltk_libs"
  TCL_INCLUDES="$gst_cv_tcltk_includes"
  AC_DEFINE(HAVE_TCLTK, 1,
      [Define if your system has Tcl/Tk, 8.0 or later, installed.])
fi

AC_SUBST(TCL_LIBS)
AC_SUBST(TCL_INCLUDES)
])dnl

dnl AC_INIT(tcltk.m4)
dnl AC_PROG_CC
dnl GST_HAVE_TCLTK
dnl AC_CACHE_SAVE
dnl exit 0

AC_DEFUN(GST_INET_SOCKETS, [

AC_CHECK_LIB(socket, listen)
AC_CHECK_LIB(nsl, gethostbyname)

gst_cv_inet_sockets=yes
AC_CHECK_FUNC(socket, , gst_cv_inet_sockets=no)
AC_CHECK_HEADER(netinet/in.h, , gst_cv_inet_sockets=no)
AC_CHECK_HEADER(arpa/inet.h, , gst_cv_inet_sockets=no)
test $gst_cv_inet_sockets = yes && \
  AC_DEFINE(HAVE_INET_SOCKETS, 1, [Define if your system's sockets provide access to the Internet.])


])dnl

AC_DEFUN(GST_HAVE_READLINE, [

AC_ARG_WITH(readline, 
	[  --with-readline=path    set path to readline and termcap libraries
  --without-readline      don't try to detect readline])


if test "$with_readline" != no; then
  AC_CACHE_CHECK(how to link with readline, gst_cv_readline_libs, [
    test "$with_readline" && test -d "$with_readline" && \
      LDFLAGS="$LDFLAGS -L$with_readline"
    gst_cv_readline_libs="not found"
    ac_save_LIBS="$LIBS"
    for lib in "" -ltermcap -ltermlib -lncurses; do
      LIBS="$ac_save_LIBS -lreadline $lib"

      cat > conftest.$ac_ext <<\EOF
#include <stdio.h>
#include <readline/readline.h>
main()
{
  rl_bind_key ('\t', rl_insert);
  exit(0);
}
EOF
      dnl Link the program.  If not cross-compiling, run it too,
      dnl to detect shared library dependancies.

      ok=yes
      (AC_TRY_EVAL(ac_link) && test -s conftest${ac_exeext})	    || ok=no
      test $cross_compiling = no -a $ok = yes && (./conftest; exit) || ok=no
      rm -rf conftest*

      test $ok = yes && gst_cv_readline_libs="-lreadline $lib" break
    done
    LIBS="$ac_save_LIBS"
  ])

  if test "$gst_cv_readline_libs" != "not found"; then
    LIBS="$LIBS $gst_cv_readline_libs"
    AC_DEFINE(HAVE_READLINE, 1,
          [Define if your system has the GNU readline library.])
  fi
fi

])dnl

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

AC_DEFUN(LIGHTNING_CONFIGURE_IF_NOT_FOUND, [
AC_REQUIRE([AC_PROG_LN_S])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AM_CONDITIONAL(LIGHTNING_MAIN, (exit 1))
AC_CHECK_HEADER(lightning.h)

lightning=
if test "$ac_cv_header_lightning_h" = yes; then
  lightning=yes
else
  case "$host_cpu" in
	i?86)	 cpu_subdir=i386					;;
	sparc)	 cpu_subdir=sparc					;;
	powerpc) cpu_subdir=ppc						;;
	*)	 ;;
  esac
  test -n "$cpu_subdir" && lightning=yes
fi

AC_OUTPUT_COMMANDS([
  if test -n "$cpu_subdir"; then
    for i in asm fp core funcs; do
      echo linking $srcdir/lightning/$cpu_subdir/$i.h to lightning/$i.h 
      (cd lightning && $LN_S -f $srcdir/$cpu_subdir/$i.h $i.h)
    done
  fi
], [
  LN_S='$LN_S'
  cpu_subdir=$cpu_subdir
])

if test -n "$lightning"; then
  AC_DEFINE(HAVE_LIGHTNING, 1, [Define if GNU lightning can be used])
  lightning=
  ifelse([$1], , :, [$1])
else
  ifelse([$2], , :, [$2])
fi

])dnl

AC_DEFUN(GST_ARG_ENABLE_MODULES, [

AC_ARG_ENABLE(modules,
[  --enable-modules=list   add these packages to the pre-built image])

test "$enable_modules" = "yes" && enable_modules="$1"
test "$enable_modules" = "no" && enable_modules=
MODULES=`echo $enable_modules | sed "s/,/ /g"`
AC_SUBST(MODULES)
])


