"======================================================================
|
|   Smalltalk GUI browser initialization script
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

"Smalltalk blox+browser initialization script"

| verbose |

Transcript nl; nextPutAll: 'Initializing system -- be patient...'; nl.

verbose := FileStream verbose: true.

(Namespace current includesKey: #BrowserMain)
    ifTrue: [ (Namespace current at: #BrowserMain) close ].


#(

"Load our dependancy system and graphics kernel"
  'GuiData.st'
  'View.st'
  'Manager.st'
  'RadioForm.st'
  'Menu.st'
  'ModalDialog.st'
  'PList.st'
  'PText.st'

"View classes"
  '../examples/Buffers.st'
  'PCode.st'		"Syntax highlighting is here"
  'BrowShell.st'
  'BrowserMain.st'
  'ClassBrow.st'
  'MethSetBrow.st'
  'Inspector.st'
  'DictInspect.st'
  'MethInspect.st'
  'StrcInspect.st'

"Load files that support Steve's walkback inspector"
  'CtxtInspect.st'
  'Notifier.st'
) do: [ :file | FileStream fileIn: file ].

FileStream verbose: verbose!

Collection removeSelector: #inspect ifAbsent: [ ].
SequenceableCollection removeSelector: #inspect ifAbsent: [ ]!
