"======================================================================
|
|   Smalltalk lexical token definitions.
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #STToken
       instanceVariableNames: 'line'
       classVariableNames: ''
       poolDictionaries:''
       category: 'System-Compiler'
!

STToken comment:
'My instances are returned from the lexer stream.  If you ask them (nicely,
mind you) they will report their kind (through messages like #isSTDotTok) and
sometimes their value (such as ''foobar'').'!

STToken subclass: #STValueToken
      instanceVariableNames: 'value'
      classVariableNames: ''
      poolDictionaries: ''
      category: 'System-Compiler'
!

!STToken class methodsFor: 'subclass creation'!

defineSubclasses: classNames
    | method |
    method := 'is%1
	^%2'.

    classNames do: [ :className |
	| class |
	class := self subclass: className
	    instanceVariableNames: ''
	    classVariableNames: ''
	    poolDictionaries: ''
	    category: 'System-Compiler'.

	class compile: (method bindWith: className with: 'true') classified: 'testing'.
	STToken compile: (method bindWith: className with: 'false') classified: 'testing'
    ]
! !

!STToken class methodsFor: 'instance creation'!

new: location
     ^self new line: location
! !

!STToken methodsFor: 'accessing'!

= differentToken
    ^self class == differentToken class
!

hash
    ^self class hash
!

line
    ^line
!

line: lineNo
    line := lineNo
!

printOn: aStream
    aStream
	nextPut: $< ;
	print: self class;
	nextPut: $>.
! !


!STValueToken class methodsFor: 'instance creation'!

new: location value: aValue
     ^(self new: location) init: aValue
! !

!STValueToken methodsFor: 'accessing'!

= differentToken
    ^self class == differentToken class and: [ value = differentToken value ]
!

hash
    ^value hash
!

printOn: aStream
    aStream
	nextPut: $< ;
	print: self class;
	nextPut: $: ;
	print: self value;
	nextPut: $>.
!

value
    ^value
! !

!STValueToken methodsFor: 'private'!

init: aValue
    value := aValue
! !


STToken defineSubclasses:
    #(STSpecialTok		STVerticalBarTok
      STBangTok			STSharpTok
      STColonTok		STPrimitiveStartTok).

STValueToken defineSubclasses:
    #(STSymbolTok		STCommentTok
      STLiteralTok)		"integer, float, character"!

STSpecialTok defineSubclasses:
    #(STDotTok 			STOpenParenTok
      STCloseParenTok		STSemiTok
      STOpenBracketTok		STCloseBracketTok
      STOpenBraceTok		STCloseBraceTok
      STUpArrowTok		STAssignTok).
      
STLiteralTok defineSubclasses:
    #(STStringTok).

STSymbolTok defineSubclasses:
    #(STIdentifierTok		STKeywordTok
      STSymbolKeywordTok	STBinopTok)
!

!STVerticalBarTok methodsFor: 'accessing'!

value
    ^'|'
! !

!STBangTok methodsFor: 'accessing'!

value
    ^'!'
! !

!STToken methodsFor: 'testing'!

isSTSymbolTok
    ^self isBinaryOperator
!

isBinaryOperator
    ^false
! !

!STBinopTok methodsFor: 'testing'!

isBinaryOperator
    ^true
! !

!STVerticalBarTok methodsFor: 'testing'!

isBinaryOperator
    ^true
! !
