"======================================================================
|
|   Sample watchdog timer object
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Written by Ulf Dambacher.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Object subclass: #Watchdog
       instanceVariableNames: 'actionBlock relax ok delay'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Examples-Processes'
!

Watchdog comment: 'I am used to watch for system hangups'!

!Watchdog class methodsFor: 'all'!

new
    ^super new initialize
!

do: aBlock
    ^ self new do: aBlock; watch.
! !

!Watchdog methodsFor: 'all'!

initialize
    relax := true.
    delay := Delay forSeconds: 60.
    ok := true.
    actionBlock := ValueHolder null. 	"Anything that answers #value will do"
!

relax
    relax := true.
!

do: aBlock
    actionBlock := aBlock.
!

ok
    ok := true.
!

watch
    relax := false.
    ok := false.
    [ [ delay wait. relax ] whileFalse: [
	 ok ifFalse: [ actionBlock value ].
	 ok := false.
    ] forkAt: Processor lowIOPriority.
!

checkAfterSeconds: value
    delay := Delay forSeconds: value
! !
