#! @AWK@ -f

#######################################################################
#
#   DBCS table creation script (DBCS->UCS)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
# Written by Paolo Bonzini.
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  hi = lo = -1
  n = 0
  ORS = "\t"
  print
}

length($(NF-1)) == 4 {
  get_hi()
  if (lo > -1) leadbyte_end()
  hi = advance(hi, hi_now)
  lo = -1
  hexout($NF)
}

length($(NF-1)) == 6 {
  get_lo()
  get_hi()

  if (hi_now == hi) {
    lo = advance(lo, lo_now)
  } else {
    if (lo > -1)
      leadbyte_end()

    delta = hi_now - hi
    hi = advance(hi, hi_now)
    lo = lo_now

    if (delta > 1) {
      printf "\n\n\t"
      n = 0
    }
    printf "(%d (\t", lo
    n++;
  }
  hexout($NF)
}

END {
  if (lo > -1) leadbyte_end()
  advance(hi, 256)
}

#######################################################################

function hexout(x) {
  if (n == 7) {
    n = 0
    ORS = "\n\t"
  } else
    n++

  print "16r" substr(x, 3)

  if (n == 0)
    ORS = "\t"
}

function advance(from, to) {
  for (++from; from < to; from++) {
    if (n == 7) {
      n = 0
      ORS = "\n\t"
    } else
      n++

    print "nil"
    if (n == 0)
      ORS = "\t"
  }
  return to
}

function leadbyte_end() {
  printf(") %d)\n\n\t", lo)
  n = 0
}

function get_lo() {
  lo_now = \
    16 * index("0123456789ABCDEF", substr($(NF-1), 5, 1)) + \
    index("0123456789ABCDEF", substr($(NF-1), 6, 1)) - 17
}

function get_hi() {
  hi_now = \
    16 * index("0123456789ABCDEF", substr($(NF-1), 3, 1)) + \
    index("0123456789ABCDEF", substr($(NF-1), 4, 1)) - 17
}
