#! @AWK@ -f

#######################################################################
#
#   DBCS table creation script (DBCS->UCS values)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
# Written by Paolo Bonzini.
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  ORS="\t"
  printf "\t"
  
  getline
  get_this()
  n = 0
  from = last = this
  block[this] = $2
}

{
  get_this()

  if (last < this - 1 && this - from > 6)
    flush()

  last = this
  block[this] = $2
}

END {
  flush()
}

#######################################################################

function flush() {
  for (i = from; i <= last; i++) {
    if (n == 7) {
      n = 0
      ORS = "\n\t"
    } else
      n++
  
    if (i in block)
      print "16r" substr(block[i], 3)
    else
      print "nil"

    if (n == 0)
      ORS = "\t"
  }

  # This clears the array (see GAWK manual)
  split("", block)
  from = this
}

function get_this() {
  this = \
    4096 * index("0123456789ABCDEF", substr($1, 3, 1)) + \
    256 * index("0123456789ABCDEF", substr($1, 4, 1)) + \
    16 * index("0123456789ABCDEF", substr($1, 5, 1)) + \
    index("0123456789ABCDEF", substr($1, 6, 1)) - 4369
}
