"======================================================================
|
|   FileSegment Method Definitions
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #FileSegment
       instanceVariableNames: 'file startPos size'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Implementation'
!

FileSegment comment: 
'My instances represent sections of files.  I am primarily used by the
compiler to record source code locations.  I am not a part of the normal
Smalltalk-80 kernel; I am specific to the GNU Smalltalk implementation.' !



!FileSegment class methodsFor: 'basic'!

on: aFile startingAt: startPos for: sizeInteger
    "Create a new FileSegment referring to the contents of the given file,
    from the startPos-th byte and for sizeInteger bytes"
    ^self new setFile: aFile start: startPos size: sizeInteger
! !



!FileSegment methodsFor: 'basic'!

asString
    "Answer a String containing the required segment of the file"
    ^self withFileDo: [ :fileStream |
	fileStream position: startPos.
	fileStream next: size.
    ]
!

withFileDo: aBlock
    "Evaluate aBlock passing it the FileStream in which the segment
     identified by the receiver is stored"
    | result fileStream |
    fileStream := FileStream open: self fileName mode: FileStream read.
    result := aBlock value: fileStream.
    fileStream close.
    ^result
!

fileName
    "Answer the name of the file containing the segment"
    ^file
!

filePos
    "Answer the position in the file where the segment starts"
    ^startPos
!

size
    "Answer the length of the segment"
    ^size
! !


!FileSegment methodsFor: 'equality'!

= aFileSegment
    "Answer whether the receiver and aFileSegment are equal."

    (aFileSegment isKindOf: FileSegment) ifFalse: [ ^false ].
    self == aFileSegment ifTrue: [ ^true ].

    ^self fileName = aFileSegment fileName and: [
	startPos = aFileSegment filePos and: [
	    size = aFileSegment size ] ]
!

hash
    "Answer an hash value for the receiver."

    ^self fileName hash + startPos + size
! !


!FileSegment methodsFor: 'private'!

getFile
    ^file
!

setFile: aFileName start: startingPos size: sizeInteger
    file := aFileName.
    startPos := startingPos.
    size := sizeInteger.
! !
