/******************************** -*- C -*- ****************************
 *
 *	Emulation for usleep
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
#include "gstconf.h"
#endif

#if defined(WIN32) || defined (_WIN32)
# include <windows.h>
#else
# ifdef HAVE_UNISTD_H
#  include <unistd.h>
# endif 
# if defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
#  include <sys/time.h>
# endif
# if !defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
#  include <time.h>
# endif
# ifdef HAVE_SELECT
#  include <sys/select.h>
# endif
#endif

#ifndef HAVE_USLEEP

unsigned int
usleep(usecs)
     unsigned int usecs;
{
/* Please feel free to make this more accurate for your operating system
 * and send me the changes.
 */
#ifdef WIN32
  Sleep((usecs + 999) / 1000);
  return 0;
#else
#ifdef HAVE_SELECT
  struct timeval time;
  time.tv_sec = usecs / 1000000;
  time.tv_usec = usecs % 1000000;

  select(0, NULL, NULL, NULL, &time);
  return time.tv_sec * 1000000 + time.tv_usec;
#else
  return 0;
#endif
#endif
}

#endif
