/******************************** -*- C -*- ****************************
 *
 *	External definitions for the input module.
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTINPUT__
#define __GSTINPUT__

typedef enum {
  unknownStreamType,
  fileStreamType,
  stringStreamType
#ifdef HAVE_READLINE
  , readlineStreamType
#endif /* HAVE_READLINE */
} StreamType;

extern mst_Boolean	        emacsProcess, storeNoSource;

extern void			pushUNIXFile(), pushSmalltalkString(), 
				popStream(), clearMethodStartPos(),
  				setStreamInfo(), initChangesStream(),
				resetChangesFile(), pushCString(),
				pushStdinString(), errorf(), yyerror(),
                                parseStream(), unreadChar(), yyprint();

extern int                      nextChar();

extern char			*getMethodSourceFromCurFile();

extern StreamType		getCurStreamType();

extern char			*changeFileName;

extern OOP			getCurFileName(), getCurString();

extern int			getCurFilePos();

extern mst_Boolean 		isKernelFile();

#ifdef HAVE_READLINE
extern void			initializeReadline();

extern void                     addSymbolCompletion(),
				disableCompletions(), enableCompletions();

extern OOP			getCurReadline();

#endif /* HAVE_READLINE */


#endif
