/******************************** -*- C -*- ****************************
 *
 *	Fast versions of memset(s, 0, n)
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.  Inspired by the Linux source code.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef __MEMZERO_H
#define __MEMZERO_H

#include "config.h"

/*** ### should include at least a SPARC version */

/**************************************** not GCC ************************/

#ifndef __GNUC__
/* Fool the preprocessor and make it discard the following code */
#define __MEMZERO_DONE
#endif

/**************************************** MIPS ***************************/

#if defined(__mips) || defined(mips)
#ifndef __MEMZERO_DONE
#define __MEMZERO_DONE
static inline void
memzero(s, count)
     char *s;
     register long count;
{
  if (!count)
    return;

  /* hmmm... this zeroes memory a byte at a time... I wonder whether it
   * is really faster than the generic version... */
  __asm__ __volatile__(
	".set	noreorder"			"\n"
"1:	sb	%3,(%0)"			"\n"
"	bne	%0,%1,1b"			"\n"
"	addiu	%0,%0,1"			"\n"
"	.set	treorder"
	: "=r" (s), "=r" (count)
        : "0" (s), "r" (0L), "1" (s + count - 1)
	: "memory");
}
#endif
#endif

/**************************************** Intel x86 **********************/

#if defined(__i386__) || defined(__i386) || defined(i386)
#ifndef __MEMZERO_DONE
#define __MEMZERO_DONE
static inline void
memzero(s, count)
     char *s;
     long count;
{
int d0, d1;
__asm__ __volatile__(
	"cld"			"\n"
"	rep ; stosl"		"\n"
"	testb $2,%b3"		"\n"
"	je 1f"			"\n"
"	stosw"			"\n"
"1:	testb $1,%b3"		"\n"
"	je 2f"			"\n"
"	stosb"			"\n"
"2:"
	: "=&c" (d0), "=&D" (d1)
	:"a" (0L), "q" (count), "0" (count/4), "1" ((long) s)
	:"memory");
}
#endif
#endif

/**************************************** Default implementation *********/

#if !defined(__MEMZERO_DONE) || !defined(__GNUC__)

/* cfr memmove.c -- both files implement a very fast unrolled loop, using
 * approx. the same code (this has only destination, memmove has
 * source+destination). */
#define COPY(type)  *((type *) dst)++ = (type) 0;

/* This loop ensures that dst is aligned to a power of two 
 * bigger than sizeof(type)
 */
#define LOOP_ALIGN(type)					\
  while(n >= sizeof(type) && ((long) dst) & sizeof(type) ) {	\
    n -= sizeof(type);						\
    COPY(type);							\
  }								\

/* This loop does as much as possible with the given type. */
#define LOOP_FINISH(type)					\
  while(n >= sizeof(type)) {					\
    n -= sizeof(type);						\
    COPY(type);							\
  }								\

static inline void
memzero(dst, n)
     register char *dst;
     register long n;
{
  LOOP_ALIGN(char);
  LOOP_ALIGN(short);
#if SIZEOF_LONG > SIZEOF_INT
  LOOP_ALIGN(int);
  LOOP_FINISH(long);
#endif
  LOOP_FINISH(int);
  LOOP_FINISH(short);
  LOOP_FINISH(char);
}

#undef LOOP_ALIGN
#undef LOOP_FINISH
#undef COPY
#endif

#undef __MEMZERO_DONE

#endif /* __MEMZERO_H */
