/******************************** -*- C -*- ****************************
 *
 *	Byte Code definitions.
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTOPT__
#define __GSTOPT__

#include "byte.h"

extern ByteCodes		optimizeByteCodes();

extern void			computeStackPositions(), analyzeByteCodes();

extern int			isSimpleReturn(), checkKindOfBlock();

extern int			isSendTable[], isPushTable[];

#define isSendByteCode(b)	isSendTable[b]
#define isPushByteCode(b)	isPushTable[b]

#define TOP_UNKNOWN		0
#define TOP_IS_INTEGER		1
#define TOP_IS_NOT_INTEGER	2

#endif /* __GSTBYTE__ */
