/******************************** -*- C -*- ****************************
 *
 *	Symbol Table declarations
 *
 *	$Revision: 1.95.1$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#ifndef __GSTSYM__
#define __GSTSYM__

#include <gst.h>

#define SYMBOL_TABLE_SIZE	521

typedef enum {
  temporaryScope,
  receiverScope,
  globalScope,
  specialScope,
} ScopeType;

typedef struct SymbolStruct {
  OBJ_HEADER;			/* I love inheritance */
  char		symString[1];
} *Symbol;

typedef struct SymbolEntryStruct {
  ScopeType	scope;
  OOP		symbol;
  mst_Boolean	readOnly;
  int		varIndex;	/* index of receiver or temporary */
  unsigned int	scopeDistance;	/* how many frames up the stack is this
				   variable from where we are? */
} SymbolEntry;

typedef struct SymbolInfoStruct {
  OOP		*symbolVar;
  char		*value;
} SymbolInfo;

extern long		useUndeclared;

extern mst_Boolean	findVariable();

extern OOP		andColonSymbol, atColonPutColonSymbol, atColonSymbol,
			atSignSymbol, atEndSymbol, bitAndColonSymbol,
			bitOrColonSymbol, bitShiftColonSymbol,
			blockCopyColonSymbol, classSymbol, isNilSymbol,
			notNilSymbol, divideSymbol, doColonSymbol, equalSymbol,
			greaterEqualSymbol, greaterThanSymbol,
			ifFalseColonIfTrueColonSymbol, ifFalseColonSymbol,
			ifTrueColonIfFalseColonSymbol, ifTrueColonSymbol,
			integerDivideSymbol, lessEqualSymbol, lessThanSymbol,
			minusSymbol, newColonSymbol, newSymbol,
			nextPutColonSymbol, nextSymbol, notEqualSymbol,
			notSameObjectSymbol, orColonSymbol, plusSymbol,
			remainderSymbol, sameObjectSymbol, sizeSymbol,
			thisContextSymbol, finalizeSymbol, timesSymbol, 
			toColonDoColonSymbol, timesRepeatColonSymbol,
			toColonByColonDoColonSymbol, uppercaseSuperSymbol,
			valueColonSymbol, valueColonValueColonSymbol,
			valueColonValueColonValueColonSymbol,
 			valueWithArgumentsColonSymbol, whileFalseSymbol, 
			valueSymbol, yourselfSymbol, whileTrueSymbol,
			whileFalseColonSymbol, whileTrueColonSymbol,
			badReturnErrorSymbol, superSymbol, nilSymbol,
			trueSymbol, falseSymbol, selfSymbol, repeatSymbol,
			doesNotUnderstandColonSymbol, mustBeBooleanSymbol,
			terminateSymbol, asScaledDecimalSymbol,
			unknownSymbol, charSymbol, stringSymbol,
			stringOutSymbol, symbolSymbol, intSymbol,
			longSymbol, floatSymbol,  doubleSymbol,
			booleanSymbol, voidSymbol, variadicSymbol,
			cObjectSymbol, cObjectPtrSymbol, smalltalkSymbol,
			byteArraySymbol, byteArrayOutSymbol, undeclaredSymbol,
			
			symbolTable, currentNamespace;

extern SymbolInfo	symbolInfo[];

extern OOP		internString(),
  			makeInstanceVariableArray(),
			makeClassVariableDictionary(),
                        makePoolArray(), findVariableBinding(),
			internStringOOP();

extern char		*symbolAsString();

extern unsigned long	hashString();

extern int		stringOOPLen(), getArgCount(), getTempCount(),
			declareArguments(), declareTemporaries(),
			declareBlockArguments(), declareName(),
			selectorNumArgs();

extern void		printString(), printSymbol(), undeclareName(),
			pushNewScope(), scopeReturnsFromMethod(),
			freeSymbolEntry(), popOldScope(),
			printSymbolEntry();

#ifdef HAVE_READLINE
extern void	    addAllSymbolCompletions();
#endif

#endif /* __GSTSYM__ */
