"======================================================================
|
|   SUnit testing framework - tests
|
|   This file is in the public domain.
|
 ======================================================================"

TestCase subclass: #SUnitTest
	instanceVariableNames: 'hasRun hasSetup hasRanOnce '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'!

SUnitTest class
	instanceVariableNames: ''!

TestCase subclass: #ExampleSetTest
	instanceVariableNames: 'full empty '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'!

ExampleSetTest class
	instanceVariableNames: ''!

TestResource subclass: #ExampleTestResource
	instanceVariableNames: 'runningState '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'!

ExampleTestResource class
	instanceVariableNames: ''!

!SUnitTest methodsFor: 'Private'!

assertForTestResult: aResult runCount: aRunCount passed: aPassedCount failed: aFailureCount errors: anErrorCount

	self
		assert: aResult runCount = aRunCount;
		assert: aResult passedCount = aPassedCount;
		assert: aResult failureCount = aFailureCount;
		assert: aResult errorCount = anErrorCount!

error
	3 zork!

fail
	self assert: false!

noop!

setRun
	hasRun := true! !

!SUnitTest methodsFor: 'Accessing'!

hasRun
	^hasRun!

hasSetup
	^hasSetup! !

!SUnitTest methodsFor: 'Running'!

setUp
	hasSetup := true! !

!SUnitTest methodsFor: 'Testing'!

testAssert
	self assert: true.
	self deny: false!

testDebugUI
	"This should break"
	3 zork!

testDefects
	| result suite error failure |
	suite := TestSuite new.
	suite addTest: (error := self class selector: #error).
	suite addTest: (failure := self class selector: #fail).
	result := suite run.
	self assert: result defects asArray = (Array with: error with: failure).
	self
		assertForTestResult: result
		runCount: 2
		passed: 0
		failed: 1
		errors: 1!

testDialectLocalizedException
	self should: [TestResult signalFailureWith: 'Foo'] raise: TestResult failure.
	self should: [TestResult signalErrorWith: 'Foo'] raise: TestResult error.
	self shouldnt: [TestResult signalErrorWith: 'Foo'] raise: TestResult failure.!

testError
	| case result |
	case := self class selector: #error.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1!

testException
	self should: [self error: 'foo'] raise: TestResult error!

testFail
	| case result |
	case := self class selector: #fail.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 1
		errors: 0!

testFailureDebugUI
	"This should fail !!"
	self fail!

testIsNotRerunOnDebug
	| case |
	case := self class selector: #testRanOnlyOnce.
	case run.
	case debug!

testRan
	| case |
	case := self class selector: #setRun.
	case run.
	self assert: case hasSetup.
	self assert: case hasRun!

testRanOnlyOnce
	self assert: hasRanOnce ~= true.
	hasRanOnce := true.!

testResult
	| case result |
	case := self class selector: #noop.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 1
		failed: 0
		errors: 0!

testRunning
	(SUnitDelay forSeconds: 2) wait!

testShould
	self should: [true].
	self shouldnt: [false]!

testSuite
	| suite result |
	suite := TestSuite new.
	suite addTest: (self class selector: #noop).
	suite addTest: (self class selector: #fail).
	suite addTest: (self class selector: #error).
	result := suite run.
	self
		assertForTestResult: result
		runCount: 3
		passed: 1
		failed: 1
		errors: 1! !

!SUnitTest class methodsFor: 'Testing'!

shouldInheritSelectors
	"answer true to inherit selectors from superclasses"

	^false! !

!ExampleSetTest methodsFor: 'Testing'!

testAdd
	empty add: 5.
	self assert: (empty includes: 5)!

testGrow
	empty addAll: (1 to: 100).
	self assert: empty size = 100!

testIllegal
	self 
		should: [empty at: 5] 
		raise: TestResult error.
	self 
		should: [empty at: 5 put: #abc] 
		raise: TestResult error!

testIncludes
	self assert: (full includes: 5).
	self assert: (full includes: #abc)!

testOccurrences
	self assert: (empty occurrencesOf: 0) = 0.
	self assert: (full occurrencesOf: 5) = 1.
	full add: 5.
	self assert: (full occurrencesOf: 5) = 1!

testRemove
	full remove: 5.
	self assert: (full includes: #abc).
	self deny: (full includes: 5)! !

!ExampleSetTest methodsFor: 'Running'!

setUp
	empty := Set new.
	full := Set with: 5 with: #abc! !

!ExampleTestResource methodsFor: 'Testing'!

isAvailable
	
	^self runningState == self startedStateSymbol!

isStarted
	
	^self runningState == self startedStateSymbol!

isStopped
	
	^self runningState == self stoppedStateSymbol! !

!ExampleTestResource methodsFor: 'Accessing'!

runningState

	^runningState!

runningState: aSymbol

	runningState := aSymbol! !

!ExampleTestResource methodsFor: 'Running'!

setUp
	
	self runningState: self startedStateSymbol!

tearDown

	self runningState: self stoppedStateSymbol! !

!ExampleTestResource methodsFor: 'Constants'!

startedStateSymbol

	^#started!

stoppedStateSymbol

	^#stopped! !

!ExampleTestResource class methodsFor: 'Testing'!

isAvailable

	^super isAvailable and: [self current isStarted]! !

| suite selectors |
suite := ExampleSetTest buildSuite.
(ExampleSetTest -> suite run) printNl.

selectors := SUnitTest sunitAllSelectors.
selectors := selectors select: [ :each | 'test*' sunitMatch: each ].
selectors := selectors reject: [ :each | '*UI' sunitMatch: each ].
suite := SUnitTest buildSuiteFromMethods: selectors.
(SUnitTest -> suite run) printNl.
!
