"======================================================================
|
|   Loader for the ANSI-compliancy tests
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright (C) 2000  Free Software Foundation.
| Written by Paolo Bonzini
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Smalltalk classAt: #Compiler ifAbsent: [
	Object subclass: #Compiler
		instanceVariableNames: ''
		classVariableNames: ''
		poolDictionaries: ''
		category: nil
]!

!Compiler class
	methodsFor: 'evaluation'
	ifTrue: (Compiler respondsTo: #evaluate:) not!

evaluate: aBlock
    ^Behavior evaluate: aBlock! !

"-----------------------------------------------------------------"

!Object methodsFor: 'handle #isSomeClass'!

doesNotUnderstand: aMessage
    | class |
    class := nil.
    aMessage selector size > 3 ifTrue: [
	(aMessage selector copyFrom: 1 to: 2) = 'is' ifTrue: [
	    class := Smalltalk
		classAt: (aMessage selector copyFrom: 3)
		ifAbsent: [ nil ]
	]
    ].

    class notNil ifTrue: [ ^self class == class ].
    MessageNotUnderstood new
	message: aMessage receiver: self;
	tag: self;
	signal
! !

"Test the machinery above"
Set new isSet ifFalse: [ self error: 'huh huh - a Set is not a set' ].
1234567 isSet ifTrue: [ self error: 'huh huh - everything is a set' ]!

"-----------------------------------------------------------------"

"Define ANSI required globals."
Smalltalk at: #'FloatE' put: (Smalltalk at: #'Float').
Smalltalk at: #'FloatD' put: (Smalltalk at: #'Float').
Smalltalk at: #'FloatQ' put: (Smalltalk at: #'Float')!
Smalltalk at: #'DateAndTime' put: (Smalltalk at: #'DateTime')! "???"

"-----------------------------------------------------------------"

PackageLoader fileInPackage: #SUnit!

| ps |
FileStream verbose: true.
Directory working indexOfSubCollection: 'ansi'
	ifAbsent: [ Directory working: Directory kernel, '/../test/ansi' ].

ps := Smalltalk at: #ProtocolSpec ifAbsent: [ nil ].

"File in the ANSI protocol database"
((ps respondsTo: #includesProtocolNamed:)
    and: [ ps includesProtocolNamed: #Character ]) ifFalse: [
	FileStream fileIn: 'AnsiProtos.st'.
	FileStream fileIn: 'AnsiDB.st'.
	FileStream fileIn: 'AnsiInit.st'.
    ].

"File in the ANSI test suite"
FileStream fileIn: 'AnsiSUnit.st'.
FileStream fileIn: 'AnsiTests.st'!

"Smalltalk snapshot!"
