/* COPYRIGHT @ LICENSE -- look at file named LICENSE */

/**
 * This is a regex helper file, here we hide unnecessary complexity 
 * of regular expression confifuration giving very simple, easy-to use
 * functions that are simple to implement
 **/

#include <stdlib.h>
#include "gstpub.h"
#include "regex.h"

/* --- jus to test it --- */
/*
int main( void )
{
	int res = 0;
	res = reh_search("Quick brown fox jumped over .." , "fox", 0, 20 );
	printf("\n\nRES := %d\n\n", res );
	return 0;
}
*/

/**
 * Search helper function
 */
int reh_search (const char * src, 
		const char * pattern,
		const int from,
		const int to )
{
	//printf("\n\nSRC = %s\nPATTERN = %s\nFROM = %d\nTO = %d\n\n", src, pattern, from, to );
	
	int res = 0;
	const char * ress;
	struct re_registers regs;
	
	char fastmap[1 << 8];

	// create buffer 
	struct re_pattern_buffer buff;

	buff.allocated = 8;
	buff.buffer = malloc(buff.allocated);
	buff.fastmap = fastmap;
	buff.translate = 0;

	
	// compile pattern 
	ress = re_compile_pattern( 	pattern, 
					strlen(pattern), 
					&buff );

	if( ress != NULL )
		return -100;
	
	// now search 

	res = re_search( &buff,
			src,
			strlen( src ),
			from,
			to,
			&regs
			);

	free( buff.buffer );
	return res;
	//return 0;
}

/**
 * Match helper function
 */
int reh_match ( const char * src, 
		const char * pattern,
		const int from )
{
	int res = 0;
	const char * ress;
	struct re_registers regs;
	
	char fastmap[1 << 8];

	/* create buffer */
	struct re_pattern_buffer buff;

	buff.allocated = 8;
	buff.buffer = malloc(buff.allocated);
	buff.fastmap = fastmap;
	buff.translate = 0;

	
	/* compile pattern */
	ress = re_compile_pattern( 	pattern, 
					strlen(pattern), 
					&buff );

	if( ress != NULL )
		return -100;
	
	/* now search */

	res = re_match( &buff,
			src,
			strlen( src ),
			from,
			&regs
			);

	free( buff.buffer );
	return res;
}

void
gst_initModule(vmProxy)
     VMProxy *vmProxy;
{
  vmProxy->defineCFunc("reh_search", reh_search);
  vmProxy->defineCFunc("reh_match", reh_match);
}
