"======================================================================
|
|   Support for several single byte character encodings
|
|   $Revision: 1.95.1$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Namespace current: Charsets!

SingleByte subclass: #KOI8
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

KOI8 subclass: #KOI8R
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

KOI8 subclass: #KOI8U
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

SingleByte subclass: #ISO8859
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88591
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88592
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88593
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88594
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88595
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88596
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88597
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88598
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO88599
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO885910
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO885913
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO885914
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

ISO8859 subclass: #ISO885915
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

SingleByte subclass: #JIS0201
    instanceVariableNames: ''
    classVariableNames: ''
    poolDictionaries: ''
    category: 'i18n-Character sets'!

!KOI8 class methodsFor: 'Unicode'!

charsetName
    ^'KOI-8'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	16r044E	16r0430	16r0431	16r0446	16r0434	16r0435	16r0444	16r0433
	16r0445	16r0438	16r0439	16r043A	16r043B	16r043C	16r043D	16r043E
	16r043F	16r044F	16r0440	16r0441	16r0442	16r0443	16r0436	16r0432
	16r044C	16r044B	16r0437	16r0448	16r044D	16r0449	16r0447	16r044A
	16r042E	16r0410	16r0411	16r0426	16r0414	16r0415	16r0424	16r0413
	16r0425	16r0418	16r0419	16r041A	16r041B	16r041C	16r041D	16r041E
	16r041F	16r042F	16r0420	16r0421	16r0422	16r0423	16r0416	16r0412
	16r042C	16r042B	16r0417	16r0428	16r042D	16r0429	16r0427	     -1)! !

!KOI8R class methodsFor: 'Unicode'!

charsetName
    ^'KOI8-R'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r2500	16r2502	16r250C	16r2510	16r2514	16r2518	16r251C	16r2524
	16r252C	16r2534	16r253C	16r2580	16r2584	16r2588	16r258C	16r2590
	16r2591	16r2592	16r2593	16r2320	16r25A0	16r2022	16r221A	16r2248
	16r2264	16r2265	16r00A0	16r2321	16r00B0	16r00B2	16r00B7	16r00F7
	16r2550	16r2551	16r2552	16r0451	16r2553	16r2554	16r2555	16r2556
	16r2557	16r2558	16r2559	16r255A	16r255B	16r255C	16r255D	16r255E
	16r255F	16r2560	16r2561	16r0401	16r2562	16r2563	16r2564	16r2565
	16r2566	16r2567	16r2568	16r2569	16r256A	16r256B	16r256C	16r00A9
	16r044E	16r0430	16r0431	16r0446	16r0434	16r0435	16r0444	16r0433
	16r0445	16r0438	16r0439	16r043A	16r043B	16r043C	16r043D	16r043E
	16r043F	16r044F	16r0440	16r0441	16r0442	16r0443	16r0436	16r0432
	16r044C	16r044B	16r0437	16r0448	16r044D	16r0449	16r0447	16r044A
	16r042E	16r0410	16r0411	16r0426	16r0414	16r0415	16r0424	16r0413
	16r0425	16r0418	16r0419	16r041A	16r041B	16r041C	16r041D	16r041E
	16r041F	16r042F	16r0420	16r0421	16r0422	16r0423	16r0416	16r0412
	16r042C	16r042B	16r0417	16r0428	16r042D	16r0429	16r0427	16r042A)! !

!KOI8U class methodsFor: 'Unicode'!

charsetName
    ^'KOI8-U'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r2500	16r2502	16r250C	16r2510	16r2514	16r2518	16r251C	16r2524
	16r252C	16r2534	16r253C	16r2580	16r2584	16r2588	16r258C	16r2590
	16r2591	16r2592	16r2593	16r2320	16r25A0	16r2019	16r221A	16r2248
	16r2264	16r2265	16r00A0	16r2321	16r00B0	16r00B2	16r00B7	16r00F7
	16r2550	16r2551	16r2552	16r0451	16r0454	16r2554	16r0456	16r0457
	16r2557	16r2558	16r2559	16r255A	16r255B	16r0491	16r255D	16r255E
	16r255F	16r2560	16r2561	16r0401	16r0404	16r2563	16r0406	16r0407
	16r2566	16r2567	16r2568	16r2569	16r256A	16r0490	16r256C	16r00A9
	16r044E	16r0430	16r0431	16r0446	16r0434	16r0435	16r0444	16r0433
	16r0445	16r0438	16r0439	16r043A	16r043B	16r043C	16r043D	16r043E
	16r043F	16r044F	16r0440	16r0441	16r0442	16r0443	16r0436	16r0432
	16r044C	16r044B	16r0437	16r0448	16r044D	16r0449	16r0447	16r044A
	16r042E	16r0410	16r0411	16r0426	16r0414	16r0415	16r0424	16r0413
	16r0425	16r0418	16r0419	16r041A	16r041B	16r041C	16r041D	16r041E
	16r041F	16r042F	16r0420	16r0421	16r0422	16r0423	16r0416	16r0412
	16r042C	16r042B	16r0417	16r0428	16r042D	16r0429	16r0427	16r042A)! !

!ISO88591 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-1'!

unicodeMap
    ^#[	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r00A1	16r00A2	16r00A3	16r00A4	16r00A5	16r00A6	16r00A7
	16r00A8	16r00A9	16r00AA	16r00AB	16r00AC	16r00AD	16r00AE	16r00AF
	16r00B0	16r00B1	16r00B2	16r00B3	16r00B4	16r00B5	16r00B6	16r00B7
	16r00B8	16r00B9	16r00BA	16r00BB	16r00BC	16r00BD	16r00BE	16r00BF
	16r00C0	16r00C1	16r00C2	16r00C3	16r00C4	16r00C5	16r00C6	16r00C7
	16r00C8	16r00C9	16r00CA	16r00CB	16r00CC	16r00CD	16r00CE	16r00CF
	16r00D0	16r00D1	16r00D2	16r00D3	16r00D4	16r00D5	16r00D6	16r00D7
	16r00D8	16r00D9	16r00DA	16r00DB	16r00DC	16r00DD	16r00DE	16r00DF
	16r00E0	16r00E1	16r00E2	16r00E3	16r00E4	16r00E5	16r00E6	16r00E7
	16r00E8	16r00E9	16r00EA	16r00EB	16r00EC	16r00ED	16r00EE	16r00EF
	16r00F0	16r00F1	16r00F2	16r00F3	16r00F4	16r00F5	16r00F6	16r00F7
	16r00F8	16r00F9	16r00FA	16r00FB	16r00FC	16r00FD	16r00FE	16r00FF ]! !

!ISO88592 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-2'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r0104	16r02D8	16r0141	16r00A4	16r013D	16r015A	16r00A7
	16r00A8	16r0160	16r015E	16r0164	16r0179	16r00AD	16r017D	16r017B
	16r00B0	16r0105	16r02DB	16r0142	16r00B4	16r013E	16r015B	16r02C7
	16r00B8	16r0161	16r015F	16r0165	16r017A	16r02DD	16r017E	16r017C
	16r0154	16r00C1	16r00C2	16r0102	16r00C4	16r0139	16r0106	16r00C7
	16r010C	16r00C9	16r0118	16r00CB	16r011A	16r00CD	16r00CE	16r010E
	16r0110	16r0143	16r0147	16r00D3	16r00D4	16r0150	16r00D6	16r00D7
	16r0158	16r016E	16r00DA	16r0170	16r00DC	16r00DD	16r0162	16r00DF
	16r0155	16r00E1	16r00E2	16r0103	16r00E4	16r013A	16r0107	16r00E7
	16r010D	16r00E9	16r0119	16r00EB	16r011B	16r00ED	16r00EE	16r010F
	16r0111	16r0144	16r0148	16r00F3	16r00F4	16r0151	16r00F6	16r00F7
	16r0159	16r016F	16r00FA	16r0171	16r00FC	16r00FD	16r0163	16r02D9)! !

!ISO88593 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-3'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r0126	16r02D8	16r00A3	16r00A4	     -1	16r0124	16r00A7
	16r00A8	16r0130	16r015E	16r011E	16r0134	16r00AD	     -1	16r017B
	16r00B0	16r0127	16r00B2	16r00B3	16r00B4	16r00B5	16r0125	16r00B7
	16r00B8	16r0131	16r015F	16r011F	16r0135	16r00BD	     -1	16r017C
	16r00C0	16r00C1	16r00C2	     -1	16r00C4	16r010A	16r0108	16r00C7
	16r00C8	16r00C9	16r00CA	16r00CB	16r00CC	16r00CD	16r00CE	16r00CF
	     -1	16r00D1	16r00D2	16r00D3	16r00D4	16r0120	16r00D6	16r00D7
	16r011C	16r00D9	16r00DA	16r00DB	16r00DC	16r016C	16r015C	16r00DF
	16r00E0	16r00E1	16r00E2	     -1	16r00E4	16r010B	16r0109	16r00E7
	16r00E8	16r00E9	16r00EA	16r00EB	16r00EC	16r00ED	16r00EE	16r00EF
	     -1	16r00F1	16r00F2	16r00F3	16r00F4	16r0121	16r00F6	16r00F7
	16r011D	16r00F9	16r00FA	16r00FB	16r00FC	16r016D	16r015D	16r02D9)! !

!ISO88594 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-4'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r0104	16r0138	16r0156	16r00A4	16r0128	16r013B	16r00A7
	16r00A8	16r0160	16r0112	16r0122	16r0166	16r00AD	16r017D	16r00AF
	16r00B0	16r0105	16r02DB	16r0157	16r00B4	16r0129	16r013C	16r02C7
	16r00B8	16r0161	16r0113	16r0123	16r0167	16r014A	16r017E	16r014B
	16r0100	16r00C1	16r00C2	16r00C3	16r00C4	16r00C5	16r00C6	16r012E
	16r010C	16r00C9	16r0118	16r00CB	16r0116	16r00CD	16r00CE	16r012A
	16r0110	16r0145	16r014C	16r0136	16r00D4	16r00D5	16r00D6	16r00D7
	16r00D8	16r0172	16r00DA	16r00DB	16r00DC	16r0168	16r016A	16r00DF
	16r0101	16r00E1	16r00E2	16r00E3	16r00E4	16r00E5	16r00E6	16r012F
	16r010D	16r00E9	16r0119	16r00EB	16r0117	16r00ED	16r00EE	16r012B
	16r0111	16r0146	16r014D	16r0137	16r00F4	16r00F5	16r00F6	16r00F7
	16r00F8	16r0173	16r00FA	16r00FB	16r00FC	16r0169	16r016B	16r02D9)! !

!ISO88595 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-5'!

unicodeMap
    ^#( 16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r0401	16r0402	16r0403	16r0404	16r0405	16r0406	16r0407
	16r0408	16r0409	16r040A	16r040B	16r040C	16r00AD	16r040E	16r040F
	16r0410	16r0411	16r0412	16r0413	16r0414	16r0415	16r0416	16r0417
	16r0418	16r0419	16r041A	16r041B	16r041C	16r041D	16r041E	16r041F
	16r0420	16r0421	16r0422	16r0423	16r0424	16r0425	16r0426	16r0427
	16r0428	16r0429	16r042A	16r042B	16r042C	16r042D	16r042E	16r042F
	16r0430	16r0431	16r0432	16r0433	16r0434	16r0435	16r0436	16r0437
	16r0438	16r0439	16r043A	16r043B	16r043C	16r043D	16r043E	16r043F
	16r0440	16r0441	16r0442	16r0443	16r0444	16r0445	16r0446	16r0447
	16r0448	16r0449	16r044A	16r044B	16r044C	16r044D	16r044E	16r044F
	16r2116	16r0451	16r0452	16r0453	16r0454	16r0455	16r0456	16r0457
	16r0458	16r0459	16r045A	16r045B	16r045C	16r00A7	16r045E	16r045F)! !

!ISO88596 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-6'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	     -1	     -1	     -1	16r00A4	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	16r060C	16r00AD	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	16r061F
	     -1	16r0621	16r0622	16r0623	16r0624	16r0625	16r0626	16r0627
	16r0628	16r0629	16r062A	16r062B	16r062C	16r062D	16r062E	16r062F
	16r0630	16r0631	16r0632	16r0633	16r0634	16r0635	16r0636	16r0637
	16r0638	16r0639	16r063A	     -1	     -1	     -1	     -1	     -1
	16r0640	16r0641	16r0642	16r0643	16r0644	16r0645	16r0646	16r0647
	16r0648	16r0649	16r064A	16r064B	16r064C	16r064D	16r064E	16r064F
	16r0650	16r0651	16r0652	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1)! !

!ISO88597 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-7'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r201B	16r2019	16r00A3	     -1	     -1	16r00A6	16r00A7
	16r00A8	16r00A9	     -1	16r00AB	16r00AC	16r00AD	     -1	16r2015
	16r00B0	16r00B1	16r00B2	16r00B3	16r00B4	16r0385	16r0386	16r00B7
	16r0388	16r0389	16r038A	16r00BB	16r038C	16r00BD	16r038E	16r038F
	16r0390	16r0391	16r0392	16r0393	16r0394	16r0395	16r0396	16r0397
	16r0398	16r0399	16r039A	16r039B	16r039C	16r039D	16r039E	16r039F
	16r03A0	16r03A1	     -1	16r03A3	16r03A4	16r03A5	16r03A6	16r03A7
	16r03A8	16r03A9	16r03AA	16r03AB	16r03AC	16r03AD	16r03AE	16r03AF
	16r03B0	16r03B1	16r03B2	16r03B3	16r03B4	16r03B5	16r03B6	16r03B7
	16r03B8	16r03B9	16r03BA	16r03BB	16r03BC	16r03BD	16r03BE	16r03BF
	16r03C0	16r03C1	16r03C2	16r03C3	16r03C4	16r03C5	16r03C6	16r03C7
	16r03C8	16r03C9	16r03CA	16r03CB	16r03CC	16r03CD	16r03CE	     -1)! !

!ISO88598 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-8'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	     -1	16r00A2	16r00A3	16r00A4	16r00A5	16r00A6	16r00A7
	16r00A8	16r00A9	16r00D7	16r00AB	16r00AC	16r00AD	16r00AE	16r203E
	16r00B0	16r00B1	16r00B2	16r00B3	16r00B4	16r00B5	16r00B6	16r00B7
	16r00B8	16r00B9	16r00F7	16r00BB	16r00BC	16r00BD	16r00BE	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	     -1
	     -1	     -1	     -1	     -1	     -1	     -1	     -1	16r2017
	16r05D0	16r05D1	16r05D2	16r05D3	16r05D4	16r05D5	16r05D6	16r05D7
	16r05D8	16r05D9	16r05DA	16r05DB	16r05DC	16r05DD	16r05DE	16r05DF
	16r05E0	16r05E1	16r05E2	16r05E3	16r05E4	16r05E5	16r05E6	16r05E7
	16r05E8	16r05E9	16r05EA	     -1	     -1	     -1	     -1	     -1)! !

!ISO88599 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-9'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r00A1	16r00A2	16r00A3	16r00A4	16r00A5	16r00A6	16r00A7
	16r00A8	16r00A9	16r00AA	16r00AB	16r00AC	16r00AD	16r00AE	16r00AF
	16r00B0	16r00B1	16r00B2	16r00B3	16r00B4	16r00B5	16r00B6	16r00B7
	16r00B8	16r00B9	16r00BA	16r00BB	16r00BC	16r00BD	16r00BE	16r00BF
	16r00C0	16r00C1	16r00C2	16r00C3	16r00C4	16r00C5	16r00C6	16r00C7
	16r00C8	16r00C9	16r00CA	16r00CB	16r00CC	16r00CD	16r00CE	16r00CF
	16r011E	16r00D1	16r00D2	16r00D3	16r00D4	16r00D5	16r00D6	16r00D7
	16r00D8	16r00D9	16r00DA	16r00DB	16r00DC	16r0130	16r015E	16r00DF
	16r00E0	16r00E1	16r00E2	16r00E3	16r00E4	16r00E5	16r00E6	16r00E7
	16r00E8	16r00E9	16r00EA	16r00EB	16r00EC	16r00ED	16r00EE	16r00EF
	16r011F	16r00F1	16r00F2	16r00F3	16r00F4	16r00F5	16r00F6	16r00F7
	16r00F8	16r00F9	16r00FA	16r00FB	16r00FC	16r0131	16r015F	16r00FF)! !

!ISO885910 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-10'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r0104	16r0112	16r0122	16r012A	16r0128	16r0136	16r00A7
	16r013B	16r0110	16r0160	16r0166	16r017D	16r00AD	16r016A	16r014A
	16r00B0	16r0105	16r0113	16r0123	16r012B	16r0129	16r0137	16r00B7
	16r013C	16r0111	16r0161	16r0167	16r017E	16r2015	16r016B	16r014B
	16r0100	16r00C1	16r00C2	16r00C3	16r00C4	16r00C5	16r00C6	16r012E
	16r010C	16r00C9	16r0118	16r00CB	16r0116	16r00CD	16r00CE	16r00CF
	16r00D0	16r0145	16r014C	16r00D3	16r00D4	16r00D5	16r00D6	16r0168
	16r00D8	16r0172	16r00DA	16r00DB	16r00DC	16r00DD	16r00DE	16r00DF
	16r0101	16r00E1	16r00E2	16r00E3	16r00E4	16r00E5	16r00E6	16r012F
	16r010D	16r00E9	16r0119	16r00EB	16r0117	16r00ED	16r00EE	16r00EF
	16r00F0	16r0146	16r014D	16r00F3	16r00F4	16r00F5	16r00F6	16r0169
	16r00F8	16r0173	16r00FA	16r00FB	16r00FC	16r00FD	16r00FE	16r0138)! !

!ISO885913 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-13'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	     -1	16r00A2	16r00A3	16r00A4	     -1	16r00A6	16r00A7
	16r00D8	16r00A9	16r0156	16r00AB	16r00AC	16r00AD	16r00AE	16r00C6
	16r00B0	16r00B1	16r00B2	16r00B3	16r201C	16r00B5	16r00B6	16r00B7
	16r00F8	16r00B9	16r0157	16r00BB	16r00BC	16r00BD	16r00BE	16r00E6
	16r0104	16r012E	16r0100	16r0106	16r00C4	16r00C5	16r0118	16r0112
	16r010C	16r00C9	16r0179	16r0116	16r0122	16r0136	16r012A	16r013B
	16r0160	16r0143	16r0145	16r00D3	16r014C	16r00D5	16r00D6	16r00D7
	16r0172	16r0141	16r015A	16r016A	16r00DC	16r017B	16r017D	16r00DF
	16r0105	16r012F	16r0101	16r0107	16r00E4	16r00E5	16r0119	16r0113
	16r010D	16r00E9	16r017A	16r0117	16r0123	16r0137	16r012B	16r013C
	16r0161	16r0144	16r0146	16r00F3	16r014D	16r00F5	16r00F6	16r00F7
	16r0173	16r0142	16r015B	16r016B	16r00FC	16r017C	16r017E	16r2019)! !

!ISO885914 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-14'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r1E02	16r1E03	16r00A3	16r010A	16r010B	16r1E0A	16r00A7
	16r1E80	16r00A9	16r1E82	16r1E0B	16r1EF2	16r00AD	16r00AE	16r0178
	16r1E1E	16r1E1F	16r0120	16r0121	16r1E40	16r1E41	16r00B6	16r1E56
	16r1E81	16r1E57	16r1E83	16r1E60	16r1EF3	16r1E84	16r1E85	16r1E61
	16r00C0	16r00C1	16r00C2	16r00C3	16r00C4	16r00C5	16r00C6	16r00C7
	16r00C8	16r00C9	16r00CA	16r00CB	16r00CC	16r00CD	16r00CE	16r00CF
	16r0174	16r00D1	16r00D2	16r00D3	16r00D4	16r00D5	16r00D6	16r1E6A
	16r00D8	16r00D9	16r00DA	16r00DB	16r00DC	16r00DD	16r0176	16r00DF
	16r00E0	16r00E1	16r00E2	16r00E3	16r00E4	16r00E5	16r00E6	16r00E7
	16r00E8	16r00E9	16r00EA	16r00EB	16r00EC	16r00ED	16r00EE	16r00EF
	16r0175	16r00F1	16r00F2	16r00F3	16r00F4	16r00F5	16r00F6	16r1E6B
	16r00F8	16r00F9	16r00FA	16r00FB	16r00FC	16r00FD	16r0177	16r00FF)! !

!ISO885915 class methodsFor: 'Unicode'!

charsetName
    ^'ISO-8859-15'!

unicodeMap
    ^#(	16r0000	16r0001	16r0002	16r0003	16r0004	16r0005	16r0006	16r0007
	16r0008	16r0009	16r000A	16r000B	16r000C	16r000D	16r000E	16r000F
	16r0010	16r0011	16r0012	16r0013	16r0014	16r0015	16r0016	16r0017
	16r0018	16r0019	16r001A	16r001B	16r001C	16r001D	16r001E	16r001F
	16r0020	16r0021	16r0022	16r0023	16r0024	16r0025	16r0026	16r0027
	16r0028	16r0029	16r002A	16r002B	16r002C	16r002D	16r002E	16r002F
	16r0030	16r0031	16r0032	16r0033	16r0034	16r0035	16r0036	16r0037
	16r0038	16r0039	16r003A	16r003B	16r003C	16r003D	16r003E	16r003F
	16r0040	16r0041	16r0042	16r0043	16r0044	16r0045	16r0046	16r0047
	16r0048	16r0049	16r004A	16r004B	16r004C	16r004D	16r004E	16r004F
	16r0050	16r0051	16r0052	16r0053	16r0054	16r0055	16r0056	16r0057
	16r0058	16r0059	16r005A	16r005B	16r005C	16r005D	16r005E	16r005F
	16r0060	16r0061	16r0062	16r0063	16r0064	16r0065	16r0066	16r0067
	16r0068	16r0069	16r006A	16r006B	16r006C	16r006D	16r006E	16r006F
	16r0070	16r0071	16r0072	16r0073	16r0074	16r0075	16r0076	16r0077
	16r0078	16r0079	16r007A	16r007B	16r007C	16r007D	16r007E	16r007F
	16r0080	16r0081	16r0082	16r0083	16r0084	16r0085	16r0086	16r0087
	16r0088	16r0089	16r008A	16r008B	16r008C	16r008D	16r008E	16r008F
	16r0090	16r0091	16r0092	16r0093	16r0094	16r0095	16r0096	16r0097
	16r0098	16r0099	16r009A	16r009B	16r009C	16r009D	16r009E	16r009F
	16r00A0	16r00A1	16r00A2	16r00A3	16r20AC	16r00A5	16r0160	16r00A7
	16r0161	16r00A9	16r00AA	16r00AB	16r00AC	16r00AD	16r00AE	16r00AF
	16r00B0	16r00B1	16r00B2	16r00B3	16r017D	16r00B5	16r00B6	16r00B7
	16r017E	16r00B9	16r00BA	16r00BB	16r0152	16r0153	16r0178	16r00BF
	16r00C0	16r00C1	16r00C2	16r00C3	16r00C4	16r00C5	16r00C6	16r00C7
	16r00C8	16r00C9	16r00CA	16r00CB	16r00CC	16r00CD	16r00CE	16r00CF
	16r00D0	16r00D1	16r00D2	16r00D3	16r00D4	16r00D5	16r00D6	16r00D7
	16r00D8	16r00D9	16r00DA	16r00DB	16r00DC	16r00DD	16r00DE	16r00DF
	16r00E0	16r00E1	16r00E2	16r00E3	16r00E4	16r00E5	16r00E6	16r00E7
	16r00E8	16r00E9	16r00EA	16r00EB	16r00EC	16r00ED	16r00EE	16r00EF
	16r00F0	16r00F1	16r00F2	16r00F3	16r00F4	16r00F5	16r00F6	16r00F7
	16r00F8	16r00F9	16r00FA	16r00FB	16r00FC	16r00FD	16r00FE	16r00FF)! !

!JIS0201 class methodsFor: 'Unicode'!

charsetName
    ^'JIS-X0201'!

unicodeMap
    ^#( 16r0000 16r0001 16r0002 16r0003 16r0004 16r0005 16r0006 16r0007
        16r0008 16r0009 16r000A 16r000B 16r000C 16r000D 16r000E 16r000F
        16r0010 16r0011 16r0012 16r0013 16r0014 16r0015 16r0016 16r0017
        16r0018 16r0019 16r001A 16r001B 16r001C 16r001D 16r001E 16r001F
        16r0020 16r0021 16r0022 16r0023 16r0024 16r0025 16r0026 16r0027
        16r0028 16r0029 16r002A 16r002B 16r002C 16r002D 16r002E 16r002F
        16r0030 16r0031 16r0032 16r0033 16r0034 16r0035 16r0036 16r0037
        16r0038 16r0039 16r003A 16r003B 16r003C 16r003D 16r003E 16r003F
        16r0040 16r0041 16r0042 16r0043 16r0044 16r0045 16r0046 16r0047
        16r0048 16r0049 16r004A 16r004B 16r004C 16r004D 16r004E 16r004F
        16r0050 16r0051 16r0052 16r0053 16r0054 16r0055 16r0056 16r0057
        16r0058 16r0059 16r005A 16r005B 16r00A5 16r005D 16r005E 16r005F
        16r0060 16r0061 16r0062 16r0063 16r0064 16r0065 16r0066 16r0067
        16r0068 16r0069 16r006A 16r006B 16r006C 16r006D 16r006E 16r006F
        16r0070 16r0071 16r0072 16r0073 16r0074 16r0075 16r0076 16r0077
        16r0078 16r0079 16r007A 16r007B 16r007C 16r007D 16r203E 16r007F
             -1      -1      -1      -1      -1      -1      -1      -1
             -1      -1      -1      -1      -1      -1      -1      -1
             -1      -1      -1      -1      -1      -1      -1      -1
             -1      -1      -1      -1      -1      -1      -1      -1
             -1 16rFF61 16rFF62 16rFF63 16rFF64 16rFF65 16rFF66 16rFF67
        16rFF68 16rFF69 16rFF6A 16rFF6B 16rFF6C 16rFF6D 16rFF6E 16rFF6F
        16rFF70 16rFF71 16rFF72 16rFF73 16rFF74 16rFF75 16rFF76 16rFF77
        16rFF78 16rFF79 16rFF7A 16rFF7B 16rFF7C 16rFF7D 16rFF7E 16rFF7F
        16rFF80 16rFF81 16rFF82 16rFF83 16rFF84 16rFF85 16rFF86 16rFF87
        16rFF88 16rFF89 16rFF8A 16rFF8B 16rFF8C 16rFF8D 16rFF8E 16rFF8F
        16rFF90 16rFF91 16rFF92 16rFF93 16rFF94 16rFF95 16rFF96 16rFF97
        16rFF98 16rFF99 16rFF9A 16rFF9B 16rFF9C 16rFF9D 16rFF9E 16rFF9F
             -1      -1      -1      -1      -1      -1      -1      -1
             -1      -1      -1      -1      -1      -1      -1      -1
             -1      -1      -1      -1      -1      -1      -1      -1
             -1      -1      -1      -1      -1      -1      -1      -1)! !

Namespace current: Smalltalk!
