#! /bin/sh

#######################################################################
#
#   DBCS table creation driver
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
# Written by Paolo Bonzini.
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

if test $# -lt 1; then
  echo "usage: tables unicode_file" 1>&2
  echo "" 1>&2
  echo "The standard input is read, and lines reading \`%table_xxx' are" 1>&2
  echo "replaced with the output of the appropriate program (which is fed" 1>&2
  echo "with the information in unicode_file.  The output is written on the" 1>&2
  echo "standard output." 1>&2
  exit 1
fi

unicode_file=$1
AWK=${AWK:-"@AWK@"}

# `exec $0' effectively invokes help
test -z "$unicode_file" && exec $0
test -f "$unicode_file" || exec $0

pid=$$

# First process the input file into a more compact form,
# with all comments removed, and sorted according to both
# DBCS and Unicode value.
$AWK '
  BEGIN          { FS="[ \t]*#" }        # Comment mark
  /NO MAPPING/   { next }                # Remove unmapped BIG5 characters
  length($1) > 0 { print $1 }            # Cut at first comment mark
' $unicode_file | sort > from.$pid

$AWK '
  { print $NF, $(NF-1) }
' from.$pid | sort > to.$pid

# Now prepare the tables and work on the Smalltalk template.

./table_from from.$pid > from_table.$pid
./table_ind to.$pid > ind_table.$pid
./table_to to.$pid > to_table.$pid

rm -f from.$pid to.$pid 

sed -e "
  /^%table_from/ r from_table.$pid
  /^%table_ind/  r ind_table.$pid
  /^%table_to/   r to_table.$pid
  /^%/           d"

rm -f from_table.$pid to_table.$pid ind_table.$pid
